/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.internal.core.java.inlayhint;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.lsp4mp.jdt.core.java.inlayhint.JavaASTInlayHint;
import org.eclipse.lsp4mp.jdt.core.java.inlayhint.JavaInlayHintsContext;

public class JavaASTInlayHintRegistry
implements IRegistryChangeListener {
    private static final Logger LOGGER = Logger.getLogger(JavaASTInlayHintRegistry.class.getName());
    private static final JavaASTInlayHintRegistry INSTANCE = new JavaASTInlayHintRegistry();
    private static final String EXTENSION_ID = "javaASTInlayHints";
    private static final String INLAY_HINT_ELT = "inlayHint";
    private static final String CLASS_ATTR = "class";
    private boolean extensionProvidersLoaded = false;
    private boolean registryListenerIntialized = false;
    private final List<IConfigurationElement> inlayHintsFromClass = new ArrayList<IConfigurationElement>();

    public static JavaASTInlayHintRegistry getInstance() {
        return INSTANCE;
    }

    private JavaASTInlayHintRegistry() {
    }

    public String getExtensionId() {
        return EXTENSION_ID;
    }

    private synchronized void loadExtensionJavaASTInlayHints() {
        if (this.extensionProvidersLoaded) {
            return;
        }
        this.extensionProvidersLoaded = true;
        LOGGER.log(Level.INFO, "->- Loading ." + this.getExtensionId() + " extension point ->-");
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor("org.eclipse.lsp4mp.jdt.core", this.getExtensionId());
        this.addExtensionJavaASTInlayHints(cf);
        this.addRegistryListenerIfNeeded();
        LOGGER.log(Level.INFO, "-<- Done loading ." + this.getExtensionId() + " extension point -<-");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registryChanged(IRegistryChangeEvent event) {
        IExtensionDelta[] deltas = event.getExtensionDeltas("org.eclipse.lsp4mp.jdt.core", this.getExtensionId());
        if (deltas != null) {
            JavaASTInlayHintRegistry javaASTInlayHintRegistry = this;
            synchronized (javaASTInlayHintRegistry) {
                IExtensionDelta[] iExtensionDeltaArray = deltas;
                int n = deltas.length;
                int n2 = 0;
                while (n2 < n) {
                    IExtensionDelta delta = iExtensionDeltaArray[n2];
                    IConfigurationElement[] cf = delta.getExtension().getConfigurationElements();
                    if (delta.getKind() == 1) {
                        this.addExtensionJavaASTInlayHints(cf);
                    }
                    ++n2;
                }
            }
        }
    }

    private void addExtensionJavaASTInlayHints(IConfigurationElement[] cf) {
        IConfigurationElement[] iConfigurationElementArray = cf;
        int n = cf.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            try {
                if (INLAY_HINT_ELT.equals(ce.getName())) {
                    this.inlayHintsFromClass.add(ce);
                }
                String pluginId = ce.getNamespaceIdentifier();
                LOGGER.log(Level.INFO, "  Loaded " + this.getExtensionId() + ": " + pluginId);
            }
            catch (Throwable t) {
                LOGGER.log(Level.SEVERE, "  Loaded while loading " + this.getExtensionId(), t);
            }
            ++n2;
        }
    }

    private void addRegistryListenerIfNeeded() {
        if (this.registryListenerIntialized) {
            return;
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        registry.addRegistryChangeListener((IRegistryChangeListener)this, "org.eclipse.lsp4mp.jdt.core");
        this.registryListenerIntialized = true;
    }

    public void destroy() {
        Platform.getExtensionRegistry().removeRegistryChangeListener((IRegistryChangeListener)this);
    }

    public void initialize() {
    }

    public Collection<ASTVisitor> getInlayHints(JavaInlayHintsContext context, IProgressMonitor monitor) {
        this.loadExtensionJavaASTInlayHints();
        ArrayList<ASTVisitor> inlayHints = new ArrayList<ASTVisitor>();
        for (IConfigurationElement ce : this.inlayHintsFromClass) {
            try {
                JavaASTInlayHint inlayHint = (JavaASTInlayHint)((Object)ce.createExecutableExtension(CLASS_ATTR));
                this.addInlayHint(inlayHint, context, monitor, inlayHints);
            }
            catch (CoreException e) {
                LOGGER.log(Level.SEVERE, "  Error while creating JavaASTInlayHint " + ce.getAttribute(CLASS_ATTR), e);
            }
        }
        return inlayHints;
    }

    private void addInlayHint(JavaASTInlayHint inlayHint, JavaInlayHintsContext context, IProgressMonitor monitor, List<ASTVisitor> inlayHints) {
        inlayHint.initialize(context);
        try {
            if (inlayHint.isAdaptedForInlayHints(context, monitor)) {
                inlayHints.add(inlayHint);
            }
        }
        catch (CoreException e) {
            LOGGER.log(Level.SEVERE, "  Error while adding inlayHint JavaASTInlayHint " + ((Object)((Object)inlayHint)).getClass().getName(), e);
        }
    }
}

