/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.core.java.definition;

import java.util.List;
import java.util.function.Function;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4mp.commons.MicroProfileDefinition;
import org.eclipse.lsp4mp.jdt.core.java.PropertyReplacerStrategy;
import org.eclipse.lsp4mp.jdt.core.java.definition.IJavaDefinitionParticipant;
import org.eclipse.lsp4mp.jdt.core.java.definition.JavaDefinitionContext;
import org.eclipse.lsp4mp.jdt.core.utils.AnnotationMemberInfo;
import org.eclipse.lsp4mp.jdt.core.utils.AnnotationUtils;
import org.eclipse.lsp4mp.jdt.core.utils.IJDTUtils;
import org.eclipse.lsp4mp.jdt.core.utils.JDTTypeUtils;

public abstract class AbstractAnnotationDefinitionParticipant
implements IJavaDefinitionParticipant {
    private final String annotationName;
    private final String[] annotationMemberNames;
    private final Function<String, String> propertyReplacer;

    public AbstractAnnotationDefinitionParticipant(String annotationName, String[] annotationMemberNames) {
        this(annotationName, annotationMemberNames, PropertyReplacerStrategy.NULL_REPLACER);
    }

    public AbstractAnnotationDefinitionParticipant(String annotationName, String[] annotationMemberNames, Function<String, String> propertyReplacer) {
        this.annotationName = annotationName;
        this.annotationMemberNames = annotationMemberNames;
        this.propertyReplacer = propertyReplacer;
    }

    @Override
    public boolean isAdaptedForDefinition(JavaDefinitionContext context, IProgressMonitor monitor) throws JavaModelException {
        IJavaProject javaProject = context.getJavaProject();
        return JDTTypeUtils.findType(javaProject, this.annotationName) != null;
    }

    @Override
    public List<MicroProfileDefinition> collectDefinitions(JavaDefinitionContext context, IProgressMonitor monitor) throws CoreException {
        ITypeRoot typeRoot = context.getTypeRoot();
        IJDTUtils utils = context.getUtils();
        IJavaProject javaProject = typeRoot.getJavaProject();
        if (javaProject == null) {
            return null;
        }
        IJavaElement hyperlinkedElement = context.getHyperlinkedElement();
        if (!this.isAdaptableFor(hyperlinkedElement)) {
            return null;
        }
        Position definitionPosition = context.getHyperlinkedPosition();
        IAnnotation annotation = AnnotationUtils.getFirstAnnotation((IAnnotatable)hyperlinkedElement, this.annotationName);
        if (annotation == null) {
            return null;
        }
        AnnotationMemberInfo annotationMemberInfo = AnnotationUtils.getAnnotationMemberAt(annotation, this.annotationMemberNames, definitionPosition, typeRoot, utils);
        if (annotationMemberInfo == null) {
            return null;
        }
        String annotationMemberValue = annotationMemberInfo.getMemberValue();
        if (this.propertyReplacer != null) {
            annotationMemberValue = this.propertyReplacer.apply(annotationMemberValue);
        }
        Range annotationMemberValueRange = annotationMemberInfo.getRange();
        return this.collectDefinitions(annotationMemberValue, annotationMemberValueRange, annotation, context, monitor);
    }

    protected boolean isAdaptableFor(IJavaElement hyperlinkedElement) {
        return hyperlinkedElement.getElementType() == 8 || hyperlinkedElement.getElementType() == 14 || hyperlinkedElement.getElementType() == 9;
    }

    protected abstract List<MicroProfileDefinition> collectDefinitions(String var1, Range var2, IAnnotation var3, JavaDefinitionContext var4, IProgressMonitor var5) throws JavaModelException;
}

