/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.internal.reactivemessaging.properties;

import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.lsp4mp.commons.metadata.ItemHint;
import org.eclipse.lsp4mp.commons.metadata.ValueHint;
import org.eclipse.lsp4mp.jdt.core.AbstractAnnotationTypeReferencePropertiesProvider;
import org.eclipse.lsp4mp.jdt.core.SearchContext;
import org.eclipse.lsp4mp.jdt.core.utils.AnnotationUtils;
import org.eclipse.lsp4mp.jdt.core.utils.JDTTypeUtils;

public class MicroProfileReactiveMessagingProvider
extends AbstractAnnotationTypeReferencePropertiesProvider {
    private static final String[] ANNOTATION_NAMES = new String[]{"org.eclipse.microprofile.reactive.messaging.spi.Connector", "org.eclipse.microprofile.reactive.messaging.Incoming", "org.eclipse.microprofile.reactive.messaging.Outgoing", "org.eclipse.microprofile.reactive.messaging.Channel"};

    @Override
    protected String[] getAnnotationNames() {
        return ANNOTATION_NAMES;
    }

    @Override
    protected void processAnnotation(IJavaElement javaElement, IAnnotation mprmAnnotation, String annotationName, SearchContext context, IProgressMonitor monitor) throws JavaModelException {
        switch (annotationName) {
            case "org.eclipse.microprofile.reactive.messaging.spi.Connector": {
                this.processConnector(javaElement, mprmAnnotation, context);
                break;
            }
            case "org.eclipse.microprofile.reactive.messaging.Incoming": {
                this.processIncomingChannel(javaElement, mprmAnnotation, context);
                break;
            }
            case "org.eclipse.microprofile.reactive.messaging.Channel": {
                if (!MicroProfileReactiveMessagingProvider.isChannelField(javaElement)) break;
                this.processOutgoingChannel(javaElement, mprmAnnotation, context);
                break;
            }
            case "org.eclipse.microprofile.reactive.messaging.Outgoing": {
                this.processOutgoingChannel(javaElement, mprmAnnotation, context);
                break;
            }
        }
    }

    private static boolean isChannelField(IJavaElement element) {
        return element.getElementType() == 8;
    }

    private void processIncomingChannel(IJavaElement javaElement, IAnnotation incomingAnnotation, SearchContext context) throws JavaModelException {
        this.processChannelConnector(javaElement, incomingAnnotation, MessageType.INCOMING, context);
    }

    private void processOutgoingChannel(IJavaElement javaElement, IAnnotation outgoingAnnotation, SearchContext context) throws JavaModelException {
        this.processChannelConnector(javaElement, outgoingAnnotation, MessageType.OUTGOING, context);
    }

    private void processChannelConnector(IJavaElement javaElement, IAnnotation incomingOrOutgoingAnnotation, MessageType messageType, SearchContext context) throws JavaModelException {
        String channelName = AnnotationUtils.getAnnotationMemberValue(incomingOrOutgoingAnnotation, "value");
        if (StringUtils.isBlank((CharSequence)channelName)) {
            return;
        }
        String sourceType = JDTTypeUtils.getSourceType(javaElement);
        String sourceMethod = null;
        String sourceField = null;
        if (javaElement.getElementType() == 9) {
            IMethod method = (IMethod)javaElement;
            sourceMethod = JDTTypeUtils.getSourceMethod(method);
        } else if (javaElement.getElementType() == 8) {
            IField field = (IField)javaElement;
            sourceField = JDTTypeUtils.getSourceField((IJavaElement)field);
        }
        boolean binary = JDTTypeUtils.isBinary(javaElement);
        String description = null;
        String type = "org.eclipse.microprofile.reactive.messaging.spi.Connector";
        this.addMpMessagingItem(channelName, false, "connector", messageType, sourceType, sourceField, sourceMethod, binary, type, description, null, context);
    }

    private void processConnector(IJavaElement javaElement, IAnnotation connectorAnnotation, SearchContext context) throws JavaModelException {
        IAnnotation[] annotations;
        String connectorName = AnnotationUtils.getAnnotationMemberValue(connectorAnnotation, "value");
        String connectorHint = MicroProfileReactiveMessagingProvider.getHint("mp.messaging.connector.", javaElement);
        String description = null;
        String sourceType = JDTTypeUtils.getSourceType(javaElement);
        MicroProfileReactiveMessagingProvider.fillValueHint(connectorHint, connectorName, description, sourceType, context);
        boolean binary = JDTTypeUtils.isBinary(javaElement);
        IAnnotation[] iAnnotationArray = annotations = ((IAnnotatable)javaElement).getAnnotations();
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            IAnnotation connectorAttributeAnnotation = iAnnotationArray[n2];
            if (AnnotationUtils.isMatchAnnotation(connectorAttributeAnnotation, "io.smallrye.reactive.messaging.annotations.ConnectorAttribute")) {
                this.processConnectorAttribute(connectorName, connectorAttributeAnnotation, sourceType, binary, context);
            } else if (AnnotationUtils.isMatchAnnotation(connectorAttributeAnnotation, "io.smallrye.reactive.messaging.annotations.ConnectorAttributes")) {
                IMemberValuePair[] iMemberValuePairArray = connectorAttributeAnnotation.getMemberValuePairs();
                int n3 = iMemberValuePairArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IMemberValuePair pair = iMemberValuePairArray[n4];
                    if (pair.getValue() instanceof Object[]) {
                        Object[] connectorAttributeAnnotations;
                        Object[] objectArray = connectorAttributeAnnotations = (Object[])pair.getValue();
                        int n5 = connectorAttributeAnnotations.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            Object annotation = objectArray[n6];
                            if (annotation instanceof IAnnotation) {
                                this.processConnectorAttribute(connectorName, (IAnnotation)annotation, sourceType, binary, context);
                            }
                            ++n6;
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private void processConnectorAttribute(String connectorName, IAnnotation connectorAnnotation, String sourceType, boolean binary, SearchContext context) throws JavaModelException {
        String attributeName = AnnotationUtils.getAnnotationMemberValue(connectorAnnotation, "name");
        String type = this.getType(AnnotationUtils.getAnnotationMemberValue(connectorAnnotation, "type"));
        String description = AnnotationUtils.getAnnotationMemberValue(connectorAnnotation, "description");
        String defaultValue = AnnotationUtils.getAnnotationMemberValue(connectorAnnotation, "defaultValue");
        if (StringUtils.isEmpty((CharSequence)defaultValue)) {
            defaultValue = null;
        }
        Direction direction = MicroProfileReactiveMessagingProvider.getDirection(AnnotationUtils.getAnnotationMemberValue(connectorAnnotation, "direction"));
        switch (direction) {
            case INCOMING: {
                this.addMpMessagingItem(connectorName, true, attributeName, MessageType.INCOMING, sourceType, null, null, binary, type, description, defaultValue, context);
                break;
            }
            case OUTGOING: {
                this.addMpMessagingItem(connectorName, true, attributeName, MessageType.OUTGOING, sourceType, null, null, binary, type, description, defaultValue, context);
                break;
            }
            case INCOMING_AND_OUTGOING: {
                this.addMpMessagingItem(connectorName, true, attributeName, MessageType.INCOMING, sourceType, null, null, binary, type, description, defaultValue, context);
                this.addMpMessagingItem(connectorName, true, attributeName, MessageType.OUTGOING, sourceType, null, null, binary, type, description, defaultValue, context);
            }
        }
        this.addMpMessagingItem(connectorName, false, attributeName, MessageType.CONNECTOR, sourceType, null, null, binary, type, description, defaultValue, context);
    }

    private void addMpMessagingItem(String connectorOrChannelName, boolean dynamic, String attributeName, MessageType messageType, String sourceType, String sourceField, String sourceMethod, boolean binary, String type, String description, String defaultValue, SearchContext context) {
        String propertyName = MicroProfileReactiveMessagingProvider.getMPMessagingName(messageType, dynamic, connectorOrChannelName, attributeName);
        super.addItemMetadata(context.getCollector(), propertyName, type, description, sourceType, sourceField, sourceMethod, defaultValue, null, binary);
    }

    private static Direction getDirection(String connectorAttributeType) {
        if (connectorAttributeType != null) {
            if (connectorAttributeType.endsWith("INCOMING_AND_OUTGOING")) {
                return Direction.INCOMING_AND_OUTGOING;
            }
            if (connectorAttributeType.endsWith("INCOMING")) {
                return Direction.INCOMING;
            }
            if (connectorAttributeType.endsWith("OUTGOING")) {
                return Direction.OUTGOING;
            }
        }
        return Direction.INCOMING_AND_OUTGOING;
    }

    private String getType(String connectorAttributeType) {
        if (StringUtils.isEmpty((CharSequence)connectorAttributeType)) {
            return null;
        }
        if (connectorAttributeType.equals("string")) {
            return "java.lang.String";
        }
        return connectorAttributeType;
    }

    private static String getMPMessagingName(MessageType messageType, boolean dynamic, String connectorOrChannelName, String attributeName) {
        StringBuilder propertyName = new StringBuilder("mp.messaging");
        propertyName.append('.');
        propertyName.append(messageType.name().toLowerCase());
        propertyName.append('.');
        if (dynamic) {
            propertyName.append("${");
        }
        propertyName.append(connectorOrChannelName);
        if (dynamic) {
            propertyName.append("}");
        }
        propertyName.append('.');
        propertyName.append(attributeName);
        return propertyName.toString();
    }

    private static void fillValueHint(String hint, String value, String description, String sourceType, SearchContext context) {
        if (hint == null || value == null) {
            return;
        }
        ItemHint itemHint = context.getCollector().getItemHint(hint);
        ValueHint valueHint = new ValueHint();
        valueHint.setValue(value);
        valueHint.setDescription(description);
        valueHint.setSourceType(sourceType);
        itemHint.getValues().add(valueHint);
    }

    private static String getHint(String baseKey, IJavaElement javaElement) {
        StringBuilder hint = new StringBuilder("${").append(baseKey);
        if (javaElement != null) {
            hint.append(JDTTypeUtils.isBinary(javaElement) ? "binary" : "source");
        }
        return hint.append("}").toString();
    }

    private static enum Direction {
        INCOMING,
        OUTGOING,
        INCOMING_AND_OUTGOING;

    }

    private static enum MessageType {
        INCOMING,
        OUTGOING,
        CONNECTOR;

    }
}

