/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.commons.runtime;

public enum ExecutionMode {
    SAFE(1, "safe"),
    FULL(2, "full");

    private final int value;
    private final String name;

    private ExecutionMode(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public static ExecutionMode forValue(int value) {
        ExecutionMode[] allValues = ExecutionMode.values();
        if (value < 1 || value > allValues.length) {
            throw new IllegalArgumentException("Illegal enum value: " + value);
        }
        return allValues[value - 1];
    }

    public static ExecutionMode forValue(String value) {
        if (value == null) {
            return SAFE;
        }
        ExecutionMode[] executionModeArray = ExecutionMode.values();
        int n = executionModeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ExecutionMode mode = executionModeArray[n2];
            if (mode.name.equalsIgnoreCase(value)) {
                return mode;
            }
            ++n2;
        }
        return SAFE;
    }
}

