/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.external.api.model;

import com.google.gson.annotations.SerializedName;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.lsat.external.api.model.LsatBase;

public class StochasticMeasurements
extends LsatBase {
    public static final String SERIALIZED_NAME_START_TIME = "startTime";
    @SerializedName(value="startTime")
    @Nonnull
    private List<Double> startTime = new ArrayList<Double>();
    public static final String SERIALIZED_NAME_DURATION = "duration";
    @SerializedName(value="duration")
    @Nonnull
    private List<Double> duration = new ArrayList<Double>();
    public static final String SERIALIZED_NAME_END_TIME = "endTime";
    @SerializedName(value="endTime")
    @Nullable
    private List<Double> endTime = new ArrayList<Double>();
    public static final String SERIALIZED_NAME_CRITICAL = "critical";
    @SerializedName(value="critical")
    @Nonnull
    private List<Double> critical = new ArrayList<Double>();

    public StochasticMeasurements() {
    }

    public StochasticMeasurements(List<Double> endTime) {
        this();
        this.endTime = endTime;
    }

    public StochasticMeasurements startTime(@Nonnull List<Double> startTime) {
        this.startTime = startTime;
        return this;
    }

    public StochasticMeasurements addStartTimeItem(Double startTimeItem) {
        if (this.startTime == null) {
            this.startTime = new ArrayList<Double>();
        }
        this.startTime.add(startTimeItem);
        return this;
    }

    @Nonnull
    public List<Double> getStartTime() {
        return this.startTime;
    }

    public void setStartTime(@Nonnull List<Double> startTime) {
        this.startTime = startTime;
    }

    public StochasticMeasurements duration(@Nonnull List<Double> duration) {
        this.duration = duration;
        return this;
    }

    public StochasticMeasurements addDurationItem(Double durationItem) {
        if (this.duration == null) {
            this.duration = new ArrayList<Double>();
        }
        this.duration.add(durationItem);
        return this;
    }

    @Nonnull
    public List<Double> getDuration() {
        return this.duration;
    }

    public void setDuration(@Nonnull List<Double> duration) {
        this.duration = duration;
    }

    @Nullable
    public List<Double> getEndTime() {
        ArrayList<Double> endTime = new ArrayList<Double>(this.startTime.size());
        int i = 0;
        while (i < this.startTime.size()) {
            endTime.add(this.startTime.get(i) + this.duration.get(i));
            ++i;
        }
        return endTime;
    }

    public StochasticMeasurements critical(@Nonnull List<Double> critical) {
        this.critical = critical;
        return this;
    }

    public StochasticMeasurements addCriticalItem(Double criticalItem) {
        if (this.critical == null) {
            this.critical = new ArrayList<Double>();
        }
        this.critical.add(criticalItem);
        return this;
    }

    @Nonnull
    public List<Double> getCritical() {
        return this.critical;
    }

    public void setCritical(@Nonnull List<Double> critical) {
        this.critical = critical;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StochasticMeasurements stochasticMeasurements = (StochasticMeasurements)o;
        return Objects.equals(this.startTime, stochasticMeasurements.startTime) && Objects.equals(this.duration, stochasticMeasurements.duration) && Objects.equals(this.endTime, stochasticMeasurements.endTime) && Objects.equals(this.critical, stochasticMeasurements.critical);
    }

    public int hashCode() {
        return Objects.hash(this.startTime, this.duration, this.endTime, this.critical);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StochasticMeasurements {\n");
        sb.append("    startTime: ").append(this.toIndentedString(this.startTime)).append("\n");
        sb.append("    duration: ").append(this.toIndentedString(this.duration)).append("\n");
        sb.append("    endTime: ").append(this.toIndentedString(this.endTime)).append("\n");
        sb.append("    critical: ").append(this.toIndentedString(this.critical)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

