/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.xtend.annotations;

import java.util.Queue;
import org.eclipse.xtend.lib.macro.AbstractMethodProcessor;
import org.eclipse.xtend.lib.macro.TransformationContext;
import org.eclipse.xtend.lib.macro.declaration.Element;
import org.eclipse.xtend.lib.macro.declaration.MutableClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableMethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableParameterDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.Type;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtend.lib.macro.declaration.Visibility;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class TransformCompilationParticipant
extends AbstractMethodProcessor {
    public void doTransform(MutableMethodDeclaration annotatedMethod, @Extension TransformationContext context) {
        boolean _not;
        annotatedMethod.markAsRead();
        boolean _isStatic = annotatedMethod.isStatic();
        if (_isStatic) {
            context.addError((Element)annotatedMethod, "Transformation methods cannot be static");
            return;
        }
        MutableTypeDeclaration _declaringType = annotatedMethod.getDeclaringType();
        boolean bl = _not = !(_declaringType instanceof MutableClassDeclaration);
        if (_not) {
            context.addError((Element)annotatedMethod, "Transformation methods should be declared on class");
            return;
        }
        String transformName = annotatedMethod.getSimpleName();
        annotatedMethod.setSimpleName("_transform_" + transformName);
        annotatedMethod.setVisibility(Visibility.PRIVATE);
        Procedures.Procedure1 _function = it -> {
            it.setVisibility(Visibility.PUBLIC);
            it.setFinal(annotatedMethod.isFinal());
            it.setSynchronized(true);
            it.setReturnType(annotatedMethod.getReturnType());
            it.setExceptions((TypeReference[])Conversions.unwrapArray((Object)annotatedMethod.getExceptions(), TypeReference.class));
            Iterable _parameters = annotatedMethod.getParameters();
            for (MutableParameterDeclaration parameter : _parameters) {
                it.addParameter(parameter.getSimpleName(), parameter.getType());
            }
            StringConcatenationClient _client = new StringConcatenationClient((MutableMethodDeclaration)it, annotatedMethod){
                private final /* synthetic */ MutableMethodDeclaration val$it;
                private final /* synthetic */ MutableMethodDeclaration val$annotatedMethod;
                {
                    this.val$it = mutableMethodDeclaration;
                    this.val$annotatedMethod = mutableMethodDeclaration2;
                }

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    boolean _not_1;
                    boolean _not;
                    boolean _isVoid = this.val$it.getReturnType().isVoid();
                    boolean bl = _not = !_isVoid;
                    if (_not) {
                        String _simpleName = this.val$it.getReturnType().getSimpleName();
                        _builder.append((Object)_simpleName);
                        _builder.append((Object)" result = ");
                    }
                    String _simpleName_1 = this.val$annotatedMethod.getSimpleName();
                    _builder.append((Object)_simpleName_1);
                    _builder.append((Object)"(");
                    Iterable _parameters = this.val$annotatedMethod.getParameters();
                    boolean _hasElements = false;
                    for (MutableParameterDeclaration parameter : _parameters) {
                        if (!_hasElements) {
                            _hasElements = true;
                        } else {
                            _builder.appendImmediate((Object)", ", "");
                        }
                        String _simpleName_2 = parameter.getSimpleName();
                        _builder.append((Object)_simpleName_2);
                    }
                    _builder.append((Object)");");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"_performLateFunctions();");
                    _builder.newLine();
                    boolean _isVoid_1 = this.val$it.getReturnType().isVoid();
                    boolean bl2 = _not_1 = !_isVoid_1;
                    if (_not_1) {
                        _builder.append((Object)"return result;");
                    }
                    _builder.newLineIfNotEmpty();
                }
            };
            it.setBody(_client);
        };
        annotatedMethod.getDeclaringType().addMethod(transformName, _function);
        MutableTypeDeclaration _declaringType_1 = annotatedMethod.getDeclaringType();
        this.doTransform((MutableClassDeclaration)_declaringType_1, context);
    }

    public void doTransform(MutableClassDeclaration annotatedClass, @Extension TransformationContext context) {
        Functions.Function1 _function = it -> it.getDeclaration().getSimpleName();
        boolean _contains = IterableExtensions.contains((Iterable)IterableExtensions.map((Iterable)context.newTypeReference((Type)annotatedClass, new TypeReference[0]).getAllResolvedMethods(), (Functions.Function1)_function), (Object)"late");
        if (_contains) {
            return;
        }
        Procedures.Procedure1 _function_1 = it -> {
            it.setVisibility(Visibility.PRIVATE);
            it.setFinal(true);
            it.setType(context.newTypeReference(Queue.class, new TypeReference[]{context.newTypeReference(Runnable.class, new TypeReference[0])}));
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"new java.util.LinkedList<>()");
                }
            };
            it.setInitializer(_client);
        };
        annotatedClass.addField("_lateFunctions", _function_1);
        Procedures.Procedure1 _function_2 = it -> {
            it.setVisibility(Visibility.PROTECTED);
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"while (!_lateFunctions.isEmpty()) {");
                    _builder.newLine();
                    _builder.append((Object)"    ");
                    _builder.append((Object)"_lateFunctions.remove().run();");
                    _builder.newLine();
                    _builder.append((Object)"}");
                    _builder.newLine();
                }
            };
            it.setBody(_client);
        };
        annotatedClass.addMethod("_performLateFunctions", _function_2);
        Procedures.Procedure1 _function_3 = it -> {
            it.setDocComment("Late functions are executed at the end of the transformation, just before returning the result.");
            it.setVisibility(Visibility.PROTECTED);
            it.setFinal(true);
            it.addParameter("function", context.newTypeReference(Runnable.class, new TypeReference[0]));
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"_lateFunctions.add(function);");
                }
            };
            it.setBody(_client);
        };
        annotatedClass.addMethod("late", _function_3);
    }
}

