/**
 */
package product.util;

import common.HasName;
import common.TypeDefinition;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.util.Switch;

import product.*;

/**
 * <!-- begin-user-doc -->
 * The <b>Switch</b> for the model's inheritance hierarchy.
 * It supports the call {@link #doSwitch(EObject) doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object
 * and proceeding up the inheritance hierarchy
 * until a non-null result is returned,
 * which is the result of the switch.
 * <!-- end-user-doc -->
 * @see product.ProductPackage
 * @generated
 */
public class ProductSwitch<T> extends Switch<T>
{
    /**
     * The cached model package
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected static ProductPackage modelPackage;

    /**
     * Creates an instance of the switch.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public ProductSwitch()
    {
        if (modelPackage == null)
        {
            modelPackage = ProductPackage.eINSTANCE;
        }
    }

    /**
     * Checks whether this is a switch for the given package.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @param ePackage the package in question.
     * @return whether this is a switch for the given package.
     * @generated
     */
    @Override
    protected boolean isSwitchFor(EPackage ePackage)
    {
        return ePackage == modelPackage;
    }

    /**
     * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the first non-null result returned by a <code>caseXXX</code> call.
     * @generated
     */
    @Override
    protected T doSwitch(int classifierID, EObject theEObject)
    {
        switch (classifierID)
        {
            case ProductPackage.PRODUCT_DEFINITION:
            {
                ProductDefinition productDefinition = (ProductDefinition)theEObject;
                T result = caseProductDefinition(productDefinition);
                if (result == null) result = caseIProductDefinition(productDefinition);
                if (result == null) result = caseTypeDefinition(productDefinition);
                if (result == null) result = caseHasName(productDefinition);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case ProductPackage.PROPERTY_DEFINITION:
            {
                PropertyDefinition propertyDefinition = (PropertyDefinition)theEObject;
                T result = casePropertyDefinition(propertyDefinition);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case ProductPackage.PROPERTY:
            {
                Property property = (Property)theEObject;
                T result = caseProperty(property);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case ProductPackage.PRODUCT_VALUE:
            {
                ProductValue productValue = (ProductValue)theEObject;
                T result = caseProductValue(productValue);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case ProductPackage.STRING_VALUE:
            {
                StringValue stringValue = (StringValue)theEObject;
                T result = caseStringValue(stringValue);
                if (result == null) result = caseProductValue(stringValue);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case ProductPackage.BOOLEAN_VALUE:
            {
                BooleanValue booleanValue = (BooleanValue)theEObject;
                T result = caseBooleanValue(booleanValue);
                if (result == null) result = caseProductValue(booleanValue);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case ProductPackage.INTEGER_VALUE:
            {
                IntegerValue integerValue = (IntegerValue)theEObject;
                T result = caseIntegerValue(integerValue);
                if (result == null) result = caseProductValue(integerValue);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case ProductPackage.IPRODUCT_DEFINITION:
            {
                IProductDefinition iProductDefinition = (IProductDefinition)theEObject;
                T result = caseIProductDefinition(iProductDefinition);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            default: return defaultCase(theEObject);
        }
    }

    /**
     * Returns the result of interpreting the object as an instance of '<em>Definition</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Definition</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseProductDefinition(ProductDefinition object)
    {
        return null;
    }

    /**
     * Returns the result of interpreting the object as an instance of '<em>Property Definition</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Property Definition</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T casePropertyDefinition(PropertyDefinition object)
    {
        return null;
    }

    /**
     * Returns the result of interpreting the object as an instance of '<em>Property</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Property</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseProperty(Property object)
    {
        return null;
    }

    /**
     * Returns the result of interpreting the object as an instance of '<em>Value</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Value</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseProductValue(ProductValue object)
    {
        return null;
    }

    /**
     * Returns the result of interpreting the object as an instance of '<em>String Value</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>String Value</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseStringValue(StringValue object)
    {
        return null;
    }

    /**
     * Returns the result of interpreting the object as an instance of '<em>Boolean Value</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Boolean Value</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseBooleanValue(BooleanValue object)
    {
        return null;
    }

    /**
     * Returns the result of interpreting the object as an instance of '<em>Integer Value</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Integer Value</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseIntegerValue(IntegerValue object)
    {
        return null;
    }

    /**
     * Returns the result of interpreting the object as an instance of '<em>IProduct Definition</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>IProduct Definition</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseIProductDefinition(IProductDefinition object)
    {
        return null;
    }

    /**
     * Returns the result of interpreting the object as an instance of '<em>Has Name</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Has Name</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseHasName(HasName object)
    {
        return null;
    }

    /**
     * Returns the result of interpreting the object as an instance of '<em>Type Definition</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Type Definition</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseTypeDefinition(TypeDefinition object)
    {
        return null;
    }

    /**
     * Returns the result of interpreting the object as an instance of '<em>EObject</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch, but this is the last case anyway.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>EObject</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject)
     * @generated
     */
    @Override
    public T defaultCase(EObject object)
    {
        return null;
    }

} //ProductSwitch
