/*
 * Copyright (c) 2021, 2026 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.lsat.scheduler;

import java.math.BigDecimal;

import org.apache.commons.math3.distribution.BetaDistribution;
import org.eclipse.m2m.qvt.oml.blackbox.java.Module;
import org.eclipse.m2m.qvt.oml.blackbox.java.Operation;
import org.eclipse.m2m.qvt.oml.util.Dictionary;
import org.eclipse.m2m.qvt.oml.util.Utils;

@Module
public class RealDistributionLibrary {

    @Operation(contextual = false)
    public Dictionary<String, BigDecimal> betaDistributionInverseCumulativeProbability(BigDecimal alpha, BigDecimal beta) {

        var posterior = new BetaDistribution(alpha.doubleValue(), beta.doubleValue());
        // if wanted these can also be arguments
        double lower = posterior.inverseCumulativeProbability(0.025);
        double upper = posterior.inverseCumulativeProbability(0.975);

        // Create a Dictionary to return the bounds
        Dictionary<String, BigDecimal> result = Utils.createDictionary();
        result.put("lower", BigDecimal.valueOf(lower));
        result.put("upper", BigDecimal.valueOf(upper));

        return result;
    }
}
