/**
 * Copyright (c) 2021, 2026 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 */
/*
 * generated by Xtext
 */
package org.eclipse.lsat.setting.teditor.scoping

import expressions.Declaration
import java.util.List
import java.util.Set
import org.eclipse.emf.ecore.EObject
import org.eclipse.emf.ecore.EReference
import org.eclipse.xtext.scoping.IScope
import org.eclipse.xtext.scoping.Scopes
import org.eclipse.xtext.scoping.impl.AbstractDeclarativeScopeProvider
import setting.MoveAdjustments
import setting.PhysicalSettings
import setting.Settings
import setting.impl.MotionSettingsMapEntryImpl

import static extension org.eclipse.xtext.EcoreUtil2.*

/**
 * This class contains custom scoping description.
 * 
 * see : http://www.eclipse.org/Xtext/documentation.html#scoping
 * on how and when to use it s
 * 
 */
class SettingScopeProvider extends AbstractDeclarativeScopeProvider {
//     If you want to log the queried scoping rules, just enable this error handler
//        new() {
//            errorHandler = new PolymorphicDispatcher.ErrorHandler<IScope> {
//                override handle(Object[] params, Throwable throwable) {
//                    System.err.println(throwable.message)
//                    return null
//                }
//            }
//        }
        
    /**
     * Scoping for declaration
     */
    def IScope scope_DeclarationRef_declaration(EObject context, EReference ref) {
        if (context instanceof Declaration) {
            val settings = context.getContainerOfType(Settings)
            val importedDeclarations = settings.findImportedDeclarations(newLinkedHashSet)
            val priorDeclarations = settings.declarations.takeWhile[it != context]
            return Scopes.scopeFor(priorDeclarations + importedDeclarations)
        }
    }

    def Set<Declaration> findImportedDeclarations(Settings settings, Set<Declaration> declarations) {
        for (import : settings.imports) {
            import.load.filter(Settings).forEach [ impSettings |
                if (declarations.addAll(impSettings.declarations)) {
                    impSettings.findImportedDeclarations(declarations)
                }
            ]
        }
        return declarations
    }    

    /**
     * Scoping for peripheral
     */
    def IScope scope_Peripheral(PhysicalSettings entry, EReference ref) {
        if (null === entry?.resource?.resource) {
            return IScope.NULLSCOPE;
        }
        return Scopes.scopeFor(entry.resource.resource.peripherals)
    }

    /**
     * Scoping for simple action of timing_settings_map_entry
     */
    def IScope scope_ActionType(PhysicalSettings entry, EReference ref) {
        if (entry?.peripheral?.type === null) {
            return IScope.NULLSCOPE;
        }
        return Scopes.scopeFor(entry.peripheral.type.actions)
    }

    /**
     * Scoping for peripheral
     */
    def IScope scope_Axis(PhysicalSettings entry, EReference ref) {
        if (entry?.peripheral?.type === null) {
            return IScope.NULLSCOPE;
        }
        return Scopes.scopeFor(entry.peripheral.type.axes)
    }

    /**
     * Scoping for profiles
     */
    def IScope scope_Profile(PhysicalSettings entry, EReference ref) {
        if (entry?.peripheral === null) {
            return IScope.NULLSCOPE;
        }
        return Scopes.scopeFor(entry.peripheral.profiles)
    }

    /**
     * Scoping for positions
     */
    def IScope scope_Position(MotionSettingsMapEntryImpl entry, EReference ref) {
        val axis = entry?.key
        val peripheral = entry?.settings?.peripheral
        if (axis === null || peripheral === null) {
            return IScope.NULLSCOPE;
        }
        val candidates = newLinkedHashSet
        val axisPositions = peripheral.axisPositions.get(axis) 
        if(axisPositions !== null) {
            candidates+=axisPositions
        }
        candidates += peripheral.positions.map[getPosition(axis)].filterNull;
        return Scopes.scopeFor(candidates);
    }

    /**
     * Scoping for distances
     */
    def IScope scope_Distance(MotionSettingsMapEntryImpl entry, EReference ref) {
        val peripheral = entry?.settings?.peripheral
        if (peripheral === null) {
            return IScope.NULLSCOPE;
        }
        return Scopes.scopeFor(peripheral.distances);
    }

     /**
     * Scoping for declaration include Move Adjustments declaration
     */
    def IScope scope_Declaration(MoveAdjustments entry, EReference ref) {
        return Scopes.scopeFor(List.of(entry.timeDeclaration), delegateGetScope(entry,ref))
    }

 }
