/**
 * Copyright (c) 2021 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Do not edit: This file is generated by Xtext
 */
package org.eclipse.lsat.dispatching.teditor.ide.contentassist.antlr;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Map;
import org.eclipse.lsat.dispatching.teditor.ide.contentassist.antlr.internal.InternalDispatchingParser;
import org.eclipse.lsat.dispatching.teditor.services.DispatchingGrammarAccess;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.ide.editor.contentassist.antlr.AbstractContentAssistParser;

public class DispatchingParser extends AbstractContentAssistParser {

	@Singleton
	public static final class NameMappings {
		
		private final Map<AbstractElement, String> mappings;
		
		@Inject
		public NameMappings(DispatchingGrammarAccess grammarAccess) {
			ImmutableMap.Builder<AbstractElement, String> builder = ImmutableMap.builder();
			init(builder, grammarAccess);
			this.mappings = builder.build();
		}
		
		public String getRuleName(AbstractElement element) {
			return mappings.get(element);
		}
		
		private static void init(ImmutableMap.Builder<AbstractElement, String> builder, DispatchingGrammarAccess grammarAccess) {
			builder.put(grammarAccess.getDispatchGroupAccess().getAlternatives_4_3(), "rule__DispatchGroup__Alternatives_4_3");
			builder.put(grammarAccess.getBoundsAccess().getBoundsAlternatives_0(), "rule__Bounds__BoundsAlternatives_0");
			builder.put(grammarAccess.getRangeAccess().getAlternatives_1(), "rule__Range__Alternatives_1");
			builder.put(grammarAccess.getAttributesMapEntryAccess().getAlternatives_2(), "rule__AttributesMapEntry__Alternatives_2");
			builder.put(grammarAccess.getAttributesMapEntryAccess().getValueAlternatives_3_0(), "rule__AttributesMapEntry__ValueAlternatives_3_0");
			builder.put(grammarAccess.getEBigDecimalAccess().getAlternatives_3_0(), "rule__EBigDecimal__Alternatives_3_0");
			builder.put(grammarAccess.getEBigDecimalAccess().getAlternatives_3_1(), "rule__EBigDecimal__Alternatives_3_1");
			builder.put(grammarAccess.getIDStringAccess().getAlternatives(), "rule__IDString__Alternatives");
			builder.put(grammarAccess.getIIDAccess().getAlternatives(), "rule__IID__Alternatives");
			builder.put(grammarAccess.getActivityDispatchingAccess().getGroup(), "rule__ActivityDispatching__Group__0");
			builder.put(grammarAccess.getActivityDispatchingAccess().getGroup_2(), "rule__ActivityDispatching__Group_2__0");
			builder.put(grammarAccess.getActivityDispatchingAccess().getGroup_2_2(), "rule__ActivityDispatching__Group_2_2__0");
			builder.put(grammarAccess.getActivityDispatchingAccess().getGroup_4(), "rule__ActivityDispatching__Group_4__0");
			builder.put(grammarAccess.getResourceIterationsMapEntryAccess().getGroup(), "rule__ResourceIterationsMapEntry__Group__0");
			builder.put(grammarAccess.getDispatchGroupAccess().getGroup(), "rule__DispatchGroup__Group__0");
			builder.put(grammarAccess.getDispatchGroupAccess().getGroup_3(), "rule__DispatchGroup__Group_3__0");
			builder.put(grammarAccess.getDispatchGroupAccess().getGroup_3_1(), "rule__DispatchGroup__Group_3_1__0");
			builder.put(grammarAccess.getDispatchGroupAccess().getGroup_3_1_1(), "rule__DispatchGroup__Group_3_1_1__0");
			builder.put(grammarAccess.getDispatchGroupAccess().getGroup_4(), "rule__DispatchGroup__Group_4__0");
			builder.put(grammarAccess.getDispatchGroupAccess().getGroup_4_3_1(), "rule__DispatchGroup__Group_4_3_1__0");
			builder.put(grammarAccess.getDispatchGroupAccess().getGroup_4_3_1_2(), "rule__DispatchGroup__Group_4_3_1_2__0");
			builder.put(grammarAccess.getDispatchGroupAccess().getGroup_6(), "rule__DispatchGroup__Group_6__0");
			builder.put(grammarAccess.getDispatchGroupAccess().getGroup_8(), "rule__DispatchGroup__Group_8__0");
			builder.put(grammarAccess.getDispatchGroupAccess().getGroup_10(), "rule__DispatchGroup__Group_10__0");
			builder.put(grammarAccess.getConstraintAccess().getGroup(), "rule__Constraint__Group__0");
			builder.put(grammarAccess.getConstraintNestedAccess().getGroup(), "rule__ConstraintNested__Group__0");
			builder.put(grammarAccess.getJitBoundsAccess().getGroup(), "rule__JitBounds__Group__0");
			builder.put(grammarAccess.getTimeBoundsAccess().getGroup(), "rule__TimeBounds__Group__0");
			builder.put(grammarAccess.getInfTimeBoundsAccess().getGroup(), "rule__InfTimeBounds__Group__0");
			builder.put(grammarAccess.getSourceActionAccess().getGroup(), "rule__SourceAction__Group__0");
			builder.put(grammarAccess.getTargetActionAccess().getGroup(), "rule__TargetAction__Group__0");
			builder.put(grammarAccess.getNumberRepeatsAccess().getGroup(), "rule__NumberRepeats__Group__0");
			builder.put(grammarAccess.getRangeAccess().getGroup(), "rule__Range__Group__0");
			builder.put(grammarAccess.getRangeAccess().getGroup_1_1(), "rule__Range__Group_1_1__0");
			builder.put(grammarAccess.getResourceYieldMapEntryAccess().getGroup(), "rule__ResourceYieldMapEntry__Group__0");
			builder.put(grammarAccess.getAttributeAccess().getGroup(), "rule__Attribute__Group__0");
			builder.put(grammarAccess.getDispatchAccess().getGroup(), "rule__Dispatch__Group__0");
			builder.put(grammarAccess.getDispatchAccess().getGroup_1(), "rule__Dispatch__Group_1__0");
			builder.put(grammarAccess.getDispatchAccess().getGroup_3(), "rule__Dispatch__Group_3__0");
			builder.put(grammarAccess.getDispatchAccess().getGroup_3_2(), "rule__Dispatch__Group_3_2__0");
			builder.put(grammarAccess.getDispatchAccess().getGroup_4(), "rule__Dispatch__Group_4__0");
			builder.put(grammarAccess.getDispatchAccess().getGroup_4_2(), "rule__Dispatch__Group_4_2__0");
			builder.put(grammarAccess.getDispatchAccess().getGroup_4_2_1(), "rule__Dispatch__Group_4_2_1__0");
			builder.put(grammarAccess.getParameterAccess().getGroup(), "rule__Parameter__Group__0");
			builder.put(grammarAccess.getParameterAccess().getGroup_1(), "rule__Parameter__Group_1__0");
			builder.put(grammarAccess.getParameterAccess().getGroup_3(), "rule__Parameter__Group_3__0");
			builder.put(grammarAccess.getFirstParameterReferenceAccess().getGroup(), "rule__FirstParameterReference__Group__0");
			builder.put(grammarAccess.getParameterReferenceAccess().getGroup(), "rule__ParameterReference__Group__0");
			builder.put(grammarAccess.getAttributesMapEntryAccess().getGroup(), "rule__AttributesMapEntry__Group__0");
			builder.put(grammarAccess.getImportAccess().getGroup(), "rule__Import__Group__0");
			builder.put(grammarAccess.getEBigDecimalAccess().getGroup(), "rule__EBigDecimal__Group__0");
			builder.put(grammarAccess.getEBigDecimalAccess().getGroup_2(), "rule__EBigDecimal__Group_2__0");
			builder.put(grammarAccess.getEBigDecimalAccess().getGroup_3(), "rule__EBigDecimal__Group_3__0");
			builder.put(grammarAccess.getResourceQualifiedNameAccess().getGroup(), "rule__ResourceQualifiedName__Group__0");
			builder.put(grammarAccess.getResourceQualifiedNameAccess().getGroup_1(), "rule__ResourceQualifiedName__Group_1__0");
			builder.put(grammarAccess.getFullyQualifiedNameAccess().getGroup(), "rule__FullyQualifiedName__Group__0");
			builder.put(grammarAccess.getFullyQualifiedNameAccess().getGroup_1(), "rule__FullyQualifiedName__Group_1__0");
			builder.put(grammarAccess.getActivityDispatchingAccess().getImportsAssignment_1(), "rule__ActivityDispatching__ImportsAssignment_1");
			builder.put(grammarAccess.getActivityDispatchingAccess().getNumberOfIterationsAssignment_2_2_2(), "rule__ActivityDispatching__NumberOfIterationsAssignment_2_2_2");
			builder.put(grammarAccess.getActivityDispatchingAccess().getResourceIterationsAssignment_2_3(), "rule__ActivityDispatching__ResourceIterationsAssignment_2_3");
			builder.put(grammarAccess.getActivityDispatchingAccess().getDispatchGroupsAssignment_3(), "rule__ActivityDispatching__DispatchGroupsAssignment_3");
			builder.put(grammarAccess.getActivityDispatchingAccess().getConstraintsAssignment_4_2(), "rule__ActivityDispatching__ConstraintsAssignment_4_2");
			builder.put(grammarAccess.getResourceIterationsMapEntryAccess().getKeyAssignment_2(), "rule__ResourceIterationsMapEntry__KeyAssignment_2");
			builder.put(grammarAccess.getResourceIterationsMapEntryAccess().getValueAssignment_4(), "rule__ResourceIterationsMapEntry__ValueAssignment_4");
			builder.put(grammarAccess.getDispatchGroupAccess().getNameAssignment_2(), "rule__DispatchGroup__NameAssignment_2");
			builder.put(grammarAccess.getDispatchGroupAccess().getUserAttributesAssignment_3_1_0(), "rule__DispatchGroup__UserAttributesAssignment_3_1_0");
			builder.put(grammarAccess.getDispatchGroupAccess().getUserAttributesAssignment_3_1_1_1(), "rule__DispatchGroup__UserAttributesAssignment_3_1_1_1");
			builder.put(grammarAccess.getDispatchGroupAccess().getIteratorNameAssignment_4_1(), "rule__DispatchGroup__IteratorNameAssignment_4_1");
			builder.put(grammarAccess.getDispatchGroupAccess().getRepeatsAssignment_4_3_0(), "rule__DispatchGroup__RepeatsAssignment_4_3_0");
			builder.put(grammarAccess.getDispatchGroupAccess().getRepeatsAssignment_4_3_1_1(), "rule__DispatchGroup__RepeatsAssignment_4_3_1_1");
			builder.put(grammarAccess.getDispatchGroupAccess().getRepeatsAssignment_4_3_1_2_1(), "rule__DispatchGroup__RepeatsAssignment_4_3_1_2_1");
			builder.put(grammarAccess.getDispatchGroupAccess().getYieldAssignment_6_2(), "rule__DispatchGroup__YieldAssignment_6_2");
			builder.put(grammarAccess.getDispatchGroupAccess().getResourceYieldAssignment_7(), "rule__DispatchGroup__ResourceYieldAssignment_7");
			builder.put(grammarAccess.getDispatchGroupAccess().getOffsetAssignment_8_2(), "rule__DispatchGroup__OffsetAssignment_8_2");
			builder.put(grammarAccess.getDispatchGroupAccess().getDispatchesAssignment_9(), "rule__DispatchGroup__DispatchesAssignment_9");
			builder.put(grammarAccess.getDispatchGroupAccess().getConstraintsAssignment_10_2(), "rule__DispatchGroup__ConstraintsAssignment_10_2");
			builder.put(grammarAccess.getConstraintAccess().getSourceDispatchGroupAssignment_1(), "rule__Constraint__SourceDispatchGroupAssignment_1");
			builder.put(grammarAccess.getConstraintAccess().getTargetDispatchGroupAssignment_5(), "rule__Constraint__TargetDispatchGroupAssignment_5");
			builder.put(grammarAccess.getTimeBoundsAccess().getLowerAssignment_2(), "rule__TimeBounds__LowerAssignment_2");
			builder.put(grammarAccess.getTimeBoundsAccess().getUpperAssignment_4(), "rule__TimeBounds__UpperAssignment_4");
			builder.put(grammarAccess.getBoundsAccess().getBoundsAssignment(), "rule__Bounds__BoundsAssignment");
			builder.put(grammarAccess.getSourceActionAccess().getSourceDispatchAssignment_0(), "rule__SourceAction__SourceDispatchAssignment_0");
			builder.put(grammarAccess.getSourceActionAccess().getSourceActionAssignment_2(), "rule__SourceAction__SourceActionAssignment_2");
			builder.put(grammarAccess.getTargetActionAccess().getTargetDispatchAssignment_0(), "rule__TargetAction__TargetDispatchAssignment_0");
			builder.put(grammarAccess.getTargetActionAccess().getTargetActionAssignment_2(), "rule__TargetAction__TargetActionAssignment_2");
			builder.put(grammarAccess.getNumberRepeatsAccess().getNumRepeatsAssignment_1(), "rule__NumberRepeats__NumRepeatsAssignment_1");
			builder.put(grammarAccess.getRangeAccess().getStartAssignment_1_0(), "rule__Range__StartAssignment_1_0");
			builder.put(grammarAccess.getRangeAccess().getStartAssignment_1_1_0(), "rule__Range__StartAssignment_1_1_0");
			builder.put(grammarAccess.getRangeAccess().getEndAssignment_1_1_2(), "rule__Range__EndAssignment_1_1_2");
			builder.put(grammarAccess.getResourceYieldMapEntryAccess().getKeyAssignment_1(), "rule__ResourceYieldMapEntry__KeyAssignment_1");
			builder.put(grammarAccess.getResourceYieldMapEntryAccess().getValueAssignment_3(), "rule__ResourceYieldMapEntry__ValueAssignment_3");
			builder.put(grammarAccess.getAttributeAccess().getNameAssignment_1(), "rule__Attribute__NameAssignment_1");
			builder.put(grammarAccess.getDispatchAccess().getNameAssignment_1_0(), "rule__Dispatch__NameAssignment_1_0");
			builder.put(grammarAccess.getDispatchAccess().getActivityAssignment_2(), "rule__Dispatch__ActivityAssignment_2");
			builder.put(grammarAccess.getDispatchAccess().getParametersAssignment_3_1(), "rule__Dispatch__ParametersAssignment_3_1");
			builder.put(grammarAccess.getDispatchAccess().getParametersAssignment_3_2_1(), "rule__Dispatch__ParametersAssignment_3_2_1");
			builder.put(grammarAccess.getDispatchAccess().getDescriptionAssignment_4_1(), "rule__Dispatch__DescriptionAssignment_4_1");
			builder.put(grammarAccess.getDispatchAccess().getUserAttributesAssignment_4_2_0(), "rule__Dispatch__UserAttributesAssignment_4_2_0");
			builder.put(grammarAccess.getDispatchAccess().getUserAttributesAssignment_4_2_1_1(), "rule__Dispatch__UserAttributesAssignment_4_2_1_1");
			builder.put(grammarAccess.getParameterAccess().getDeclarationAssignment_1_0(), "rule__Parameter__DeclarationAssignment_1_0");
			builder.put(grammarAccess.getParameterAccess().getReferencesAssignment_2(), "rule__Parameter__ReferencesAssignment_2");
			builder.put(grammarAccess.getParameterAccess().getReferencesAssignment_3_1(), "rule__Parameter__ReferencesAssignment_3_1");
			builder.put(grammarAccess.getFirstParameterReferenceAccess().getReferenceAssignment_1(), "rule__FirstParameterReference__ReferenceAssignment_1");
			builder.put(grammarAccess.getParameterReferenceAccess().getReferenceAssignment_1(), "rule__ParameterReference__ReferenceAssignment_1");
			builder.put(grammarAccess.getAttributesMapEntryAccess().getKeyAssignment_1(), "rule__AttributesMapEntry__KeyAssignment_1");
			builder.put(grammarAccess.getAttributesMapEntryAccess().getValueAssignment_3(), "rule__AttributesMapEntry__ValueAssignment_3");
			builder.put(grammarAccess.getImportAccess().getImportURIAssignment_2(), "rule__Import__ImportURIAssignment_2");
		}
	}
	
	@Inject
	private NameMappings nameMappings;

	@Inject
	private DispatchingGrammarAccess grammarAccess;

	@Override
	protected InternalDispatchingParser createParser() {
		InternalDispatchingParser result = new InternalDispatchingParser(null);
		result.setGrammarAccess(grammarAccess);
		return result;
	}

	@Override
	protected String getRuleName(AbstractElement element) {
		return nameMappings.getRuleName(element);
	}

	@Override
	protected String[] getInitialHiddenTokens() {
		return new String[] { "RULE_WS", "RULE_ML_COMMENT", "RULE_SL_COMMENT" };
	}

	public DispatchingGrammarAccess getGrammarAccess() {
		return this.grammarAccess;
	}

	public void setGrammarAccess(DispatchingGrammarAccess grammarAccess) {
		this.grammarAccess = grammarAccess;
	}
	
	public NameMappings getNameMappings() {
		return nameMappings;
	}
	
	public void setNameMappings(NameMappings nameMappings) {
		this.nameMappings = nameMappings;
	}
}
