/**
 */
package org.eclipse.lsat.common.scheduler.schedule.impl;

import org.eclipse.lsat.common.graph.directed.impl.NodeImpl;

import org.eclipse.lsat.common.scheduler.graph.Task;

import org.eclipse.lsat.common.scheduler.schedule.SchedulePackage;
import org.eclipse.lsat.common.scheduler.schedule.ScheduledTask;
import org.eclipse.lsat.common.scheduler.schedule.Sequence;

import java.math.BigDecimal;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Scheduled Task</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.lsat.common.scheduler.schedule.impl.ScheduledTaskImpl#getStartTime <em>Start Time</em>}</li>
 *   <li>{@link org.eclipse.lsat.common.scheduler.schedule.impl.ScheduledTaskImpl#getEndTime <em>End Time</em>}</li>
 *   <li>{@link org.eclipse.lsat.common.scheduler.schedule.impl.ScheduledTaskImpl#getTask <em>Task</em>}</li>
 *   <li>{@link org.eclipse.lsat.common.scheduler.schedule.impl.ScheduledTaskImpl#getSequence <em>Sequence</em>}</li>
 *   <li>{@link org.eclipse.lsat.common.scheduler.schedule.impl.ScheduledTaskImpl#getDuration <em>Duration</em>}</li>
 * </ul>
 *
 * @generated
 */
public class ScheduledTaskImpl<T extends Task> extends NodeImpl implements ScheduledTask<T> {
	/**
     * The default value of the '{@link #getStartTime() <em>Start Time</em>}' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getStartTime()
     * @generated
     * @ordered
     */
	protected static final BigDecimal START_TIME_EDEFAULT = null;

	/**
     * The cached value of the '{@link #getStartTime() <em>Start Time</em>}' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getStartTime()
     * @generated
     * @ordered
     */
	protected BigDecimal startTime = START_TIME_EDEFAULT;

	/**
     * The default value of the '{@link #getEndTime() <em>End Time</em>}' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getEndTime()
     * @generated
     * @ordered
     */
	protected static final BigDecimal END_TIME_EDEFAULT = null;

	/**
     * The cached value of the '{@link #getEndTime() <em>End Time</em>}' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getEndTime()
     * @generated
     * @ordered
     */
	protected BigDecimal endTime = END_TIME_EDEFAULT;

	/**
     * The cached value of the '{@link #getTask() <em>Task</em>}' reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getTask()
     * @generated
     * @ordered
     */
	protected T task;

	/**
     * The cached value of the '{@link #getSequence() <em>Sequence</em>}' reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getSequence()
     * @generated
     * @ordered
     */
	protected Sequence<?> sequence;

	/**
     * The default value of the '{@link #getDuration() <em>Duration</em>}' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getDuration()
     * @generated
     * @ordered
     */
	protected static final BigDecimal DURATION_EDEFAULT = null;

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected ScheduledTaskImpl() {
        super();
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	protected EClass eStaticClass() {
        return SchedulePackage.Literals.SCHEDULED_TASK;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public BigDecimal getStartTime() {
        return startTime;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public void setStartTime(BigDecimal newStartTime) {
        BigDecimal oldStartTime = startTime;
        startTime = newStartTime;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, SchedulePackage.SCHEDULED_TASK__START_TIME, oldStartTime, startTime));
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public BigDecimal getEndTime() {
        return endTime;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public void setEndTime(BigDecimal newEndTime) {
        BigDecimal oldEndTime = endTime;
        endTime = newEndTime;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, SchedulePackage.SCHEDULED_TASK__END_TIME, oldEndTime, endTime));
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@SuppressWarnings("unchecked")
	@Override
	public T getTask() {
        if (task != null && task.eIsProxy())
        {
            InternalEObject oldTask = (InternalEObject)task;
            task = (T)eResolveProxy(oldTask);
            if (task != oldTask)
            {
                if (eNotificationRequired())
                    eNotify(new ENotificationImpl(this, Notification.RESOLVE, SchedulePackage.SCHEDULED_TASK__TASK, oldTask, task));
            }
        }
        return task;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public T basicGetTask() {
        return task;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public void setTask(T newTask) {
        T oldTask = task;
        task = newTask;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, SchedulePackage.SCHEDULED_TASK__TASK, oldTask, task));
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public Sequence<?> getSequence() {
        if (sequence != null && sequence.eIsProxy())
        {
            InternalEObject oldSequence = (InternalEObject)sequence;
            sequence = (Sequence<?>)eResolveProxy(oldSequence);
            if (sequence != oldSequence)
            {
                if (eNotificationRequired())
                    eNotify(new ENotificationImpl(this, Notification.RESOLVE, SchedulePackage.SCHEDULED_TASK__SEQUENCE, oldSequence, sequence));
            }
        }
        return sequence;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Sequence<?> basicGetSequence() {
        return sequence;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public NotificationChain basicSetSequence(Sequence<?> newSequence, NotificationChain msgs) {
        Sequence<?> oldSequence = sequence;
        sequence = newSequence;
        if (eNotificationRequired())
        {
            ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, SchedulePackage.SCHEDULED_TASK__SEQUENCE, oldSequence, newSequence);
            if (msgs == null) msgs = notification; else msgs.add(notification);
        }
        return msgs;
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public void setSequence(Sequence<?> newSequence) {
        if (newSequence != sequence)
        {
            NotificationChain msgs = null;
            if (sequence != null)
                msgs = ((InternalEObject)sequence).eInverseRemove(this, SchedulePackage.SEQUENCE__SCHEDULED_TASKS, Sequence.class, msgs);
            if (newSequence != null)
                msgs = ((InternalEObject)newSequence).eInverseAdd(this, SchedulePackage.SEQUENCE__SCHEDULED_TASKS, Sequence.class, msgs);
            msgs = basicSetSequence(newSequence, msgs);
            if (msgs != null) msgs.dispatch();
        }
        else if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, SchedulePackage.SCHEDULED_TASK__SEQUENCE, newSequence, newSequence));
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public BigDecimal getDuration() {
        if (null == startTime || null == endTime) {
            return null;
        }
        return endTime.subtract(startTime).abs();
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID)
        {
            case SchedulePackage.SCHEDULED_TASK__SEQUENCE:
                if (sequence != null)
                    msgs = ((InternalEObject)sequence).eInverseRemove(this, SchedulePackage.SEQUENCE__SCHEDULED_TASKS, Sequence.class, msgs);
                return basicSetSequence((Sequence<?>)otherEnd, msgs);
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID)
        {
            case SchedulePackage.SCHEDULED_TASK__SEQUENCE:
                return basicSetSequence(null, msgs);
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID)
        {
            case SchedulePackage.SCHEDULED_TASK__START_TIME:
                return getStartTime();
            case SchedulePackage.SCHEDULED_TASK__END_TIME:
                return getEndTime();
            case SchedulePackage.SCHEDULED_TASK__TASK:
                if (resolve) return getTask();
                return basicGetTask();
            case SchedulePackage.SCHEDULED_TASK__SEQUENCE:
                if (resolve) return getSequence();
                return basicGetSequence();
            case SchedulePackage.SCHEDULED_TASK__DURATION:
                return getDuration();
        }
        return super.eGet(featureID, resolve, coreType);
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
        switch (featureID)
        {
            case SchedulePackage.SCHEDULED_TASK__START_TIME:
                setStartTime((BigDecimal)newValue);
                return;
            case SchedulePackage.SCHEDULED_TASK__END_TIME:
                setEndTime((BigDecimal)newValue);
                return;
            case SchedulePackage.SCHEDULED_TASK__TASK:
                setTask((T)newValue);
                return;
            case SchedulePackage.SCHEDULED_TASK__SEQUENCE:
                setSequence((Sequence<?>)newValue);
                return;
        }
        super.eSet(featureID, newValue);
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public void eUnset(int featureID) {
        switch (featureID)
        {
            case SchedulePackage.SCHEDULED_TASK__START_TIME:
                setStartTime(START_TIME_EDEFAULT);
                return;
            case SchedulePackage.SCHEDULED_TASK__END_TIME:
                setEndTime(END_TIME_EDEFAULT);
                return;
            case SchedulePackage.SCHEDULED_TASK__TASK:
                setTask((T)null);
                return;
            case SchedulePackage.SCHEDULED_TASK__SEQUENCE:
                setSequence((Sequence<?>)null);
                return;
        }
        super.eUnset(featureID);
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public boolean eIsSet(int featureID) {
        switch (featureID)
        {
            case SchedulePackage.SCHEDULED_TASK__START_TIME:
                return START_TIME_EDEFAULT == null ? startTime != null : !START_TIME_EDEFAULT.equals(startTime);
            case SchedulePackage.SCHEDULED_TASK__END_TIME:
                return END_TIME_EDEFAULT == null ? endTime != null : !END_TIME_EDEFAULT.equals(endTime);
            case SchedulePackage.SCHEDULED_TASK__TASK:
                return task != null;
            case SchedulePackage.SCHEDULED_TASK__SEQUENCE:
                return sequence != null;
            case SchedulePackage.SCHEDULED_TASK__DURATION:
                return DURATION_EDEFAULT == null ? getDuration() != null : !DURATION_EDEFAULT.equals(getDuration());
        }
        return super.eIsSet(featureID);
    }

	/**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	@Override
	public String toString() {
        if (eIsProxy()) return super.toString();

        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (startTime: ");
        result.append(startTime);
        result.append(", endTime: ");
        result.append(endTime);
        result.append(')');
        return result.toString();
    }

} //ScheduledTaskImpl
