/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.conformance;

import activity.Action;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.lsat.common.graph.directed.editable.EditableDirectedGraph;
import org.eclipse.lsat.common.queries.QueryableIterable;
import org.eclipse.lsat.common.qvto.util.QvtoTransformationException;
import org.eclipse.lsat.conformance.FilterTPTracePointsInput;
import org.eclipse.lsat.conformance.internal.ConformanceCheckQueries;
import org.eclipse.lsat.conformance.internal.UniqueTracePoint;
import org.eclipse.lsat.trace.TraceLine;
import org.eclipse.lsat.trace.TraceModel;

public class FilterTPTracePointsJava {
    public List<TraceModel> transformModel(FilterTPTracePointsInput input) throws QvtoTransformationException {
        Set tracePoints = QueryableIterable.from(input.getActivities()).xcollect(EditableDirectedGraph::getNodes).objectsOfKind(Action.class).xcollect(ConformanceCheckQueries::getTracePoints).asSet();
        for (TraceModel traceModel : input.getTraceModels()) {
            ListIterator traceLines = traceModel.getLines().listIterator();
            while (traceLines.hasNext()) {
                TraceLine traceLine = (TraceLine)traceLines.next();
                if (UniqueTracePoint.matchesOneOf(traceLine, tracePoints)) continue;
                traceLines.remove();
                EcoreUtil.remove((EObject)traceLine);
            }
        }
        return input.getTraceModels();
    }
}

