/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.editors.stp;

import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.eclipse.ui.ide.FileStoreEditorInput;

public class PathEditorInput
extends FileStoreEditorInput
implements IPathEditorInput,
ILocationProvider {
    private IPath fPath;

    public PathEditorInput(IPath path) {
        super(EFS.getLocalFileSystem().getStore(path));
        if (path == null) {
            throw new IllegalArgumentException();
        }
        this.fPath = path;
    }

    public int hashCode() {
        return this.fPath.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof PathEditorInput) {
            PathEditorInput other = (PathEditorInput)((Object)obj);
            return this.fPath.equals((Object)other.fPath);
        }
        if (obj instanceof FileStoreEditorInput) {
            return super.equals(obj);
        }
        return false;
    }

    public String getName() {
        String[] substr = this.fPath.segments();
        return substr[substr.length - 1];
    }

    public IPath getPath() {
        return this.fPath;
    }

    public IPath getPath(Object element) {
        if (element instanceof PathEditorInput) {
            return ((PathEditorInput)((Object)element)).getPath();
        }
        return null;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (PathEditorInput.class.equals(adapter) || IPathEditorInput.class.equals(adapter) || ILocationProvider.class.equals(adapter)) {
            return (T)((Object)this);
        }
        return (T)Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }
}

