/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.launcher;

import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.Launch;
import org.eclipse.linuxtools.systemtap.ui.consolelog.structures.ScriptConsole;

public class SystemTapScriptLaunch
extends Launch
implements ScriptConsole.ScriptConsoleObserver {
    private ScriptConsole console = null;
    private boolean runStarted = false;
    private boolean runStopped = false;

    public SystemTapScriptLaunch(ILaunchConfiguration launchConfiguration, String mode) {
        super(launchConfiguration, mode, null);
    }

    public void setConsole(ScriptConsole console) {
        if (this.console == console) {
            return;
        }
        this.console = console;
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        for (ILaunch launch : manager.getLaunches()) {
            if (launch.equals((Object)this) || !(launch instanceof SystemTapScriptLaunch)) continue;
            SystemTapScriptLaunch olaunch = (SystemTapScriptLaunch)launch;
            if (olaunch.console != null && !olaunch.console.equals(console)) continue;
            olaunch.forceRemove();
        }
        console.addScriptConsoleObserver((ScriptConsole.ScriptConsoleObserver)this);
    }

    public ScriptConsole getConsole() {
        return this.console;
    }

    public void runningStateChanged(boolean started, boolean stopped) {
        if (!this.runStarted && started) {
            this.runStarted = started;
            if (this.console.getCommand().getProcess() != null) {
                DebugPlugin.newProcess((ILaunch)this, (Process)this.console.getCommand().getProcess(), (String)this.console.getName());
            }
            if (stopped) {
                this.runStopped = true;
            }
            this.console.removeScriptConsoleObserver((ScriptConsole.ScriptConsoleObserver)this);
        }
    }

    public boolean canTerminate() {
        return !this.isTerminated();
    }

    public boolean isTerminated() {
        if (!this.runStopped && (super.isTerminated() || this.console != null && !this.console.isRunning())) {
            this.runStopped = true;
        }
        return this.runStopped;
    }

    public void terminate() {
        if (this.console != null) {
            this.console.stop();
        }
    }

    public void launchRemoved(ILaunch launch) {
        super.launchRemoved(launch);
        if (launch.equals((Object)this)) {
            this.removeConsole();
        }
    }

    private void removeConsole() {
        if (this.console != null) {
            this.console.removeScriptConsoleObserver((ScriptConsole.ScriptConsoleObserver)this);
            this.console = null;
        }
    }

    public void forceRemove() {
        this.removeConsole();
        this.runStopped = true;
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        manager.removeLaunch((ILaunch)this);
    }
}

