/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.catalog;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.lemminx.client.InvalidPathWarner;
import org.eclipse.lemminx.client.PathFeature;
import org.eclipse.lemminx.extensions.catalog.XMLCatalogCodeLensParticipant;
import org.eclipse.lemminx.extensions.catalog.XMLCatalogDiagnosticsParticipant;
import org.eclipse.lemminx.extensions.catalog.XMLCatalogDocumentLinkParticipant;
import org.eclipse.lemminx.extensions.catalog.XMLCatalogURIResolverExtension;
import org.eclipse.lemminx.extensions.contentmodel.model.ContentModelManager;
import org.eclipse.lemminx.extensions.contentmodel.settings.ContentModelSettings;
import org.eclipse.lemminx.services.IXMLNotificationService;
import org.eclipse.lemminx.services.extensions.IDocumentLinkParticipant;
import org.eclipse.lemminx.services.extensions.IXMLExtension;
import org.eclipse.lemminx.services.extensions.XMLExtensionsRegistry;
import org.eclipse.lemminx.services.extensions.codelens.ICodeLensParticipant;
import org.eclipse.lemminx.services.extensions.diagnostics.IDiagnosticsParticipant;
import org.eclipse.lemminx.services.extensions.save.ISaveContext;
import org.eclipse.lemminx.utils.FilesUtils;
import org.eclipse.lsp4j.InitializeParams;

public class XMLCatalogPlugin
implements IXMLExtension {
    private XMLCatalogURIResolverExtension uiResolver;
    private final IDocumentLinkParticipant documentLinkParticipant = new XMLCatalogDocumentLinkParticipant();
    private final IDiagnosticsParticipant diagnosticsParticipant = new XMLCatalogDiagnosticsParticipant();
    private ICodeLensParticipant codeLensParticipant;
    private InvalidPathWarner pathWarner;

    @Override
    public void doSave(ISaveContext context) {
        Object initializationOptionsSettings = context.getSettings();
        ContentModelSettings cmSettings = ContentModelSettings.getContentModelXMLSettings(initializationOptionsSettings);
        if (cmSettings == null) {
            return;
        }
        this.validateCatalogPaths(cmSettings);
    }

    @Override
    public void start(InitializeParams params, XMLExtensionsRegistry registry) {
        ContentModelManager contentModelManager = (ContentModelManager)registry.getComponent(ContentModelManager.class);
        this.codeLensParticipant = new XMLCatalogCodeLensParticipant(contentModelManager);
        this.uiResolver = new XMLCatalogURIResolverExtension(registry);
        registry.getResolverExtensionManager().registerResolver(this.uiResolver);
        IXMLNotificationService notificationService = registry.getNotificationService();
        if (notificationService != null) {
            this.pathWarner = new InvalidPathWarner(notificationService);
        }
        registry.registerDocumentLinkParticipant(this.documentLinkParticipant);
        registry.registerDiagnosticsParticipant(this.diagnosticsParticipant);
        registry.registerCodeLensParticipant(this.codeLensParticipant);
    }

    @Override
    public void stop(XMLExtensionsRegistry registry) {
        registry.getResolverExtensionManager().unregisterResolver(this.uiResolver);
        registry.unregisterDiagnosticsParticipant(this.diagnosticsParticipant);
        registry.unregisterCodeLensParticipant(this.codeLensParticipant);
    }

    private void validateCatalogPaths(ContentModelSettings cmSettings) {
        if (this.pathWarner == null) {
            return;
        }
        String[] catalogs = cmSettings.getCatalogs();
        Set<String> invalidCatalogs = Arrays.stream(catalogs).filter(c -> Files.notExists(FilesUtils.getPath(c), new LinkOption[0])).collect(Collectors.toSet());
        if (invalidCatalogs.size() > 0) {
            this.pathWarner.onInvalidFilePath(invalidCatalogs, PathFeature.CATALOGS);
        } else {
            this.pathWarner.evictKey(PathFeature.CATALOGS);
        }
    }
}

