/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx;

import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.lemminx.XMLLanguageServer;
import org.eclipse.lemminx.client.ExtendedClientCapabilities;
import org.eclipse.lemminx.client.LimitExceededWarner;
import org.eclipse.lemminx.client.LimitFeature;
import org.eclipse.lemminx.commons.ModelTextDocument;
import org.eclipse.lemminx.commons.ModelTextDocuments;
import org.eclipse.lemminx.commons.ModelValidatorDelayer;
import org.eclipse.lemminx.commons.TextDocument;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMParser;
import org.eclipse.lemminx.extensions.contentmodel.settings.XMLValidationRootSettings;
import org.eclipse.lemminx.services.DocumentSymbolsResult;
import org.eclipse.lemminx.services.SymbolInformationResult;
import org.eclipse.lemminx.services.XMLLanguageService;
import org.eclipse.lemminx.services.data.DataEntryField;
import org.eclipse.lemminx.services.extensions.save.AbstractSaveContext;
import org.eclipse.lemminx.settings.CompositeSettings;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lemminx.settings.XMLCodeLensSettings;
import org.eclipse.lemminx.settings.XMLCompletionSettings;
import org.eclipse.lemminx.settings.XMLFoldingSettings;
import org.eclipse.lemminx.settings.XMLFormattingOptions;
import org.eclipse.lemminx.settings.XMLPreferences;
import org.eclipse.lemminx.settings.XMLSymbolSettings;
import org.eclipse.lemminx.utils.XMLPositionUtility;
import org.eclipse.lsp4j.ClientCapabilities;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.CodeLensParams;
import org.eclipse.lsp4j.ColorInformation;
import org.eclipse.lsp4j.ColorPresentation;
import org.eclipse.lsp4j.ColorPresentationParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.ConfigurationItem;
import org.eclipse.lsp4j.ConfigurationParams;
import org.eclipse.lsp4j.DefinitionParams;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.lsp4j.DocumentColorParams;
import org.eclipse.lsp4j.DocumentFormattingParams;
import org.eclipse.lsp4j.DocumentHighlight;
import org.eclipse.lsp4j.DocumentHighlightParams;
import org.eclipse.lsp4j.DocumentLink;
import org.eclipse.lsp4j.DocumentLinkParams;
import org.eclipse.lsp4j.DocumentRangeFormattingParams;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.DocumentSymbolParams;
import org.eclipse.lsp4j.FoldingRange;
import org.eclipse.lsp4j.FoldingRangeRequestParams;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.HoverParams;
import org.eclipse.lsp4j.LinkedEditingRangeParams;
import org.eclipse.lsp4j.LinkedEditingRanges;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.LocationLink;
import org.eclipse.lsp4j.PrepareRenameDefaultBehavior;
import org.eclipse.lsp4j.PrepareRenameParams;
import org.eclipse.lsp4j.PrepareRenameResult;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ReferenceParams;
import org.eclipse.lsp4j.RenameParams;
import org.eclipse.lsp4j.SelectionRange;
import org.eclipse.lsp4j.SelectionRangeParams;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.TextDocumentClientCapabilities;
import org.eclipse.lsp4j.TextDocumentContentChangeEvent;
import org.eclipse.lsp4j.TextDocumentEdit;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.TypeDefinitionParams;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import org.eclipse.lsp4j.jsonrpc.CompletableFutures;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.jsonrpc.messages.Either3;
import org.eclipse.lsp4j.jsonrpc.validation.NonNull;
import org.eclipse.lsp4j.services.TextDocumentService;

public class XMLTextDocumentService
implements TextDocumentService {
    private static final Logger LOGGER = Logger.getLogger(XMLTextDocumentService.class.getName());
    private final XMLLanguageServer xmlLanguageServer;
    private final ModelTextDocuments<DOMDocument> documents;
    private final ModelValidatorDelayer<DOMDocument> xmlValidatorDelayer;
    private SharedSettings sharedSettings;
    private LimitExceededWarner limitExceededWarner;
    private boolean codeActionLiteralSupport;
    private boolean hierarchicalDocumentSymbolSupport;
    private boolean definitionLinkSupport;
    private boolean typeDefinitionLinkSupport;
    private Boolean clientConfigurationSupport;

    public XMLTextDocumentService(XMLLanguageServer xmlLanguageServer) {
        this.xmlLanguageServer = xmlLanguageServer;
        DOMParser parser = DOMParser.getInstance();
        this.documents = new ModelTextDocuments<DOMDocument>((document, cancelChecker) -> parser.parse((TextDocument)((Object)document), this.getXMLLanguageService().getResolverExtensionManager(), true, (CancelChecker)cancelChecker));
        this.sharedSettings = new SharedSettings();
        this.limitExceededWarner = null;
        this.xmlValidatorDelayer = new ModelValidatorDelayer(document -> {
            DOMDocument xmlDocument = (DOMDocument)document.getModel();
            this.validate(xmlDocument, Collections.emptyMap());
            this.getXMLLanguageService().getDocumentLifecycleParticipants().forEach(participant -> {
                try {
                    participant.didChange(xmlDocument);
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "Error while processing didChange for the participant '" + participant.getClass().getName() + "'.", e);
                }
            });
        });
    }

    public void updateClientCapabilities(ClientCapabilities capabilities, ExtendedClientCapabilities extendedClientCapabilities) {
        if (capabilities != null) {
            TextDocumentClientCapabilities textDocumentClientCapabilities = capabilities.getTextDocument();
            if (textDocumentClientCapabilities != null) {
                this.sharedSettings.getCompletionSettings().setCapabilities(textDocumentClientCapabilities.getCompletion());
                this.sharedSettings.getCodeActionSettings().setCapabilities(textDocumentClientCapabilities.getCodeAction());
                this.sharedSettings.getFoldingSettings().setCapabilities(textDocumentClientCapabilities.getFoldingRange());
                this.sharedSettings.getHoverSettings().setCapabilities(textDocumentClientCapabilities.getHover());
                this.sharedSettings.getValidationSettings().setCapabilities(textDocumentClientCapabilities.getPublishDiagnostics());
                this.codeActionLiteralSupport = textDocumentClientCapabilities.getCodeAction() != null && textDocumentClientCapabilities.getCodeAction().getCodeActionLiteralSupport() != null;
                this.hierarchicalDocumentSymbolSupport = textDocumentClientCapabilities.getDocumentSymbol() != null && textDocumentClientCapabilities.getDocumentSymbol().getHierarchicalDocumentSymbolSupport() != null && textDocumentClientCapabilities.getDocumentSymbol().getHierarchicalDocumentSymbolSupport() != false;
                this.definitionLinkSupport = textDocumentClientCapabilities.getDefinition() != null && textDocumentClientCapabilities.getDefinition().getLinkSupport() != null && textDocumentClientCapabilities.getDefinition().getLinkSupport() != false;
                boolean bl = this.typeDefinitionLinkSupport = textDocumentClientCapabilities.getTypeDefinition() != null && textDocumentClientCapabilities.getTypeDefinition().getLinkSupport() != null && textDocumentClientCapabilities.getTypeDefinition().getLinkSupport() != false;
            }
            if (capabilities.getWorkspace() != null) {
                this.sharedSettings.getWorkspaceSettings().setCapabilities(capabilities.getWorkspace());
                this.clientConfigurationSupport = capabilities.getWorkspace().getConfiguration();
            }
        }
        if (extendedClientCapabilities != null) {
            this.sharedSettings.getCodeLensSettings().setCodeLens(extendedClientCapabilities.getCodeLens());
            this.sharedSettings.setActionableNotificationSupport(extendedClientCapabilities.isActionableNotificationSupport());
            this.sharedSettings.setOpenSettingsCommandSupport(extendedClientCapabilities.isOpenSettingsCommandSupport());
            this.sharedSettings.setBindingWizardSupport(extendedClientCapabilities.isBindingWizardSupport());
        }
    }

    public CompletableFuture<Either<List<CompletionItem>, CompletionList>> completion(CompletionParams params) {
        return this.computeDOMAsync(params.getTextDocument(), (DOMDocument xmlDocument, CancelChecker cancelChecker) -> {
            CompletionList list = this.getXMLLanguageService().doComplete((DOMDocument)xmlDocument, params.getPosition(), this.sharedSettings, (CancelChecker)cancelChecker);
            return Either.forRight((Object)list);
        });
    }

    public CompletableFuture<CompletionItem> resolveCompletionItem(CompletionItem unresolved) {
        return this.computeDOMAsync(unresolved.getData(), (DOMDocument xmlDocument, CancelChecker cancelChecker) -> this.getXMLLanguageService().resolveCompletionItem(unresolved, (DOMDocument)xmlDocument, this.sharedSettings, (CancelChecker)cancelChecker));
    }

    public CompletableFuture<Hover> hover(HoverParams params) {
        return this.computeDOMAsync(params.getTextDocument(), (DOMDocument xmlDocument, CancelChecker cancelChecker) -> this.getXMLLanguageService().doHover((DOMDocument)xmlDocument, params.getPosition(), this.sharedSettings, (CancelChecker)cancelChecker));
    }

    public CompletableFuture<List<? extends DocumentHighlight>> documentHighlight(DocumentHighlightParams params) {
        return this.computeDOMAsync(params.getTextDocument(), (DOMDocument xmlDocument, CancelChecker cancelChecker) -> this.getXMLLanguageService().findDocumentHighlights((DOMDocument)xmlDocument, params.getPosition(), (CancelChecker)cancelChecker));
    }

    public CompletableFuture<List<Either<SymbolInformation, DocumentSymbol>>> documentSymbol(DocumentSymbolParams params) {
        ModelTextDocument<DOMDocument> document = this.getDocument(params.getTextDocument().getUri());
        if (document == null) {
            return CompletableFuture.completedFuture(null);
        }
        XMLSymbolSettings symbolSettings = this.sharedSettings.getSymbolSettings();
        if (!symbolSettings.isEnabled() || symbolSettings.isExcluded(document.getUri())) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        return this.computeDOMAsync(params.getTextDocument(), (DOMDocument xmlDocument, CancelChecker cancelChecker) -> {
            boolean resultLimitExceeded = false;
            List symbols = null;
            if (this.hierarchicalDocumentSymbolSupport) {
                DocumentSymbolsResult result = this.getXMLLanguageService().findDocumentSymbols((DOMDocument)xmlDocument, symbolSettings, (CancelChecker)cancelChecker);
                resultLimitExceeded = result.isResultLimitExceeded();
                symbols = result.stream().map(s -> {
                    Either e = Either.forRight((Object)s);
                    return e;
                }).collect(Collectors.toList());
            } else {
                SymbolInformationResult result = this.getXMLLanguageService().findSymbolInformations((DOMDocument)xmlDocument, symbolSettings, (CancelChecker)cancelChecker);
                resultLimitExceeded = result.isResultLimitExceeded();
                symbols = result.stream().map(s -> {
                    Either e = Either.forLeft((Object)s);
                    return e;
                }).collect(Collectors.toList());
            }
            if (resultLimitExceeded) {
                this.getLimitExceededWarner().onResultLimitExceeded(xmlDocument.getTextDocument().getUri(), LimitFeature.SYMBOLS);
            }
            return symbols;
        });
    }

    public CompletableFuture<List<? extends TextEdit>> formatting(DocumentFormattingParams params) {
        return this.computeDOMAsync(params.getTextDocument(), (DOMDocument xmlDocument, CancelChecker cancelChecker) -> {
            CompositeSettings settings = new CompositeSettings(this.getSharedSettings(), params.getOptions());
            return this.getXMLLanguageService().format((DOMDocument)xmlDocument, null, settings);
        });
    }

    public CompletableFuture<List<? extends TextEdit>> rangeFormatting(DocumentRangeFormattingParams params) {
        return this.computeDOMAsync(params.getTextDocument(), (DOMDocument xmlDocument, CancelChecker cancelChecker) -> {
            CompositeSettings settings = new CompositeSettings(this.getSharedSettings(), params.getOptions());
            return this.getXMLLanguageService().format((DOMDocument)xmlDocument, params.getRange(), settings);
        });
    }

    public CompletableFuture<Either3<Range, PrepareRenameResult, PrepareRenameDefaultBehavior>> prepareRename(PrepareRenameParams params) {
        return this.computeDOMAsync(params.getTextDocument(), (DOMDocument xmlDocument, CancelChecker cancelChecker) -> {
            Either<Range, PrepareRenameResult> either = this.getXMLLanguageService().prepareRename((DOMDocument)xmlDocument, params.getPosition(), (CancelChecker)cancelChecker);
            if (either != null) {
                if (either.isLeft()) {
                    return Either3.forFirst((Object)((Range)either.get()));
                }
                return Either3.forSecond((Object)((PrepareRenameResult)either.get()));
            }
            return Either3.forThird((Object)new PrepareRenameDefaultBehavior());
        });
    }

    public CompletableFuture<WorkspaceEdit> rename(RenameParams params) {
        return this.computeDOMAsync(params.getTextDocument(), (DOMDocument xmlDocument, CancelChecker cancelChecker) -> this.getXMLLanguageService().doRename((DOMDocument)xmlDocument, params.getPosition(), params.getNewName(), (CancelChecker)cancelChecker));
    }

    public void didOpen(DidOpenTextDocumentParams params) {
        ModelTextDocument document = (ModelTextDocument)((Object)this.documents.onDidOpenTextDocument(params));
        this.triggerValidationFor(document, TriggeredBy.didOpen);
    }

    public void didChange(DidChangeTextDocumentParams params) {
        ModelTextDocument document = (ModelTextDocument)((Object)this.documents.onDidChangeTextDocument(params));
        this.triggerValidationFor(document, TriggeredBy.didChange, params.getContentChanges());
    }

    public void didClose(DidCloseTextDocumentParams params) {
        TextDocumentIdentifier identifier = params.getTextDocument();
        String uri = identifier.getUri();
        DOMDocument xmlDocument = this.documents.getExistingModel(uri);
        this.documents.onDidCloseTextDocument(params);
        this.xmlValidatorDelayer.cleanPendingValidation(uri);
        this.xmlLanguageServer.getLanguageClient().publishDiagnostics(new PublishDiagnosticsParams(uri, Collections.emptyList()));
        this.getLimitExceededWarner().evictValue(uri);
        if (xmlDocument != null) {
            this.getXMLLanguageService().getDocumentLifecycleParticipants().forEach(participant -> {
                try {
                    participant.didClose(xmlDocument);
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "Error while processing didClose for the participant '" + participant.getClass().getName() + "'.", e);
                }
            });
        }
    }

    public CompletableFuture<List<FoldingRange>> foldingRange(FoldingRangeRequestParams params) {
        return this.computeDOMAsync(params.getTextDocument(), (DOMDocument xmlDocument, CancelChecker cancelChecker) -> this.getXMLLanguageService().getFoldingRanges((DOMDocument)xmlDocument, this.sharedSettings.getFoldingSettings(), (CancelChecker)cancelChecker));
    }

    public CompletableFuture<List<DocumentLink>> documentLink(DocumentLinkParams params) {
        return this.computeDOMAsync(params.getTextDocument(), (DOMDocument xmlDocument, CancelChecker cancelChecker) -> this.getXMLLanguageService().findDocumentLinks((DOMDocument)xmlDocument));
    }

    public CompletableFuture<Either<List<? extends Location>, List<? extends LocationLink>>> definition(DefinitionParams params) {
        return this.computeDOMAsync(params.getTextDocument(), (DOMDocument xmlDocument, CancelChecker cancelChecker) -> {
            if (this.definitionLinkSupport) {
                return Either.forRight(this.getXMLLanguageService().findDefinition((DOMDocument)xmlDocument, params.getPosition(), (CancelChecker)cancelChecker));
            }
            List locations = this.getXMLLanguageService().findDefinition((DOMDocument)xmlDocument, params.getPosition(), (CancelChecker)cancelChecker).stream().map(locationLink -> XMLPositionUtility.toLocation(locationLink)).collect(Collectors.toList());
            return Either.forLeft(locations);
        });
    }

    public CompletableFuture<Either<List<? extends Location>, List<? extends LocationLink>>> typeDefinition(TypeDefinitionParams params) {
        return this.computeDOMAsync(params.getTextDocument(), (DOMDocument xmlDocument, CancelChecker cancelChecker) -> {
            if (this.typeDefinitionLinkSupport) {
                return Either.forRight(this.getXMLLanguageService().findTypeDefinition((DOMDocument)xmlDocument, params.getPosition(), (CancelChecker)cancelChecker));
            }
            List locations = this.getXMLLanguageService().findTypeDefinition((DOMDocument)xmlDocument, params.getPosition(), (CancelChecker)cancelChecker).stream().map(locationLink -> XMLPositionUtility.toLocation(locationLink)).collect(Collectors.toList());
            return Either.forLeft(locations);
        });
    }

    public CompletableFuture<List<? extends Location>> references(ReferenceParams params) {
        return this.computeDOMAsync(params.getTextDocument(), (DOMDocument xmlDocument, CancelChecker cancelChecker) -> this.getXMLLanguageService().findReferences((DOMDocument)xmlDocument, params.getPosition(), params.getContext(), (CancelChecker)cancelChecker));
    }

    public CompletableFuture<List<? extends CodeLens>> codeLens(CodeLensParams params) {
        if (!this.sharedSettings.getCodeLensSettings().isEnabled()) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        return this.computeDOMAsync(params.getTextDocument(), (DOMDocument xmlDocument, CancelChecker cancelChecker) -> this.getXMLLanguageService().getCodeLens((DOMDocument)xmlDocument, this.sharedSettings.getCodeLensSettings(), (CancelChecker)cancelChecker));
    }

    public CompletableFuture<List<Either<Command, CodeAction>>> codeAction(CodeActionParams params) {
        String uri = params.getTextDocument().getUri();
        return this.computeDOMAsync(params.getTextDocument(), (DOMDocument xmlDocument, CancelChecker cancelChecker) -> {
            XMLFormattingOptions indentationSettings = this.getIndentationSettings(uri);
            if (indentationSettings != null) {
                this.sharedSettings.getFormattingSettings().merge(indentationSettings);
            }
            return this.getXMLLanguageService().doCodeActions(params.getContext(), params.getRange(), (DOMDocument)xmlDocument, this.sharedSettings, (CancelChecker)cancelChecker).stream().map(ca -> {
                if (this.codeActionLiteralSupport) {
                    Either e = Either.forRight((Object)ca);
                    return e;
                }
                List<Object> arguments = Arrays.asList(uri, xmlDocument.getTextDocument().getVersion(), ((TextDocumentEdit)((Either)ca.getEdit().getDocumentChanges().get(0)).getLeft()).getEdits());
                Command command = new Command(ca.getTitle(), "_xml.applyCodeAction", arguments);
                Either e = Either.forLeft((Object)command);
                return e;
            }).collect(Collectors.toList());
        });
    }

    public CompletableFuture<CodeAction> resolveCodeAction(CodeAction unresolved) {
        return this.computeDOMAsync(unresolved.getData(), (DOMDocument xmlDocument, CancelChecker cancelChecker) -> this.getXMLLanguageService().resolveCodeAction(unresolved, (DOMDocument)xmlDocument, this.sharedSettings, (CancelChecker)cancelChecker));
    }

    private XMLFormattingOptions getIndentationSettings(@NonNull String uri) {
        if (this.clientConfigurationSupport == null || !this.clientConfigurationSupport.booleanValue()) {
            return null;
        }
        ConfigurationItem insertSpaces = new ConfigurationItem();
        insertSpaces.setScopeUri(uri);
        insertSpaces.setSection("xml.format.insertSpaces");
        ConfigurationItem tabSize = new ConfigurationItem();
        tabSize.setScopeUri(uri);
        tabSize.setSection("xml.format.tabSize");
        XMLFormattingOptions newOptions = null;
        try {
            List indentationSettings = (List)this.xmlLanguageServer.getLanguageClient().configuration(new ConfigurationParams(Arrays.asList(insertSpaces, tabSize))).join();
            newOptions = new XMLFormattingOptions();
            newOptions.merge(this.sharedSettings.getFormattingSettings());
            if (indentationSettings.get(0) != null && indentationSettings.get(0) instanceof JsonPrimitive) {
                newOptions.setInsertSpaces(((JsonPrimitive)indentationSettings.get(0)).getAsBoolean());
            }
            if (indentationSettings.get(1) != null && indentationSettings.get(1) instanceof JsonPrimitive) {
                newOptions.setTabSize(((JsonPrimitive)indentationSettings.get(1)).getAsInt());
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error while processing getting indentation settings for code actions'.", e);
        }
        return newOptions;
    }

    public CompletableFuture<List<SelectionRange>> selectionRange(SelectionRangeParams params) {
        return this.computeDOMAsync(params.getTextDocument(), (DOMDocument xmlDocument, CancelChecker cancelChecker) -> this.getXMLLanguageService().getSelectionRanges((DOMDocument)xmlDocument, params.getPositions(), (CancelChecker)cancelChecker));
    }

    public CompletableFuture<LinkedEditingRanges> linkedEditingRange(LinkedEditingRangeParams params) {
        return this.computeDOMAsync(params.getTextDocument(), (DOMDocument xmlDocument, CancelChecker cancelChecker) -> this.getXMLLanguageService().findLinkedEditingRanges((DOMDocument)xmlDocument, params.getPosition(), (CancelChecker)cancelChecker));
    }

    public CompletableFuture<List<ColorInformation>> documentColor(DocumentColorParams params) {
        return this.computeDOMAsync(params.getTextDocument(), (DOMDocument xmlDocument, CancelChecker cancelChecker) -> this.getXMLLanguageService().findDocumentColors((DOMDocument)xmlDocument, (CancelChecker)cancelChecker));
    }

    public CompletableFuture<List<ColorPresentation>> colorPresentation(ColorPresentationParams params) {
        return this.computeDOMAsync(params.getTextDocument(), (DOMDocument xmlDocument, CancelChecker cancelChecker) -> this.getXMLLanguageService().getColorPresentations((DOMDocument)xmlDocument, params, (CancelChecker)cancelChecker));
    }

    public void didSave(DidSaveTextDocumentParams params) {
        CompletableFutures.computeAsync(monitor -> {
            SaveContext context = new SaveContext(params.getTextDocument().getUri());
            this.doSave(context);
            DOMDocument xmlDocument = this.documents.getModel(params.getTextDocument().getUri());
            if (xmlDocument != null) {
                this.getXMLLanguageService().getDocumentLifecycleParticipants().forEach(participant -> {
                    try {
                        participant.didSave(xmlDocument);
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.SEVERE, "Error while processing didSave for the participant '" + participant.getClass().getName() + "'.", e);
                    }
                });
            }
            return null;
        });
    }

    public void updateSettings(Object settings) {
        SaveContext context = new SaveContext(settings);
        this.doSave(context);
    }

    void doSave(String uri) {
        SaveContext context = new SaveContext(uri);
        this.doSave(context);
    }

    void doSave(SaveContext context) {
        this.getXMLLanguageService().doSave(context);
        context.triggerValidationIfNeeded();
        if (context.isRefreshCodeLenses()) {
            this.xmlLanguageServer.getLanguageClient().refreshCodeLenses();
        }
    }

    private void triggerValidationFor(Collection<ModelTextDocument<DOMDocument>> documents) {
        if (!documents.isEmpty()) {
            this.xmlLanguageServer.schedule(() -> documents.forEach(document -> {
                try {
                    this.validate((DOMDocument)document.getModel(), Collections.emptyMap());
                }
                catch (CancellationException cancellationException) {
                    // empty catch block
                }
            }), 500, TimeUnit.MILLISECONDS);
        }
    }

    private void triggerValidationFor(TextDocument document, TriggeredBy triggeredBy) {
        this.triggerValidationFor(document, triggeredBy, null);
    }

    private void triggerValidationFor(TextDocument document, TriggeredBy triggeredBy, List<TextDocumentContentChangeEvent> changeEvents) {
        this.validate(document, triggeredBy == TriggeredBy.didChange);
    }

    void validate(TextDocument document, boolean withDelay) throws CancellationException {
        if (withDelay) {
            this.xmlValidatorDelayer.validateWithDelay((ModelTextDocument)document);
        } else {
            CompletableFuture.runAsync(() -> {
                DOMDocument xmlDocument = (DOMDocument)((ModelTextDocument)document).getModel();
                this.validate(xmlDocument, Collections.emptyMap());
                this.getXMLLanguageService().getDocumentLifecycleParticipants().forEach(participant -> {
                    try {
                        participant.didOpen(xmlDocument);
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.SEVERE, "Error while processing didOpen for the participant '" + participant.getClass().getName() + "'.", e);
                    }
                });
            });
        }
    }

    void validate(DOMDocument xmlDocument, Map<String, Object> validationArgs) throws CancellationException {
        CancelChecker cancelChecker = xmlDocument.getCancelChecker();
        cancelChecker.checkCanceled();
        this.getXMLLanguageService().publishDiagnostics(xmlDocument, params -> this.xmlLanguageServer.getLanguageClient().publishDiagnostics((PublishDiagnosticsParams)params), doc -> this.triggerValidationFor((TextDocument)((Object)doc), TriggeredBy.Other), this.sharedSettings.getValidationSettings(), validationArgs, cancelChecker);
    }

    private XMLLanguageService getXMLLanguageService() {
        return this.xmlLanguageServer.getXMLLanguageService();
    }

    public void updateCompletionSettings(XMLCompletionSettings newCompletion) {
        this.sharedSettings.getCompletionSettings().merge(newCompletion);
    }

    public void updateSymbolSettings(XMLSymbolSettings newSettings) {
        this.sharedSettings.getSymbolSettings().merge(newSettings);
    }

    public void updateCodeLensSettings(XMLCodeLensSettings newSettings) {
        this.sharedSettings.getCodeLensSettings().merge(newSettings);
    }

    public void updatePreferences(XMLPreferences newPreferences) {
        this.sharedSettings.getPreferences().merge(newPreferences);
    }

    public XMLSymbolSettings getSharedSymbolSettings() {
        return this.sharedSettings.getSymbolSettings();
    }

    public XMLCodeLensSettings getSharedCodeLensSettings() {
        return this.sharedSettings.getCodeLensSettings();
    }

    public boolean isIncrementalSupport() {
        return this.documents.isIncremental();
    }

    public XMLFoldingSettings getSharedFoldingSettings() {
        return this.sharedSettings.getFoldingSettings();
    }

    public XMLFormattingOptions getSharedFormattingSettings() {
        return this.sharedSettings.getFormattingSettings();
    }

    public XMLValidationRootSettings getValidationSettings() {
        return this.sharedSettings.getValidationSettings();
    }

    public XMLPreferences getPreferences() {
        return this.sharedSettings.getPreferences();
    }

    public SharedSettings getSharedSettings() {
        return this.sharedSettings;
    }

    public ModelTextDocument<DOMDocument> getDocument(String uri) {
        return (ModelTextDocument)((Object)this.documents.get(uri));
    }

    public Collection<ModelTextDocument<DOMDocument>> allDocuments() {
        return this.documents.all();
    }

    public boolean documentIsOpen(String uri) {
        ModelTextDocument<DOMDocument> document = this.getDocument(uri);
        return document != null;
    }

    private <R> CompletableFuture<R> computeDOMAsync(Object data, BiFunction<DOMDocument, CancelChecker, R> code) {
        String uri = DataEntryField.getUri(data);
        if (uri == null) {
            return CompletableFuture.completedFuture(null);
        }
        TextDocumentIdentifier identifier = new TextDocumentIdentifier(uri);
        return this.computeDOMAsync(identifier, code);
    }

    public <R> CompletableFuture<R> computeDOMAsync(TextDocumentIdentifier documentIdentifier, BiFunction<DOMDocument, CancelChecker, R> code) {
        return this.documents.computeModelAsync(documentIdentifier, code);
    }

    public LimitExceededWarner getLimitExceededWarner() {
        if (this.limitExceededWarner == null) {
            this.limitExceededWarner = new LimitExceededWarner(this.xmlLanguageServer);
        }
        return this.limitExceededWarner;
    }

    public class SaveContext
    extends AbstractSaveContext {
        private final Collection<ModelTextDocument<DOMDocument>> documentsToValidate;
        private boolean isRefreshCodeLenses;

        public boolean isRefreshCodeLenses() {
            return this.isRefreshCodeLenses;
        }

        public void setRefreshCodeLenses(boolean isRefreshCodeLenses) {
            this.isRefreshCodeLenses = isRefreshCodeLenses;
        }

        public SaveContext(Object settings) {
            super(settings);
            this.documentsToValidate = new ArrayList<ModelTextDocument<DOMDocument>>();
        }

        public SaveContext(String uri) {
            super(uri);
            this.documentsToValidate = new ArrayList<ModelTextDocument<DOMDocument>>();
        }

        @Override
        public void collectDocumentToValidate(Predicate<DOMDocument> validateDocumentPredicate) {
            XMLTextDocumentService.this.documents.all().stream().forEach(document -> {
                DOMDocument xmlDocument = (DOMDocument)document.getModel();
                if (xmlDocument != null && !this.documentsToValidate.contains(document) && validateDocumentPredicate.test(xmlDocument)) {
                    this.documentsToValidate.add((ModelTextDocument<DOMDocument>)((Object)document));
                }
            });
        }

        @Override
        public DOMDocument getDocument(String uri) {
            return XMLTextDocumentService.this.xmlLanguageServer.getDocument(uri);
        }

        public void triggerValidationIfNeeded() {
            XMLTextDocumentService.this.triggerValidationFor(this.documentsToValidate);
        }
    }

    private static enum TriggeredBy {
        didOpen,
        didChange,
        Other;

    }
}

