/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel.participants;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.extensions.contentmodel.participants.DTDErrorCode;
import org.eclipse.lemminx.extensions.contentmodel.participants.ExternalResourceErrorCode;
import org.eclipse.lemminx.extensions.contentmodel.participants.XMLSchemaErrorCode;
import org.eclipse.lemminx.extensions.contentmodel.participants.XMLSyntaxErrorCode;
import org.eclipse.lemminx.extensions.xsd.participants.XSDErrorCode;
import org.eclipse.lemminx.services.extensions.ICodeActionParticipant;
import org.eclipse.lemminx.services.extensions.IComponentProvider;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Range;

public class ContentModelCodeActionParticipant
implements ICodeActionParticipant {
    private final Map<String, ICodeActionParticipant> codeActionParticipants = new HashMap<String, ICodeActionParticipant>();

    @Override
    public void doCodeAction(Diagnostic diagnostic, Range range, DOMDocument document, List<CodeAction> codeActions, SharedSettings sharedSettings, IComponentProvider componentProvider) {
        if (diagnostic == null || diagnostic.getCode() == null || !diagnostic.getCode().isLeft()) {
            return;
        }
        this.registerCodeActionsIfNeeded(sharedSettings);
        ICodeActionParticipant participant = this.codeActionParticipants.get(diagnostic.getCode().getLeft());
        if (participant != null) {
            participant.doCodeAction(diagnostic, range, document, codeActions, sharedSettings, componentProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerCodeActionsIfNeeded(SharedSettings sharedSettings) {
        if (this.codeActionParticipants.isEmpty()) {
            Map<String, ICodeActionParticipant> map = this.codeActionParticipants;
            synchronized (map) {
                if (!this.codeActionParticipants.isEmpty()) {
                    return;
                }
                XMLSyntaxErrorCode.registerCodeActionParticipants(this.codeActionParticipants, sharedSettings);
                DTDErrorCode.registerCodeActionParticipants(this.codeActionParticipants, sharedSettings);
                XMLSchemaErrorCode.registerCodeActionParticipants(this.codeActionParticipants, sharedSettings);
                XSDErrorCode.registerCodeActionParticipants(this.codeActionParticipants);
                ExternalResourceErrorCode.registerCodeActionParticipants(this.codeActionParticipants);
            }
        }
    }
}

