/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.wire.query;

import java.util.Map;
import java.util.Objects;
import org.eclipse.kura.util.configuration.Property;

public final class WireRecordQueryComponentOptions {
    private static final Property<String> QUERY_PROPERTY = new Property("query", (Object)"SELECT * FROM \"WR_data\" LIMIT 10;");
    private static final Property<Integer> CACHE_EXPIRATION_INTERVAL_PROPERTY = new Property("cache.expiration.interval", (Object)0);
    private static final Property<Boolean> EMIT_ON_EMPTY_RESULT_PROPERTY = new Property("emit.on.empty.result", (Object)true);
    private final String query;
    private final int cacheExpirationInterval;
    private final boolean emitOnEmptyResult;

    public WireRecordQueryComponentOptions(Map<String, Object> properties) {
        this.cacheExpirationInterval = (Integer)CACHE_EXPIRATION_INTERVAL_PROPERTY.get(properties);
        this.query = (String)QUERY_PROPERTY.get(properties);
        this.emitOnEmptyResult = (Boolean)EMIT_ON_EMPTY_RESULT_PROPERTY.get(properties);
    }

    public String getQuery() {
        return this.query;
    }

    public int getCacheExpirationInterval() {
        return this.cacheExpirationInterval;
    }

    public boolean isEmitOnEmptyResult() {
        return this.emitOnEmptyResult;
    }

    public int hashCode() {
        return Objects.hash(this.cacheExpirationInterval, this.emitOnEmptyResult, this.query);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof WireRecordQueryComponentOptions)) {
            return false;
        }
        WireRecordQueryComponentOptions other = (WireRecordQueryComponentOptions)obj;
        return this.cacheExpirationInterval == other.cacheExpirationInterval && this.emitOnEmptyResult == other.emitOnEmptyResult && Objects.equals(this.query, other.query);
    }
}

