/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.generation.af.tasks;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egf.core.producer.InvocationException;
import org.eclipse.egf.ftask.producer.context.ITaskProductionContext;
import org.eclipse.egf.ftask.producer.invocation.ITaskProduction;
import org.eclipse.emf.common.util.EList;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.Viewpoint;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.af.project.AfProjectManager;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.helper.pde.PDEUtility;

public class AfProjectUpdateManifestTask
implements ITaskProduction {
    public static final String CONTRACT_PLUGINS_LIST = "plugins.names.list";

    public void preExecute(ITaskProductionContext productionContext, IProgressMonitor monitor) throws InvocationException {
    }

    public void doExecute(ITaskProductionContext productionContext, IProgressMonitor monitor) throws InvocationException {
        String projectName = (String)productionContext.getInputValue((Object)"viewpoint.project.name", String.class);
        if (projectName != null && projectName.trim().length() > 0) {
            Viewpoint vp = AfProjectManager.INSTANCE.getViewpoint();
            List<String> requiredBundles = this.getRequiredBundlesFor(vp);
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            if (project != null && project.exists()) {
                PDEUtility.updateRequiredBundles((IProject)project, requiredBundles, (IProgressMonitor)monitor);
            }
        }
    }

    private List<String> getRequiredBundlesFor(Viewpoint viewpoint) {
        EList parentsViewpoints;
        ArrayList<String> result = new ArrayList<String>();
        ArrayList referencedViewpoints = new ArrayList();
        EList dependenciesViewpoints = viewpoint.getDependencies();
        if (dependenciesViewpoints != null && dependenciesViewpoints.size() > 0) {
            referencedViewpoints.addAll(dependenciesViewpoints);
        }
        if ((parentsViewpoints = viewpoint.getParents()) != null && parentsViewpoints.size() > 0) {
            referencedViewpoints.addAll(parentsViewpoints);
        }
        for (Viewpoint iViewpoint : referencedViewpoints) {
            String bundleID = iViewpoint.eResource().getURI().segment(1);
            result.add(bundleID);
        }
        return result;
    }

    public void postExecute(ITaskProductionContext productionContext, IProgressMonitor monitor) throws InvocationException {
    }
}

