/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.as.desc.helper.acceleration;

import java.util.ArrayList;
import java.util.List;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.desc.helper.acceleration.ADataAnalyserHelper;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.AbstractAssociation;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.Class;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.NamedElement;

public class ANode {
    private Class _domainContext = null;
    private ANode _parent = null;
    private AbstractAssociation _providingAssociation;
    private List<ANode> children = new ArrayList<ANode>();
    private List<ANode> reused = new ArrayList<ANode>();

    public ANode(Class clazz, AbstractAssociation containingRef) {
        this._domainContext = clazz;
        this._providingAssociation = containingRef;
    }

    public String getName() {
        return this._domainContext.getName();
    }

    public ANode getParent() {
        return this._parent;
    }

    public void setParent(ANode parent) {
        this._parent = parent;
    }

    public String getFQN() {
        String name = this._domainContext.getName();
        ANode node = this;
        while (node.getParent() != null) {
            ANode parent = node.getParent();
            name = String.valueOf(parent.getName()) + "." + name;
            node = parent;
        }
        return name;
    }

    public void addChildren(ANode node) {
        if (!this.children.contains(node)) {
            this.children.add(node);
            node.setParent(this);
        }
    }

    public void addAllChildren(List<ANode> node) {
        for (ANode aNode : node) {
            this.addChildren(aNode);
        }
    }

    public List<ANode> getReuse() {
        return this.reused;
    }

    public List<ANode> getChildren() {
        return this.children;
    }

    public void addReuse(ANode node) {
        if (!this.reused.contains(node)) {
            this.reused.add(node);
        }
    }

    public void addAllReuse(List<ANode> node) {
        for (ANode aNode : node) {
            this.addReuse(aNode);
        }
    }

    public Class getVPClass() {
        return this._domainContext;
    }

    public AbstractAssociation getContainingReference() {
        return this._providingAssociation;
    }

    public boolean isContainer() {
        return !this.children.isEmpty() || !this.reused.isEmpty();
    }

    public String getClassFQN() {
        return ADataAnalyserHelper.getFQN((NamedElement)this._domainContext);
    }

    public String getContainingReferenceFQN() {
        return ADataAnalyserHelper.getFQN((NamedElement)this._providingAssociation);
    }
}

