/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.pdt.introspector.core.services;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.ui.statushandlers.StatusManager;
import org.osgi.framework.Version;
import org.polarsys.kitalpha.pdt.introspector.core.IntrospectionContext;
import org.polarsys.kitalpha.pdt.introspector.core.messages.Messages;
import org.polarsys.kitalpha.pdt.introspector.core.services.Helpers;
import org.polarsys.kitalpha.pdt.introspector.preferences.utils.IntrospectorPreferenceMessages;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.EclipseModel;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.ExtensionPoint;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.Feature;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.Package;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.Plugin;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.Repository;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.RepositoryKind;
import org.polarsys.kitalpha.resourcereuse.emfscheme.helpers.ModelReuseHelper;
import org.polarsys.kitalpha.resourcereuse.model.SearchCriteria;

public class ModelLoader {
    public IntrospectionContext introContext;

    public ModelLoader(IntrospectionContext context) {
        this.introContext = context;
    }

    private void loadFeature(Feature feature) {
        String featureId = feature.getId();
        String featureVersion = feature.getVersion();
        Version version = new Version(featureVersion);
        String qualifier = version.getQualifier();
        int qualifierSize = qualifier.length();
        String featureIdAndVersion = String.valueOf(featureId) + "_v_" + featureVersion;
        featureIdAndVersion = Helpers.controlVersionLabel(featureIdAndVersion, this.introContext.isQualifierMatch(), qualifierSize);
        this.introContext.addFeature_fromOtherModels(featureIdAndVersion, feature);
    }

    private void loadModel(EclipseModel rootElement, IProgressMonitor monitor) {
        EList repositories = rootElement.getRepositories();
        if (repositories != null) {
            for (Repository repository : repositories) {
                this.loadRepositoryContent(repository, this.introContext, monitor);
            }
        }
    }

    private void loadPackageContent(Package currentPackage, IntrospectionContext context) {
        EList subPackages;
        EList features;
        EList plugins = currentPackage.getPlugins();
        if (plugins != null) {
            for (Plugin plugin : plugins) {
                this.loadPlugin(plugin);
            }
        }
        if ((features = currentPackage.getFeatures()) != null) {
            for (Feature feature : features) {
                this.loadFeature(feature);
            }
        }
        if ((subPackages = currentPackage.getSubPackages()) != null) {
            for (Package currPackage : subPackages) {
                this.loadPackageContent(currPackage, this.introContext);
            }
        }
    }

    private void loadPlugin(Plugin plugin) {
        String pluginId = plugin.getId();
        String pluginVersion = plugin.getVersion();
        EList extensionPoints = new ArrayList();
        Version version = new Version(pluginVersion);
        String qualifier = version.getQualifier();
        int qualifierSize = qualifier.length();
        String pluginIdAndVersion = String.valueOf(pluginId) + "_v_" + pluginVersion;
        pluginIdAndVersion = Helpers.controlVersionLabel(pluginIdAndVersion, this.introContext.isQualifierMatch(), qualifierSize);
        if (plugin.getExtensionPoints().getExtensionPoints() != null || !plugin.getExtensionPoints().getExtensionPoints().isEmpty()) {
            extensionPoints = plugin.getExtensionPoints().getExtensionPoints();
            for (ExtensionPoint extensionPoint : extensionPoints) {
                this.introContext.addExtensionPoint(extensionPoint.getId(), extensionPoint);
            }
        }
        this.introContext.addPlugin_fromOtherModels(pluginIdAndVersion, plugin);
    }

    private void loadRepositoryContent(Repository repository, IntrospectionContext context, IProgressMonitor monitor) {
        EList packages;
        EList features;
        EList plugins;
        HashMap<String, Repository> repositoryHashMap = this.introContext.getRepositoryHashMap();
        RepositoryKind repositoryKind = repository.getRepositoryKind();
        switch (repositoryKind) {
            case PLATFORM: {
                repository.setName("Platform");
                break;
            }
            case WORKSPACE: {
                repository.setName("Workspace");
            }
        }
        String repoName = repository.getName();
        if (!repositoryHashMap.containsValue(repository)) {
            repositoryHashMap.put(repoName, repository);
        }
        if ((plugins = repository.getPlugins()) != null) {
            for (Plugin plugin : plugins) {
                this.loadPlugin(plugin);
            }
        }
        if ((features = repository.getFeatures()) != null) {
            for (Feature feature : features) {
                this.loadFeature(feature);
            }
        }
        if ((packages = repository.getPackages()) != null) {
            for (Package currentPackage : packages) {
                this.loadPackageContent(currentPackage, this.introContext);
            }
        }
    }

    public void loadOtherModels(ModelLoader modelLoader, List<URI> modelsToLoad, IProgressMonitor monitor, IFolder folder) {
        ArrayList<EclipseModel> eclipseExistingModels = new ArrayList<EclipseModel>();
        boolean reallyIgnoreQualifier = this.introContext.isQualifierMatch();
        for (URI modelURI : modelsToLoad) {
            if (monitor.isCanceled()) {
                return;
            }
            monitor.subTask("Browsing " + modelURI.toString());
            Resource resource = this.introContext.getResourceSet().getResource(modelURI, true);
            resource.setURI(modelURI);
            EList contents = resource.getContents();
            if (contents.size() == 1 && contents.get(0) instanceof EclipseModel) {
                EclipseModel rootElement = (EclipseModel)contents.get(0);
                eclipseExistingModels.add(rootElement);
                if (rootElement.isQualifierIgnored()) {
                    reallyIgnoreQualifier = true;
                }
            }
            monitor.worked(1);
        }
        this.introContext.setQualifierMatch(reallyIgnoreQualifier);
        for (EclipseModel rootElement : eclipseExistingModels) {
            this.loadModel(rootElement, monitor);
        }
    }

    private void checkContent(IContainer container, List<URI> modelsToLoad) {
        IResource[] tempResources = null;
        try {
            tempResources = container.members();
        }
        catch (CoreException e) {
            Status errorStatus = new Status(4, "org.polarsys.kitalpha.pdt.introspector.core", Messages.bind((String)Messages.ErrorResourcesMembers, (Object)container.getName()), (Throwable)e);
            StatusManager.getManager().handle((IStatus)errorStatus);
        }
        if (tempResources != null) {
            IResource[] iResourceArray = tempResources;
            int n = tempResources.length;
            int n2 = 0;
            while (n2 < n) {
                IFile fileTemp;
                String fileName;
                IResource member = iResourceArray[n2];
                if (member instanceof IContainer) {
                    IContainer containerTemp = (IContainer)member;
                    this.checkContent(containerTemp, modelsToLoad);
                } else if (member instanceof IFile && (fileName = (fileTemp = (IFile)member).getName()).endsWith(".platform")) {
                    URI uri = URI.createPlatformResourceURI((String)(String.valueOf(container.getProject().getName()) + "/" + fileTemp.getProjectRelativePath().toString()), (boolean)true);
                    modelsToLoad.add(uri);
                }
                ++n2;
            }
        }
    }

    public void findExistingModelsToReuse(List<URI> modelsToLoad, IFolder folder, SearchCriteria criteria) {
        block7: {
            block8: {
                IProject[] workspaceProjects;
                block6: {
                    if (!this.introContext.getIncrementalIntrospection().equals(IntrospectorPreferenceMessages.IntrospectorPreferenceMessages_ReuseFromResourceReuse)) break block6;
                    modelsToLoad.addAll(ModelReuseHelper.findModelsURIAccordingToCriteria((SearchCriteria)criteria));
                    break block7;
                }
                if (!this.introContext.getIncrementalIntrospection().equals(IntrospectorPreferenceMessages.IntrospectorPreferenceMessages_ReuseFromWorkspace)) break block8;
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                IWorkspaceRoot root = workspace.getRoot();
                IProject[] iProjectArray = workspaceProjects = root.getProjects();
                int n = workspaceProjects.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject project = iProjectArray[n2];
                    if (project.isOpen()) {
                        this.checkContent((IContainer)project, modelsToLoad);
                    }
                    ++n2;
                }
                break block7;
            }
            IResource[] members = null;
            try {
                members = folder.members();
            }
            catch (CoreException e) {
                Status errorStatus = new Status(4, "org.polarsys.kitalpha.pdt.introspector.core", Messages.bind((String)Messages.ErrorResourcesMembers, (Object)folder.getName()), (Throwable)e);
                StatusManager.getManager().handle((IStatus)errorStatus);
            }
            if (members == null) break block7;
            IResource[] iResourceArray = members;
            int n = members.length;
            int n3 = 0;
            while (n3 < n) {
                IFile file;
                String fileName;
                IResource member = iResourceArray[n3];
                if (member instanceof IFile && (fileName = (file = (IFile)member).getName()).endsWith(".platform")) {
                    URI uri = URI.createPlatformResourceURI((String)(String.valueOf(file.getProject().getName()) + "/" + file.getProjectRelativePath().toString()), (boolean)true);
                    modelsToLoad.add(uri);
                }
                ++n3;
            }
        }
    }
}

