/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.RecordPattern;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.codegen.BranchLabel;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.impl.JavaFeature;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.NullTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeIds;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.VoidTypeBinding;

public abstract class Pattern
extends Expression {
    boolean isTotalTypeNode = false;
    private RecordPattern enclosingPattern;
    protected MethodBinding accessorMethod;
    public int index = -1;
    public boolean isUnguarded = true;
    protected TypeBinding outerExpressionType;
    private boolean previewReported;

    public RecordPattern getEnclosingPattern() {
        return this.enclosingPattern;
    }

    public void setEnclosingPattern(RecordPattern enclosingPattern) {
        this.enclosingPattern = enclosingPattern;
    }

    public boolean isUnnamed() {
        return false;
    }

    public boolean coversType(TypeBinding type, Scope scope) {
        if (!this.isUnguarded()) {
            return false;
        }
        if (type == null || this.resolvedType == null) {
            return false;
        }
        if (type instanceof TypeVariableBinding && type.superclass().isBoxedPrimitiveType()) {
            type = type.superclass();
        }
        if (type.isPrimitiveOrBoxedPrimitiveType()) {
            PrimitiveConversionRoute route = this.findPrimitiveConversionRoute(this.resolvedType, type, scope);
            switch (route) {
                case IDENTITY_CONVERSION: 
                case BOXING_CONVERSION: 
                case BOXING_CONVERSION_AND_WIDENING_REFERENCE_CONVERSION: {
                    return true;
                }
                case WIDENING_PRIMITIVE_CONVERSION: {
                    return BaseTypeBinding.isExactWidening(this.resolvedType.id, type.id);
                }
                case WIDENING_AND_NARROWING_PRIMITIVE_CONVERSION: {
                    return false;
                }
                case UNBOXING_CONVERSION: {
                    return true;
                }
                case UNBOXING_AND_WIDENING_PRIMITIVE_CONVERSION: {
                    return BaseTypeBinding.isExactWidening(this.resolvedType.id, TypeIds.box2primitive(type.id));
                }
            }
        }
        return type.isSubtypeOf(this.resolvedType, false);
    }

    /*
     * WARNING - void declaration
     */
    public boolean coversValue(Constant cst, BlockScope scope) {
        void baseType;
        if (!this.isUnguarded()) {
            return false;
        }
        TypeBinding typeBinding = this.resolvedType;
        if (!(typeBinding instanceof BaseTypeBinding)) {
            return false;
        }
        BaseTypeBinding baseTypeBinding = (BaseTypeBinding)typeBinding;
        if (!cst.isExactTestingConversion((BaseTypeBinding)baseType)) {
            return false;
        }
        int constantTypeID = cst.typeID();
        PrimitiveConversionRoute route = this.findPrimitiveConversionRoute(this.resolvedType, TypeBinding.wellKnownBaseType(constantTypeID), scope);
        switch (route) {
            case NARROWING_PRIMITVE_CONVERSION: 
            case WIDENING_AND_NARROWING_PRIMITIVE_CONVERSION: {
                return true;
            }
            case WIDENING_PRIMITIVE_CONVERSION: {
                return BaseTypeBinding.isWidening(this.resolvedType.id, constantTypeID) && !BaseTypeBinding.isExactWidening(this.resolvedType.id, constantTypeID);
            }
        }
        return false;
    }

    public boolean isUnconditional(TypeBinding t, Scope scope) {
        return false;
    }

    public abstract void generateCode(BlockScope var1, CodeStream var2, BranchLabel var3, BranchLabel var4);

    @Override
    public boolean checkUnsafeCast(Scope scope, TypeBinding castType, TypeBinding expressionType, TypeBinding match, boolean isNarrowing) {
        if (!castType.isReifiable()) {
            return CastExpression.checkUnsafeCast(this, scope, castType, expressionType, match, isNarrowing);
        }
        return super.checkUnsafeCast(scope, castType, expressionType, match, isNarrowing);
    }

    public TypeReference getType() {
        return null;
    }

    protected boolean isApplicable(TypeBinding expressionType, BlockScope scope, ASTNode location) {
        if (expressionType == TypeBinding.NULL) {
            return true;
        }
        TypeReference typeRef = this.getType();
        if (typeRef == null) {
            return true;
        }
        TypeBinding patternType = typeRef.resolvedType;
        if (patternType == null || !patternType.isValidBinding() || !expressionType.isValidBinding()) {
            return false;
        }
        if (patternType.isBaseType() != expressionType.isBaseType() && !JavaFeature.PRIMITIVES_IN_PATTERNS.isSupported(scope.compilerOptions())) {
            scope.problemReporter().notCompatibleTypesError(location, expressionType, patternType);
            return false;
        }
        if (patternType.isBaseType()) {
            PrimitiveConversionRoute route = this.findPrimitiveConversionRoute(this.resolvedType, this.outerExpressionType, scope);
            if (!TypeBinding.equalsEquals(expressionType, patternType) && route == PrimitiveConversionRoute.NO_CONVERSION_ROUTE) {
                scope.problemReporter().notCompatibleTypesError(location, expressionType, patternType);
                return false;
            }
        } else {
            if (!this.checkCastTypesCompatibility(scope, patternType, expressionType, null, true)) {
                scope.problemReporter().notCompatibleTypesError(location, expressionType, patternType);
                return false;
            }
            if ((this.bits & 0x80) != 0) {
                scope.problemReporter().unsafeCastInTestingContext(location, patternType, this.outerExpressionType);
                return false;
            }
        }
        return true;
    }

    public abstract boolean dominates(Pattern var1, Scope var2);

    @Override
    public StringBuilder print(int indent, StringBuilder output) {
        return this.printExpression(indent, output);
    }

    public Pattern[] getAlternatives() {
        return new Pattern[]{this};
    }

    public abstract void setIsEitherOrPattern();

    public void setOuterExpressionType(TypeBinding expressionType) {
        this.outerExpressionType = expressionType;
    }

    public boolean isUnguarded() {
        return this.isUnguarded;
    }

    public void setIsGuarded() {
        this.isUnguarded = false;
    }

    public static boolean isBoxing(TypeBinding provided, TypeBinding expected) {
        if (expected.isBaseType() && !provided.isBaseType()) {
            int expectedId;
            switch (expected.id) {
                case 2: {
                    int n = 28;
                    break;
                }
                case 3: {
                    int n = 26;
                    break;
                }
                case 4: {
                    int n = 27;
                    break;
                }
                case 5: {
                    int n = 33;
                    break;
                }
                case 7: {
                    int n = 30;
                    break;
                }
                case 8: {
                    int n = 32;
                    break;
                }
                case 9: {
                    int n = 31;
                    break;
                }
                case 10: {
                    int n = 29;
                    break;
                }
                default: {
                    int n = expectedId = -1;
                }
            }
            return provided.id == expectedId;
        }
        return false;
    }

    public static PrimitiveConversionRoute findPrimitiveConversionRoute(TypeBinding destinationType, TypeBinding expressionType, Scope scope, ASTNode location) {
        boolean expressionIsBaseType;
        boolean destinationIsBaseType;
        block26: {
            block27: {
                if (!JavaFeature.PRIMITIVES_IN_PATTERNS.isSupported(scope.compilerOptions())) {
                    return PrimitiveConversionRoute.NO_CONVERSION_ROUTE;
                }
                if (destinationType == null || expressionType == null) {
                    return PrimitiveConversionRoute.NO_CONVERSION_ROUTE;
                }
                destinationIsBaseType = destinationType.isBaseType();
                expressionIsBaseType = expressionType.isBaseType();
                if (!expressionIsBaseType && !destinationIsBaseType || expressionType.id == 10 && destinationType.id == 10) break block26;
                if (!(location instanceof Pattern)) break block27;
                Pattern pattern = (Pattern)location;
                if (pattern.previewReported) break block26;
                pattern.previewReported = true;
            }
            scope.problemReporter().previewFeatureUsed(location.sourceStart, location.sourceEnd);
        }
        if (destinationIsBaseType && expressionIsBaseType) {
            if (TypeBinding.equalsEquals(destinationType, expressionType)) {
                return PrimitiveConversionRoute.IDENTITY_CONVERSION;
            }
            if (BaseTypeBinding.isWideningAndNarrowing(destinationType.id, expressionType.id)) {
                return PrimitiveConversionRoute.WIDENING_AND_NARROWING_PRIMITIVE_CONVERSION;
            }
            if (BaseTypeBinding.isWidening(destinationType.id, expressionType.id)) {
                return PrimitiveConversionRoute.WIDENING_PRIMITIVE_CONVERSION;
            }
            if (BaseTypeBinding.isNarrowing(destinationType.id, expressionType.id)) {
                return PrimitiveConversionRoute.NARROWING_PRIMITVE_CONVERSION;
            }
        } else if (expressionIsBaseType) {
            if (expressionType instanceof NullTypeBinding || expressionType instanceof VoidTypeBinding) {
                return PrimitiveConversionRoute.NO_CONVERSION_ROUTE;
            }
            if (Pattern.isBoxing(destinationType, expressionType)) {
                return PrimitiveConversionRoute.BOXING_CONVERSION;
            }
            if (scope.environment().computeBoxingType(expressionType).isCompatibleWith(destinationType)) {
                return PrimitiveConversionRoute.BOXING_CONVERSION_AND_WIDENING_REFERENCE_CONVERSION;
            }
        } else if (expressionType.isBoxedPrimitiveType() && destinationIsBaseType) {
            TypeBinding unboxedExpressionType = scope.environment().computeBoxingType(expressionType);
            if (TypeBinding.equalsEquals(destinationType, unboxedExpressionType)) {
                return PrimitiveConversionRoute.UNBOXING_CONVERSION;
            }
            if (BaseTypeBinding.isWidening(destinationType.id, unboxedExpressionType.id)) {
                return PrimitiveConversionRoute.UNBOXING_AND_WIDENING_PRIMITIVE_CONVERSION;
            }
        } else if (destinationIsBaseType) {
            TypeBinding boxedDestinationType;
            if (expressionType instanceof TypeVariableBinding && expressionType.superclass().isBoxedPrimitiveType()) {
                int boxId = expressionType.superclass().id;
                int exprPrimId = TypeIds.box2primitive(boxId);
                if (exprPrimId == destinationType.id) {
                    return PrimitiveConversionRoute.WIDENING_REFERENCE_AND_UNBOXING_COVERSION;
                }
                if (BaseTypeBinding.isWidening(destinationType.id, exprPrimId)) {
                    return PrimitiveConversionRoute.WIDENING_REFERENCE_AND_UNBOXING_COVERSION_AND_WIDENING_PRIMITIVE_CONVERSION;
                }
            }
            if ((boxedDestinationType = scope.environment().computeBoxingType(destinationType)).isCompatibleWith(expressionType.erasure())) {
                return PrimitiveConversionRoute.NARROWING_AND_UNBOXING_CONVERSION;
            }
        }
        return PrimitiveConversionRoute.NO_CONVERSION_ROUTE;
    }

    public PrimitiveConversionRoute findPrimitiveConversionRoute(TypeBinding destinationType, TypeBinding expressionType, Scope scope) {
        return Pattern.findPrimitiveConversionRoute(destinationType, expressionType, scope, this);
    }

    public static enum PrimitiveConversionRoute {
        IDENTITY_CONVERSION,
        WIDENING_PRIMITIVE_CONVERSION,
        NARROWING_PRIMITVE_CONVERSION,
        WIDENING_AND_NARROWING_PRIMITIVE_CONVERSION,
        BOXING_CONVERSION,
        BOXING_CONVERSION_AND_WIDENING_REFERENCE_CONVERSION,
        WIDENING_REFERENCE_AND_UNBOXING_COVERSION,
        WIDENING_REFERENCE_AND_UNBOXING_COVERSION_AND_WIDENING_PRIMITIVE_CONVERSION,
        NARROWING_AND_UNBOXING_CONVERSION,
        UNBOXING_CONVERSION,
        UNBOXING_AND_WIDENING_PRIMITIVE_CONVERSION,
        NO_CONVERSION_ROUTE;

    }

    record TestContextRecord(TypeBinding left, TypeBinding right, PrimitiveConversionRoute route) {
    }
}

