/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import org.eclipse.january.dataset.ShapeUtils;
import org.junit.Assert;
import org.junit.Test;

public class ShapeUtilsTest {
    @Test
    public void testAxesReduction() {
        int[] remain = ShapeUtils.getRemainingAxes((int)4, (int[])new int[]{2, -1});
        int[] nArray = new int[2];
        nArray[1] = 1;
        Assert.assertArrayEquals((int[])nArray, (int[])remain);
        remain = ShapeUtils.getRemainingAxes((int)4, (int[])new int[]{1, -2});
        int[] nArray2 = new int[2];
        nArray2[1] = 3;
        Assert.assertArrayEquals((int[])nArray2, (int[])remain);
        remain = ShapeUtils.reduceShape((int[])new int[]{2, 3, 4, 5}, (int[])new int[]{-1, 2});
        Assert.assertArrayEquals((int[])new int[]{2, 3}, (int[])remain);
        remain = ShapeUtils.reduceShape((int[])new int[]{2, 3, 4, 5}, (int[])new int[]{1, -2});
        Assert.assertArrayEquals((int[])new int[]{2, 5}, (int[])remain);
        remain = ShapeUtils.getReducedShapeKeepRank((int[])new int[]{2, 3, 4, 5}, (int[])new int[]{1, -2});
        Assert.assertArrayEquals((int[])new int[]{2, 1, 1, 5}, (int[])remain);
    }

    @Test
    public void testDiffersByOnes() {
        Assert.assertTrue((boolean)ShapeUtils.differsByOnes((int[])new int[0], (int[])new int[0]));
        Assert.assertTrue((boolean)ShapeUtils.differsByOnes((int[])new int[]{1, 1, 1}, (int[])new int[0]));
        Assert.assertTrue((boolean)ShapeUtils.differsByOnes((int[])new int[0], (int[])new int[]{1, 1, 1}));
        Assert.assertTrue((boolean)ShapeUtils.differsByOnes((int[])new int[]{2}, (int[])new int[]{2}));
        Assert.assertTrue((boolean)ShapeUtils.differsByOnes((int[])new int[]{1, 1, 1, 2}, (int[])new int[]{2}));
        Assert.assertTrue((boolean)ShapeUtils.differsByOnes((int[])new int[]{1, 1, 1, 2}, (int[])new int[]{2, 1, 1, 1}));
        Assert.assertTrue((boolean)ShapeUtils.differsByOnes((int[])new int[]{2}, (int[])new int[]{2, 1, 1, 1}));
        Assert.assertTrue((boolean)ShapeUtils.differsByOnes((int[])new int[]{2}, (int[])new int[]{1, 1, 1, 2}));
        Assert.assertTrue((boolean)ShapeUtils.differsByOnes((int[])new int[]{2, 3}, (int[])new int[]{2, 3}));
        Assert.assertTrue((boolean)ShapeUtils.differsByOnes((int[])new int[]{1, 1, 1, 2, 3}, (int[])new int[]{2, 3}));
        Assert.assertTrue((boolean)ShapeUtils.differsByOnes((int[])new int[]{1, 1, 1, 2, 3}, (int[])new int[]{2, 3, 1, 1, 1}));
        Assert.assertTrue((boolean)ShapeUtils.differsByOnes((int[])new int[]{2, 3}, (int[])new int[]{2, 3, 1, 1, 1}));
        Assert.assertTrue((boolean)ShapeUtils.differsByOnes((int[])new int[]{2, 3}, (int[])new int[]{1, 1, 1, 2, 3}));
        Assert.assertTrue((boolean)ShapeUtils.differsByOnes((int[])new int[]{2, 3}, (int[])new int[]{2, 1, 1, 3}));
        Assert.assertTrue((boolean)ShapeUtils.differsByOnes((int[])new int[]{1, 1, 1, 2, 3}, (int[])new int[]{2, 1, 1, 3}));
        Assert.assertTrue((boolean)ShapeUtils.differsByOnes((int[])new int[]{1, 1, 1, 2, 3}, (int[])new int[]{2, 1, 1, 3, 1, 1, 1}));
        Assert.assertTrue((boolean)ShapeUtils.differsByOnes((int[])new int[]{2, 3}, (int[])new int[]{2, 1, 1, 3, 1, 1, 1}));
        Assert.assertTrue((boolean)ShapeUtils.differsByOnes((int[])new int[]{2, 3}, (int[])new int[]{1, 1, 1, 2, 1, 1, 3}));
        Assert.assertTrue((boolean)ShapeUtils.differsByOnes((int[])new int[]{2, 1, 1, 3}, (int[])new int[]{2, 3}));
        Assert.assertTrue((boolean)ShapeUtils.differsByOnes((int[])new int[]{1, 1, 1, 2, 1, 1, 3}, (int[])new int[]{2, 3}));
        Assert.assertTrue((boolean)ShapeUtils.differsByOnes((int[])new int[]{1, 1, 1, 2, 1, 1, 3}, (int[])new int[]{2, 3, 1, 1, 1}));
        Assert.assertTrue((boolean)ShapeUtils.differsByOnes((int[])new int[]{2, 1, 1, 3}, (int[])new int[]{2, 3, 1, 1, 1}));
        Assert.assertTrue((boolean)ShapeUtils.differsByOnes((int[])new int[]{2, 1, 1, 3}, (int[])new int[]{1, 1, 1, 2, 3}));
        Assert.assertFalse((boolean)ShapeUtils.differsByOnes((int[])new int[]{2}, (int[])new int[]{4}));
        Assert.assertFalse((boolean)ShapeUtils.differsByOnes((int[])new int[]{1, 1, 1, 2}, (int[])new int[]{4}));
        Assert.assertFalse((boolean)ShapeUtils.differsByOnes((int[])new int[]{1, 1, 1, 2}, (int[])new int[]{4, 1, 1, 1}));
        Assert.assertFalse((boolean)ShapeUtils.differsByOnes((int[])new int[]{2}, (int[])new int[]{4, 1, 1, 1}));
        Assert.assertFalse((boolean)ShapeUtils.differsByOnes((int[])new int[]{2}, (int[])new int[]{1, 1, 1, 4}));
        Assert.assertFalse((boolean)ShapeUtils.differsByOnes((int[])new int[]{2, 3}, (int[])new int[]{2, 4}));
        Assert.assertFalse((boolean)ShapeUtils.differsByOnes((int[])new int[]{1, 1, 1, 2, 3}, (int[])new int[]{2, 4}));
        Assert.assertFalse((boolean)ShapeUtils.differsByOnes((int[])new int[]{1, 1, 1, 2, 3}, (int[])new int[]{2, 4, 1, 1, 1}));
        Assert.assertFalse((boolean)ShapeUtils.differsByOnes((int[])new int[]{2, 3}, (int[])new int[]{2, 4, 1, 1, 1}));
        Assert.assertFalse((boolean)ShapeUtils.differsByOnes((int[])new int[]{2, 3}, (int[])new int[]{1, 1, 1, 2, 4}));
        Assert.assertFalse((boolean)ShapeUtils.differsByOnes((int[])new int[]{2, 3}, (int[])new int[]{2, 1, 1, 4}));
        Assert.assertFalse((boolean)ShapeUtils.differsByOnes((int[])new int[]{1, 1, 1, 2, 3}, (int[])new int[]{2, 1, 1, 4}));
        Assert.assertFalse((boolean)ShapeUtils.differsByOnes((int[])new int[]{1, 1, 1, 2, 3}, (int[])new int[]{2, 1, 1, 4, 1, 1, 1}));
        Assert.assertFalse((boolean)ShapeUtils.differsByOnes((int[])new int[]{2, 3}, (int[])new int[]{2, 1, 1, 4, 1, 1, 1}));
        Assert.assertFalse((boolean)ShapeUtils.differsByOnes((int[])new int[]{2, 3}, (int[])new int[]{1, 1, 1, 2, 1, 1, 4}));
        Assert.assertFalse((boolean)ShapeUtils.differsByOnes((int[])new int[]{2, 1, 1, 3}, (int[])new int[]{2, 4}));
        Assert.assertFalse((boolean)ShapeUtils.differsByOnes((int[])new int[]{1, 1, 1, 2, 1, 1, 3}, (int[])new int[]{2, 4}));
        Assert.assertFalse((boolean)ShapeUtils.differsByOnes((int[])new int[]{1, 1, 1, 2, 1, 1, 3}, (int[])new int[]{2, 4, 1, 1, 1}));
        Assert.assertFalse((boolean)ShapeUtils.differsByOnes((int[])new int[]{2, 1, 1, 3}, (int[])new int[]{2, 4, 1, 1, 1}));
        Assert.assertFalse((boolean)ShapeUtils.differsByOnes((int[])new int[]{2, 1, 1, 3}, (int[])new int[]{1, 1, 1, 2, 4}));
    }

    @Test
    public void testCalcShapePadding() {
        Assert.assertNull((Object)ShapeUtils.calcShapePadding(null, null));
        Assert.assertNull((Object)ShapeUtils.calcShapePadding((int[])new int[0], (int[])new int[0]));
        Assert.assertNull((Object)ShapeUtils.calcShapePadding((int[])new int[]{2, 1, 3}, (int[])new int[]{2, 1, 3}));
        Assert.assertArrayEquals((int[])new int[]{-2}, (int[])ShapeUtils.calcShapePadding((int[])new int[]{1, 1}, (int[])new int[0]));
        Assert.assertArrayEquals((int[])new int[]{2}, (int[])ShapeUtils.calcShapePadding((int[])new int[0], (int[])new int[]{1, 1}));
        int[] nArray = new int[2];
        nArray[0] = 1;
        Assert.assertArrayEquals((int[])nArray, (int[])ShapeUtils.calcShapePadding((int[])new int[]{2}, (int[])new int[]{1, 2}));
        int[] nArray2 = new int[2];
        nArray2[1] = 1;
        Assert.assertArrayEquals((int[])nArray2, (int[])ShapeUtils.calcShapePadding((int[])new int[]{2}, (int[])new int[]{2, 1}));
        int[] nArray3 = new int[3];
        nArray3[0] = 1;
        nArray3[2] = 1;
        Assert.assertArrayEquals((int[])nArray3, (int[])ShapeUtils.calcShapePadding((int[])new int[]{2}, (int[])new int[]{1, 2, 1}));
        int[] nArray4 = new int[2];
        nArray4[0] = -1;
        Assert.assertArrayEquals((int[])nArray4, (int[])ShapeUtils.calcShapePadding((int[])new int[]{1, 2}, (int[])new int[]{2}));
        int[] nArray5 = new int[3];
        nArray5[0] = -1;
        nArray5[2] = 1;
        Assert.assertArrayEquals((int[])nArray5, (int[])ShapeUtils.calcShapePadding((int[])new int[]{1, 2}, (int[])new int[]{2, 1}));
        int[] nArray6 = new int[3];
        nArray6[2] = 1;
        Assert.assertArrayEquals((int[])nArray6, (int[])ShapeUtils.calcShapePadding((int[])new int[]{1, 2}, (int[])new int[]{1, 2, 1}));
        int[] nArray7 = new int[2];
        nArray7[1] = -1;
        Assert.assertArrayEquals((int[])nArray7, (int[])ShapeUtils.calcShapePadding((int[])new int[]{2, 1}, (int[])new int[]{2}));
        int[] nArray8 = new int[3];
        nArray8[0] = 1;
        Assert.assertArrayEquals((int[])nArray8, (int[])ShapeUtils.calcShapePadding((int[])new int[]{2, 1}, (int[])new int[]{1, 2, 1}));
        int[] nArray9 = new int[3];
        nArray9[0] = 1;
        nArray9[2] = -1;
        Assert.assertArrayEquals((int[])nArray9, (int[])ShapeUtils.calcShapePadding((int[])new int[]{2, 1}, (int[])new int[]{1, 2}));
        int[] nArray10 = new int[3];
        nArray10[0] = -1;
        nArray10[2] = -1;
        Assert.assertArrayEquals((int[])nArray10, (int[])ShapeUtils.calcShapePadding((int[])new int[]{1, 2, 1}, (int[])new int[]{2}));
        int[] nArray11 = new int[3];
        nArray11[0] = 1;
        Assert.assertArrayEquals((int[])nArray11, (int[])ShapeUtils.calcShapePadding((int[])new int[]{2, 3}, (int[])new int[]{1, 2, 3}));
        int[] nArray12 = new int[3];
        nArray12[1] = 1;
        Assert.assertArrayEquals((int[])nArray12, (int[])ShapeUtils.calcShapePadding((int[])new int[]{2, 3}, (int[])new int[]{2, 1, 3}));
        int[] nArray13 = new int[3];
        nArray13[2] = 1;
        Assert.assertArrayEquals((int[])nArray13, (int[])ShapeUtils.calcShapePadding((int[])new int[]{2, 3}, (int[])new int[]{2, 3, 1}));
        int[] nArray14 = new int[4];
        nArray14[0] = 1;
        Assert.assertArrayEquals((int[])nArray14, (int[])ShapeUtils.calcShapePadding((int[])new int[]{2, 1, 3}, (int[])new int[]{1, 2, 1, 3}));
        int[] nArray15 = new int[4];
        nArray15[2] = 1;
        Assert.assertArrayEquals((int[])nArray15, (int[])ShapeUtils.calcShapePadding((int[])new int[]{2, 1, 3}, (int[])new int[]{2, 1, 1, 3}));
        int[] nArray16 = new int[4];
        nArray16[3] = 1;
        Assert.assertArrayEquals((int[])nArray16, (int[])ShapeUtils.calcShapePadding((int[])new int[]{2, 1, 3}, (int[])new int[]{2, 1, 3, 1}));
        int[] nArray17 = new int[4];
        nArray17[0] = 1;
        nArray17[2] = -1;
        Assert.assertArrayEquals((int[])nArray17, (int[])ShapeUtils.calcShapePadding((int[])new int[]{2, 1, 3}, (int[])new int[]{1, 2, 3}));
        int[] nArray18 = new int[3];
        nArray18[1] = -1;
        Assert.assertArrayEquals((int[])nArray18, (int[])ShapeUtils.calcShapePadding((int[])new int[]{2, 1, 3}, (int[])new int[]{2, 3}));
        int[] nArray19 = new int[4];
        nArray19[1] = -1;
        nArray19[3] = 1;
        Assert.assertArrayEquals((int[])nArray19, (int[])ShapeUtils.calcShapePadding((int[])new int[]{2, 1, 3}, (int[])new int[]{2, 3, 1}));
        int[] nArray20 = new int[5];
        nArray20[0] = 1;
        nArray20[3] = -1;
        Assert.assertArrayEquals((int[])nArray20, (int[])ShapeUtils.calcShapePadding((int[])new int[]{2, 1, 1, 3}, (int[])new int[]{1, 2, 1, 3}));
        int[] nArray21 = new int[4];
        nArray21[2] = -1;
        Assert.assertArrayEquals((int[])nArray21, (int[])ShapeUtils.calcShapePadding((int[])new int[]{2, 1, 1, 3}, (int[])new int[]{2, 1, 3}));
        int[] nArray22 = new int[4];
        nArray22[1] = -2;
        nArray22[3] = 1;
        Assert.assertArrayEquals((int[])nArray22, (int[])ShapeUtils.calcShapePadding((int[])new int[]{2, 1, 1, 3}, (int[])new int[]{2, 3, 1}));
    }

    @Test
    public void testPadding() {
        this.testPadding(new int[0], new int[0]);
        this.testPadding(new int[]{2}, new int[]{2});
        this.testPadding(new int[]{2}, new int[]{2, 1});
        this.testPadding(new int[]{1, 2}, new int[]{2});
        this.testPadding(new int[]{1, 2}, new int[]{2, 1});
        this.testPadding(new int[]{1, 2}, new int[]{1, 2, 1});
        this.testPadding(new int[]{2, 1}, new int[]{2});
        this.testPadding(new int[]{2, 1}, new int[]{1, 2});
        this.testPadding(new int[]{2, 1}, new int[]{1, 2, 1});
        this.testPadding(new int[]{2, 3}, new int[]{2, 3});
        this.testPadding(new int[]{2, 3}, new int[]{2, 1, 3});
        this.testPadding(new int[]{1, 2, 3}, new int[]{2, 3});
        this.testPadding(new int[]{1, 2, 3}, new int[]{2, 1, 3});
        this.testPadding(new int[]{1, 2, 3}, new int[]{1, 2, 1, 3});
        this.testPadding(new int[]{2, 3, 1}, new int[]{2, 3});
        this.testPadding(new int[]{2, 3, 1}, new int[]{1, 2, 3});
        this.testPadding(new int[]{2, 3, 1}, new int[]{1, 2, 1, 3});
        this.testPadding(new int[]{2, 3}, new int[]{2, 3});
        this.testPadding(new int[]{2, 3}, new int[]{2, 1, 3});
        this.testPadding(new int[]{1, 2, 3}, new int[]{2, 3});
        this.testPadding(new int[]{1, 2, 3}, new int[]{2, 1, 3});
        this.testPadding(new int[]{1, 2, 3}, new int[]{1, 2, 1, 3});
        this.testPadding(new int[]{2, 3, 1}, new int[]{2, 3});
        this.testPadding(new int[]{2, 3, 1}, new int[]{1, 2, 3});
        this.testPadding(new int[]{2, 3, 1}, new int[]{1, 2, 1, 3});
    }

    void testPadding(int[] a, int[] b) {
        int[] p = ShapeUtils.calcShapePadding((int[])a, (int[])b);
        Assert.assertArrayEquals((int[])b, (int[])ShapeUtils.padShape((int[])p, (int)b.length, (int[])a));
        p = ShapeUtils.calcShapePadding((int[])b, (int[])a);
        Assert.assertArrayEquals((int[])a, (int[])ShapeUtils.padShape((int[])p, (int)a.length, (int[])b));
    }
}

