/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.january.asserts.TestUtils;
import org.eclipse.january.dataset.AbstractDataset;
import org.eclipse.january.dataset.ByteDataset;
import org.eclipse.january.dataset.ComplexDoubleDataset;
import org.eclipse.january.dataset.CompoundDoubleDataset;
import org.eclipse.january.dataset.CompoundFloatDataset;
import org.eclipse.january.dataset.DTypeUtils;
import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.DatasetFactory;
import org.eclipse.january.dataset.DatasetUtils;
import org.eclipse.january.dataset.DoubleDataset;
import org.eclipse.january.dataset.IDataset;
import org.eclipse.january.dataset.ILazyDataset;
import org.eclipse.january.dataset.ShortDataset;
import org.junit.Assert;
import org.junit.Test;

public class DatasetUtilsTest {
    @Test
    public void testSplit() {
        Dataset dataset = DatasetFactory.createFromObject((Object)new int[]{1, 2, 3});
        Dataset expected1 = DatasetFactory.createFromObject((Object)new int[]{1});
        Dataset expected2 = DatasetFactory.createFromObject((Object)new int[]{2, 3});
        ArrayList<Dataset> expected = new ArrayList<Dataset>();
        expected.add(expected1);
        expected.add(expected2);
        int[] indices = new int[]{1};
        List actual = DatasetUtils.split((Dataset)dataset, (int[])indices, (int)0);
        Assert.assertEquals((long)expected.size(), (long)actual.size());
        int i = 0;
        while (i < expected.size()) {
            TestUtils.assertDatasetEquals((Dataset)((Dataset)expected.get(i)), (Dataset)((Dataset)actual.get(i)));
            ++i;
        }
        actual = DatasetUtils.split((Dataset)dataset, (int[])indices, (int)-1);
        Assert.assertEquals((long)expected.size(), (long)actual.size());
        i = 0;
        while (i < expected.size()) {
            TestUtils.assertDatasetEquals((Dataset)((Dataset)expected.get(i)), (Dataset)((Dataset)actual.get(i)));
            ++i;
        }
    }

    @Test
    public void testSplit2() {
        Dataset dataset = DatasetFactory.createFromObject((Object)new int[]{1, 2, 3});
        Dataset expected1 = DatasetFactory.zeros((int)1, dataset.getClass(), (int[])new int[]{0});
        Dataset expected2 = DatasetFactory.createFromObject((Object)new int[]{1, 2, 3});
        ArrayList<Dataset> expected = new ArrayList<Dataset>();
        expected.add(expected1);
        expected.add(expected2);
        int[] indices = new int[]{4};
        List actual = DatasetUtils.split((Dataset)dataset, (int[])indices, (int)0);
        Assert.assertEquals((long)expected.size(), (long)actual.size());
        int i = 0;
        while (i < expected.size()) {
            TestUtils.assertDatasetEquals((Dataset)((Dataset)expected.get(i)), (Dataset)((Dataset)actual.get(i)));
            ++i;
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSplitException() {
        Dataset dataset = DatasetFactory.createFromObject((Object)new int[]{1, 2, 3});
        int[] indices = new int[]{1};
        DatasetUtils.split((Dataset)dataset, (int[])indices, (int)1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCrossingsException() {
        Dataset xAxis = DatasetFactory.createFromObject((Object)new double[]{0.0, 0.0, 0.0});
        Dataset yAxis = DatasetFactory.createFromObject((Object)new double[]{0.0, 0.0});
        DatasetUtils.crossings((Dataset)xAxis, (Dataset)yAxis, (double)0.0);
    }

    @Test
    public void testMakeUnsigned() {
        byte[] byArray = new byte[3];
        byArray[1] = 1;
        byArray[2] = 127;
        ByteDataset pos = (ByteDataset)DatasetFactory.createFromObject(ByteDataset.class, (Object)byArray);
        short[] sArray = new short[3];
        sArray[1] = 1;
        sArray[2] = 127;
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject(ShortDataset.class, (Object)sArray), (Dataset)DatasetUtils.makeUnsigned((IDataset)pos, (boolean)false));
        byte[] byArray2 = new byte[3];
        byArray2[1] = 1;
        byArray2[2] = 127;
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject(ByteDataset.class, (Object)byArray2), (Dataset)DatasetUtils.makeUnsigned((IDataset)pos, (boolean)true));
        byte[] byArray3 = new byte[3];
        byArray3[1] = -1;
        byArray3[2] = -128;
        ByteDataset neg = (ByteDataset)DatasetFactory.createFromObject(ByteDataset.class, (Object)byArray3);
        short[] sArray2 = new short[3];
        sArray2[1] = 255;
        sArray2[2] = 128;
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject(ShortDataset.class, (Object)sArray2), (Dataset)DatasetUtils.makeUnsigned((IDataset)neg, (boolean)false));
        short[] sArray3 = new short[3];
        sArray3[1] = 255;
        sArray3[2] = 128;
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject(ShortDataset.class, (Object)sArray3), (Dataset)DatasetUtils.makeUnsigned((IDataset)neg, (boolean)true));
    }

    @Test
    public void testSplitEqual() {
        Dataset dataset = DatasetFactory.createFromObject((Object)new int[]{1, 2, 3, 4});
        Dataset expected1 = DatasetFactory.createFromObject((Object)new int[]{1, 2});
        Dataset expected2 = DatasetFactory.createFromObject((Object)new int[]{3, 4});
        ArrayList<Dataset> expected = new ArrayList<Dataset>();
        expected.add(expected1);
        expected.add(expected2);
        List actual = DatasetUtils.split((Dataset)dataset, (int)2, (int)0, (boolean)false);
        Assert.assertEquals((long)expected.size(), (long)actual.size());
        int i = 0;
        while (i < expected.size()) {
            TestUtils.assertDatasetEquals((Dataset)((Dataset)expected.get(i)), (Dataset)((Dataset)actual.get(i)));
            ++i;
        }
        actual = DatasetUtils.split((Dataset)dataset, (int)2, (int)-1, (boolean)false);
        Assert.assertEquals((long)expected.size(), (long)actual.size());
        i = 0;
        while (i < expected.size()) {
            TestUtils.assertDatasetEquals((Dataset)((Dataset)expected.get(i)), (Dataset)((Dataset)actual.get(i)));
            ++i;
        }
    }

    @Test
    public void testSplitEqual2() {
        Dataset dataset = DatasetFactory.createFromObject((Object)new int[]{1, 2, 3, 4});
        Dataset expected1 = DatasetFactory.createFromObject((Object)new int[]{1});
        Dataset expected2 = DatasetFactory.createFromObject((Object)new int[]{2});
        Dataset expected3 = DatasetFactory.createFromObject((Object)new int[]{3});
        Dataset expected4 = DatasetFactory.createFromObject((Object)new int[]{4});
        Dataset expected5 = DatasetFactory.zeros((int)1, dataset.getClass(), (int[])new int[]{0});
        ArrayList<Dataset> expected = new ArrayList<Dataset>();
        expected.add(expected1);
        expected.add(expected2);
        expected.add(expected3);
        expected.add(expected4);
        expected.add(expected5);
        List actual = DatasetUtils.split((Dataset)dataset, (int)6, (int)0, (boolean)false);
        Assert.assertEquals((long)expected.size(), (long)actual.size());
        int i = 0;
        while (i < expected.size()) {
            TestUtils.assertDatasetEquals((Dataset)((Dataset)expected.get(i)), (Dataset)((Dataset)actual.get(i)));
            ++i;
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSplitEqualException() {
        Dataset dataset = DatasetFactory.createFromObject((Object)new int[]{1, 2, 3, 4});
        Dataset expected1 = DatasetFactory.createFromObject((Object)new int[]{1, 2});
        Dataset expected2 = DatasetFactory.createFromObject((Object)new int[]{3, 4});
        ArrayList<Dataset> expected = new ArrayList<Dataset>();
        expected.add(expected1);
        expected.add(expected2);
        DatasetUtils.split((Dataset)dataset, (int)3, (int)0, (boolean)true);
    }

    @Test
    public void testRemoveNansAndInfinitiesDouble() {
        double dvalue = 13.0;
        Dataset dataset = DatasetFactory.createFromObject((Object)new double[][]{{10.0, 11.0, Double.NaN}, {Double.POSITIVE_INFINITY, Double.MAX_VALUE, 69.0}, {Double.MIN_VALUE, 0.0, Double.NEGATIVE_INFINITY}});
        Dataset expected = DatasetFactory.createFromObject((Object)new double[][]{{10.0, 11.0, dvalue}, {dvalue, Double.MAX_VALUE, 69.0}, {Double.MIN_VALUE, 0.0, dvalue}});
        DatasetUtils.removeNansAndInfinities((Dataset)dataset, (Number)dvalue);
        TestUtils.assertDatasetEquals((Dataset)dataset, (Dataset)expected);
    }

    @Test
    public void testRemoveNansAndInfinitiesFloat() {
        float dvalue = 13.0f;
        Dataset dataset = DatasetFactory.createFromObject((Object)new float[][]{{10.0f, 11.0f, Float.NaN}, {Float.POSITIVE_INFINITY, Float.MAX_VALUE, 69.0f}, {Float.MIN_VALUE, 0.0f, Float.NEGATIVE_INFINITY}});
        Dataset expected = DatasetFactory.createFromObject((Object)new float[][]{{10.0f, 11.0f, dvalue}, {dvalue, Float.MAX_VALUE, 69.0f}, {Float.MIN_VALUE, 0.0f, dvalue}});
        DatasetUtils.removeNansAndInfinities((Dataset)dataset, (Number)Float.valueOf(dvalue));
        TestUtils.assertDatasetEquals((Dataset)dataset, (Dataset)expected);
    }

    @Test
    public void testRemoveNansAndInfinitiesCompoundDouble() {
        double dvalue = 13.0;
        double[] da = new double[]{0.0, 0.5, 1.0, Double.MAX_VALUE, 2.0, 2.5, 3.0, 3.5, Double.NEGATIVE_INFINITY, Double.NaN, 5.0, 5.5, 6.0, 6.5, 7.0, 7.5, 8.0, 8.5, 9.0, 9.5, Double.MIN_VALUE, 10.5, 11.0, Double.POSITIVE_INFINITY};
        double[] eda = new double[]{0.0, 0.5, 1.0, Double.MAX_VALUE, 2.0, 2.5, 3.0, 3.5, dvalue, dvalue, 5.0, 5.5, 6.0, 6.5, 7.0, 7.5, 8.0, 8.5, 9.0, 9.5, Double.MIN_VALUE, 10.5, 11.0, dvalue};
        CompoundDoubleDataset dataset = new CompoundDoubleDataset(2, da, new int[0]);
        CompoundDoubleDataset expected = new CompoundDoubleDataset(2, eda, new int[0]);
        DatasetUtils.removeNansAndInfinities((Dataset)dataset, (Number)dvalue);
        TestUtils.assertDatasetEquals((Dataset)dataset, (Dataset)expected);
    }

    @Test
    public void testRemoveNansAndInfinitiesCompoundFloat() {
        float dvalue = 13.0f;
        float[] da = new float[]{0.0f, 0.5f, 1.0f, Float.MAX_VALUE, 2.0f, 2.5f, 3.0f, 3.5f, Float.NEGATIVE_INFINITY, Float.NaN, 5.0f, 5.5f, 6.0f, 6.5f, 7.0f, 7.5f, 8.0f, 8.5f, 9.0f, 9.5f, Float.MIN_VALUE, 10.5f, 11.0f, Float.POSITIVE_INFINITY};
        float[] eda = new float[]{0.0f, 0.5f, 1.0f, Float.MAX_VALUE, 2.0f, 2.5f, 3.0f, 3.5f, dvalue, dvalue, 5.0f, 5.5f, 6.0f, 6.5f, 7.0f, 7.5f, 8.0f, 8.5f, 9.0f, 9.5f, Float.MIN_VALUE, 10.5f, 11.0f, dvalue};
        CompoundFloatDataset dataset = new CompoundFloatDataset(2, da, new int[0]);
        CompoundFloatDataset expected = new CompoundFloatDataset(2, eda, new int[0]);
        DatasetUtils.removeNansAndInfinities((Dataset)dataset, (Number)Float.valueOf(dvalue));
        TestUtils.assertDatasetEquals((Dataset)dataset, (Dataset)expected);
    }

    @Test
    public void testRemoveNansAndInfinitiesOther() {
        Double value = 13.0;
        Dataset dataset = DatasetFactory.createFromObject((Object)new int[][]{{10, 11, Integer.MAX_VALUE}, {Integer.MIN_VALUE, 5, 13}});
        Dataset expected = dataset.clone();
        DatasetUtils.removeNansAndInfinities((Dataset)dataset, (Number)value);
        TestUtils.assertDatasetEquals((Dataset)dataset, (Dataset)expected);
    }

    @Test
    public void testFindIndexEqualTo() {
        Dataset dataset = DatasetFactory.createFromObject((Object)new double[]{5.2, 2.0, 4.8, 13.0, 0.8, 96.0, 13.0});
        int expected = 3;
        int actual = DatasetUtils.findIndexEqualTo((Dataset)dataset, (double)13.0);
        Assert.assertEquals((long)expected, (long)actual);
    }

    @Test
    public void testFindIndexGreaterThan() {
        Dataset dataset = DatasetFactory.createFromObject((Object)new double[]{5.2, 2.0, 4.8, 13.0, 0.8, 96.0, 13.0});
        int expected = 5;
        int actual = DatasetUtils.findIndexGreaterThan((Dataset)dataset, (double)50.0);
        Assert.assertEquals((long)expected, (long)actual);
    }

    @Test
    public void testFindIndexGreaterThanOrEqualTo() {
        Dataset dataset = DatasetFactory.createFromObject((Object)new double[]{5.2, 2.0, 4.8, 13.0, 0.8, 96.0, 13.0});
        int expected = 3;
        int actual = DatasetUtils.findIndexGreaterThanOrEqualTo((Dataset)dataset, (double)13.0);
        Assert.assertEquals((long)expected, (long)actual);
    }

    @Test
    public void testFindIndexLessThan() {
        Dataset dataset = DatasetFactory.createFromObject((Object)new double[]{5.2, 2.0, 4.8, 13.0, 0.8, 96.0, 13.0});
        int expected = 4;
        int actual = DatasetUtils.findIndexLessThan((Dataset)dataset, (double)1.0);
        Assert.assertEquals((long)expected, (long)actual);
    }

    @Test
    public void testFindIndexLesshanOrEqualTo() {
        Dataset dataset = DatasetFactory.createFromObject((Object)new double[]{5.2, 2.0, 4.8, 13.0, 0.8, 96.0, 13.0});
        int expected = 4;
        int actual = DatasetUtils.findIndexLessThanOrEqualTo((Dataset)dataset, (double)0.8);
        Assert.assertEquals((long)expected, (long)actual);
    }

    @Test
    public void testCrossings() {
        Dataset dataset = DatasetFactory.createFromObject((Object)new double[]{0.8, 1.2, 1.6, 0.4, 0.9, 1.1});
        ArrayList<Double> expected = new ArrayList<Double>();
        expected.add(0.5);
        expected.add(2.5);
        expected.add(4.5);
        List actual = DatasetUtils.crossings((Dataset)dataset, (double)1.0);
        Assert.assertEquals(expected, (Object)actual);
    }

    @Test
    public void testCrossings2() {
        Dataset yAxis = DatasetFactory.createFromObject((Object)new double[]{0.8, 1.2, 1.6, 0.4, 0.9, 1.1});
        Dataset xAxis = DatasetFactory.createFromObject((Object)new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0});
        ArrayList<Double> expected = new ArrayList<Double>();
        expected.add(1.5);
        expected.add(3.5);
        expected.add(5.5);
        List actual = DatasetUtils.crossings((Dataset)xAxis, (Dataset)yAxis, (double)1.0);
        Assert.assertEquals(expected, (Object)actual);
    }

    @Test
    public void testCrossings3() {
        Dataset yAxis = DatasetFactory.createFromObject((Object)new double[]{0.5, 1.1, 0.9, 1.5});
        Dataset xAxis = DatasetFactory.createFromObject((Object)new double[]{1.0, 2.0, 3.0, 4.0});
        ArrayList<Double> expected = new ArrayList<Double>();
        expected.add(2.5);
        List actual = DatasetUtils.crossings((Dataset)xAxis, (Dataset)yAxis, (double)1.0, (double)0.5);
        Assert.assertEquals(expected, (Object)actual);
    }

    @Test
    public void testNorm() {
        Dataset dataset = DatasetFactory.createFromObject((Object)new int[]{-10, -5, -1, 3, 5, 9, 10});
        Dataset expected = DatasetFactory.createFromObject((Object)new double[]{0.0, 0.25, 0.45, 0.65, 0.75, 0.95, 1.0});
        Dataset actual = DatasetUtils.norm((Dataset)dataset);
        TestUtils.assertDatasetEquals((Dataset)expected, (Dataset)actual);
    }

    @Test
    public void testIndexSort() {
        int[] nArray = new int[6];
        nArray[1] = 3;
        nArray[2] = 1;
        nArray[3] = 2;
        nArray[4] = 2;
        nArray[5] = -1;
        Dataset a = DatasetFactory.createFromObject((Object)nArray).reshape(new int[]{2, 3});
        int[] nArray2 = new int[6];
        nArray2[0] = 5;
        nArray2[2] = 2;
        nArray2[3] = 3;
        nArray2[4] = 4;
        nArray2[5] = 1;
        Dataset e = DatasetFactory.createFromObject((Object)nArray2);
        TestUtils.assertDatasetEquals((Dataset)e, (Dataset)DatasetUtils.indexSort((Dataset)a, null));
        int[] nArray3 = new int[6];
        nArray3[1] = 1;
        nArray3[2] = 1;
        nArray3[3] = 1;
        e = DatasetFactory.createFromObject((Object)nArray3).reshape(new int[]{2, 3});
        TestUtils.assertDatasetEquals((Dataset)e, (Dataset)DatasetUtils.indexSort((Dataset)a, (Integer)0));
        int[] nArray4 = new int[6];
        nArray4[1] = 2;
        nArray4[2] = 1;
        nArray4[3] = 2;
        nArray4[5] = 1;
        e = DatasetFactory.createFromObject((Object)nArray4).reshape(new int[]{2, 3});
        TestUtils.assertDatasetEquals((Dataset)e, (Dataset)DatasetUtils.indexSort((Dataset)a, (Integer)1));
    }

    @Test
    public void testSetShape() {
        int[] oShape = new int[]{5, 4, 3, 6, 7};
        Dataset a = DatasetFactory.createRange((double)120.0).reshape(new int[]{5, 4, 6});
        DatasetUtils.setShapeToOriginalRank((ILazyDataset)a, (int[])oShape, (int[])new int[]{2, 4});
        Assert.assertArrayEquals((int[])new int[]{5, 4, 1, 6, 1}, (int[])a.getShapeRef());
    }

    @Test
    public void testCast() {
        DoubleDataset a = DatasetFactory.createRange((double)12.0);
        for (Class c : DTypeUtils.interface2DTypes.keySet()) {
            Dataset b = DatasetUtils.cast((Class)c, (IDataset)a);
            if (!(b instanceof AbstractDataset)) continue;
            ((AbstractDataset)b).setData();
        }
        ComplexDoubleDataset z = (ComplexDoubleDataset)DatasetFactory.createRange(ComplexDoubleDataset.class, (double)12.0);
        for (Class c : DTypeUtils.interface2DTypes.keySet()) {
            Dataset b = DatasetUtils.cast((Class)c, (IDataset)z);
            if (!(b instanceof AbstractDataset)) continue;
            ((AbstractDataset)b).setData();
        }
    }
}

