/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.january.DatasetException;
import org.eclipse.january.MetadataException;
import org.eclipse.january.dataset.BroadcastUtils;
import org.eclipse.january.dataset.CompoundDoubleDataset;
import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.DatasetFactory;
import org.eclipse.january.dataset.DatasetUtils;
import org.eclipse.january.dataset.DoubleDataset;
import org.eclipse.january.dataset.IDataset;
import org.eclipse.january.dataset.ILazyDataset;
import org.eclipse.january.dataset.ShapeUtils;
import org.eclipse.january.dataset.Slice;
import org.eclipse.january.dataset.SliceND;
import org.eclipse.january.metadata.Dirtiable;
import org.eclipse.january.metadata.ErrorMetadata;
import org.eclipse.january.metadata.IMetadata;
import org.eclipse.january.metadata.MetadataFactory;
import org.eclipse.january.metadata.MetadataType;
import org.eclipse.january.metadata.Reshapeable;
import org.eclipse.january.metadata.Sliceable;
import org.eclipse.january.metadata.Transposable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LazyDatasetBase
implements ILazyDataset,
Serializable {
    private static final long serialVersionUID = 767926846438976050L;
    private static final Logger logger = LoggerFactory.getLogger(LazyDatasetBase.class);
    private transient boolean dirty = true;
    protected String name = "";
    protected int[] shape;
    protected ConcurrentMap<Class<? extends MetadataType>, List<MetadataType>> metadata = null;

    public abstract int getDType();

    @Override
    public LazyDatasetBase clone() {
        return null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        LazyDatasetBase other = (LazyDatasetBase)obj;
        if (this.getDType() != other.getDType()) {
            return false;
        }
        if (this.getElementsPerItem() != other.getElementsPerItem()) {
            return false;
        }
        return Arrays.equals(this.shape, other.shape);
    }

    public int hashCode() {
        int hash = this.getDType() * 17 + this.getElementsPerItem();
        int rank = this.shape.length;
        int i = 0;
        while (i < rank) {
            hash = hash * 17 + this.shape[i];
            ++i;
        }
        return hash;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public int[] getShape() {
        return (int[])this.shape.clone();
    }

    @Override
    public int getRank() {
        return this.shape.length;
    }

    public void setDirty() {
        this.dirty = true;
    }

    protected void checkSliceND(SliceND slice) {
        slice.checkShapes(this.shape, null);
    }

    public static Class<? extends MetadataType> findMetadataTypeSubInterfaces(Class<? extends MetadataType> clazz) {
        Class<MetadataType> c;
        Class<? extends MetadataType> s;
        if (clazz.equals(MetadataType.class)) {
            throw new IllegalArgumentException("Cannot accept MetadataType");
        }
        if (clazz.isInterface()) {
            return clazz;
        }
        if (clazz.isAnonymousClass() && !(s = clazz.getSuperclass()).equals(Object.class)) {
            clazz = s;
        }
        Class<?>[] classArray = clazz.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            c = classArray[n2];
            if (c.equals(MetadataType.class)) {
                if (clazz.isAnonymousClass()) {
                    throw new IllegalArgumentException("Cannot accept anonymous subclasses of MetadataType");
                }
                return clazz;
            }
            if (MetadataType.class.isAssignableFrom(c)) {
                return c;
            }
            ++n2;
        }
        c = clazz.getSuperclass();
        if (c != null) {
            return LazyDatasetBase.findMetadataTypeSubInterfaces(c);
        }
        logger.error("Somehow the search for metadata type interface ended in a bad place");
        assert (false);
        return null;
    }

    @Override
    public void setMetadata(MetadataType metadata) {
        this.addMetadata(metadata, true);
    }

    @Override
    public void addMetadata(MetadataType metadata) {
        this.addMetadata(metadata, false);
    }

    private synchronized void addMetadata(MetadataType metadata, boolean clear) {
        Class<? extends MetadataType> clazz;
        if (metadata == null) {
            return;
        }
        if (this.metadata == null) {
            this.metadata = new ConcurrentHashMap<Class<? extends MetadataType>, List<MetadataType>>();
        }
        if (!this.metadata.containsKey(clazz = LazyDatasetBase.findMetadataTypeSubInterfaces(metadata.getClass()))) {
            this.metadata.put(clazz, new ArrayList());
        } else if (clear) {
            ((List)this.metadata.get(clazz)).clear();
        }
        ((List)this.metadata.get(clazz)).add(metadata);
        if (!IMetadata.class.equals(clazz) && IMetadata.class.isAssignableFrom(clazz)) {
            clazz = IMetadata.class;
            if (!this.metadata.containsKey(clazz)) {
                this.metadata.put(clazz, new ArrayList());
            } else if (clear) {
                ((List)this.metadata.get(clazz)).clear();
            }
            ((List)this.metadata.get(clazz)).add(metadata);
        }
    }

    @Override
    @Deprecated
    public synchronized IMetadata getMetadata() {
        return this.getFirstMetadata(IMetadata.class);
    }

    @Override
    public synchronized <T extends MetadataType> List<T> getMetadata(Class<T> clazz) throws MetadataException {
        if (this.metadata == null) {
            this.dirty = false;
            return null;
        }
        if (this.dirty) {
            this.dirtyMetadata();
            this.dirty = false;
        }
        if (clazz == null) {
            ArrayList all = new ArrayList();
            for (Class c : this.metadata.keySet()) {
                all.addAll((Collection)this.metadata.get(c));
            }
            return all;
        }
        return (List)this.metadata.get(LazyDatasetBase.findMetadataTypeSubInterfaces(clazz));
    }

    @Override
    public synchronized <T extends MetadataType> T getFirstMetadata(Class<T> clazz) {
        List<T> ml;
        block4: {
            ml = this.getMetadata(clazz);
            if (ml != null) break block4;
            return null;
        }
        try {
            for (MetadataType t : ml) {
                if (!clazz.isInstance(t)) continue;
                return (T)t;
            }
        }
        catch (Exception e) {
            logger.error("Get metadata failed!", (Throwable)e);
        }
        return null;
    }

    @Override
    public synchronized void clearMetadata(Class<? extends MetadataType> clazz) {
        if (this.metadata == null) {
            return;
        }
        if (clazz == null) {
            this.metadata.clear();
            return;
        }
        List list = (List)this.metadata.get(LazyDatasetBase.findMetadataTypeSubInterfaces(clazz));
        if (list != null) {
            list.clear();
        }
    }

    protected synchronized ConcurrentMap<Class<? extends MetadataType>, List<MetadataType>> copyMetadata() {
        return LazyDatasetBase.copyMetadata(this.metadata);
    }

    protected static ConcurrentMap<Class<? extends MetadataType>, List<MetadataType>> copyMetadata(Map<Class<? extends MetadataType>, List<MetadataType>> metadata) {
        if (metadata == null) {
            return null;
        }
        ConcurrentHashMap<Class<? extends MetadataType>, List<MetadataType>> map = new ConcurrentHashMap<Class<? extends MetadataType>, List<MetadataType>>();
        LazyDatasetBase.copyMetadata(metadata, map);
        return map;
    }

    private static void copyMetadata(Map<Class<? extends MetadataType>, List<MetadataType>> inMetadata, Map<Class<? extends MetadataType>, List<MetadataType>> outMetadata) {
        for (Class<? extends MetadataType> c : inMetadata.keySet()) {
            List<MetadataType> l = inMetadata.get(c);
            ArrayList<MetadataType> nl = new ArrayList<MetadataType>(l.size());
            outMetadata.put(c, nl);
            for (MetadataType m : l) {
                if (m == null || LazyDatasetBase.isMetadataDirty(m)) continue;
                nl.add(m.clone());
            }
        }
    }

    protected void restoreMetadata(Map<Class<? extends MetadataType>, List<MetadataType>> oldMetadata) {
        LazyDatasetBase.copyMetadata(oldMetadata, this.metadata);
    }

    protected static ConcurrentMap<Class<? extends MetadataType>, List<MetadataType>> getMetadataMap(ILazyDataset a, boolean clone) {
        List all = null;
        try {
            all = a.getMetadata(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (all == null) {
            return null;
        }
        ConcurrentHashMap<Class<? extends MetadataType>, List<MetadataType>> map = new ConcurrentHashMap<Class<? extends MetadataType>, List<MetadataType>>();
        for (MetadataType m : all) {
            if (m == null || LazyDatasetBase.isMetadataDirty(m)) continue;
            Class<? extends MetadataType> c = LazyDatasetBase.findMetadataTypeSubInterfaces(m.getClass());
            ArrayList<MetadataType> l = (ArrayList<MetadataType>)map.get(c);
            if (l == null) {
                l = new ArrayList<MetadataType>();
                map.put(c, l);
            }
            if (clone) {
                m = m.clone();
            }
            l.add(m);
        }
        return map;
    }

    private static boolean isMetadataDirty(MetadataType m) {
        Class<?> c = m.getClass();
        Field[] fieldArray = c.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> t;
            Field f = fieldArray[n2];
            if (f.isAnnotationPresent(Dirtiable.class) && ((t = f.getType()).equals(Boolean.TYPE) || t.equals(Boolean.class))) {
                try {
                    f.setAccessible(true);
                    Object o = f.get(m);
                    if (o.equals(true)) {
                        return true;
                    }
                }
                catch (Exception e) {
                    logger.debug("Could not retrieve value of dirty variable: {}", (Object)c.getCanonicalName(), (Object)e);
                }
            }
            ++n2;
        }
        return false;
    }

    protected void sliceMetadata(boolean asView, SliceND slice) {
        this.processAnnotatedMetadata(new MdsSlice(asView, slice));
    }

    protected void reshapeMetadata(int[] oldShape, int[] newShape) {
        this.processAnnotatedMetadata(new MdsReshape(oldShape, newShape));
    }

    protected void transposeMetadata(int[] axesMap) {
        this.processAnnotatedMetadata(new MdsTranspose(axesMap));
    }

    protected void dirtyMetadata() {
        this.processAnnotatedMetadata(new MdsDirty());
    }

    private void processAnnotatedMetadata(MetadatasetAnnotationOperation op) {
        if (this.metadata == null) {
            return;
        }
        for (List l : this.metadata.values()) {
            block1: for (MetadataType m : l) {
                if (m == null) continue;
                Class<?> mc = m.getClass();
                while (true) {
                    LazyDatasetBase.processClass(op, m, mc);
                    Class<?> sclazz = mc.getSuperclass();
                    if (!MetadataType.class.isAssignableFrom(sclazz)) continue block1;
                    mc = sclazz;
                }
            }
        }
    }

    private static void processClass(MetadatasetAnnotationOperation op, MetadataType m, Class<? extends MetadataType> mc) {
        Field[] fieldArray = mc.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            block41: {
                Field f = fieldArray[n2];
                if (f.isAnnotationPresent(op.getAnnClass())) {
                    try {
                        f.setAccessible(true);
                        Object o = f.get(m);
                        if (o == null) break block41;
                        Object no = op.processField(f, o);
                        if (no != o) {
                            f.set(m, no);
                            break block41;
                        }
                        Object r = null;
                        if (o instanceof ILazyDataset) {
                            try {
                                f.set(m, op.run((ILazyDataset)o));
                                break block41;
                            }
                            catch (Exception e) {
                                logger.error("Problem processing " + o, (Throwable)e);
                                throw e;
                            }
                        }
                        if (o.getClass().isArray()) {
                            int l = Array.getLength(o);
                            int i = 0;
                            while (r == null && i < l) {
                                r = Array.get(o, i);
                                ++i;
                            }
                            int n3 = op.getNewRank();
                            if (r == null) {
                                if (n3 < 0 || n3 != l) {
                                    f.set(m, Array.newInstance(o.getClass().getComponentType(), n3 < 0 ? l : n3));
                                }
                            } else {
                                if (n3 < 0) {
                                    n3 = l;
                                }
                                Object narray = Array.newInstance(r.getClass(), n3);
                                int i2 = 0;
                                int si = 0;
                                int di = 0;
                                while (di < n3 && si < l) {
                                    int c = op.change(i2);
                                    if (c == 0) {
                                        Array.set(narray, di++, LazyDatasetBase.processObject(op, Array.get(o, si++)));
                                    } else if (c > 0) {
                                        di += c;
                                    } else if (c < 0) {
                                        si -= c;
                                    }
                                    ++i2;
                                }
                                if (n3 == l) {
                                    i2 = 0;
                                    while (i2 < l) {
                                        Array.set(o, i2, Array.get(narray, i2));
                                        ++i2;
                                    }
                                } else {
                                    f.set(m, narray);
                                }
                            }
                        } else if (o instanceof List) {
                            List list = (List)o;
                            int l = list.size();
                            int i = 0;
                            while (r == null && i < l) {
                                r = list.get(i);
                                ++i;
                            }
                            int n4 = op.getNewRank();
                            if (r == null) {
                                if (n4 < 0 || n4 != l) {
                                    list.clear();
                                    int i3 = 0;
                                    int imax = n4 < 0 ? l : n4;
                                    while (i3 < imax) {
                                        list.add(null);
                                        ++i3;
                                    }
                                }
                            } else {
                                if (n4 < 0) {
                                    n4 = l;
                                }
                                Object narray = Array.newInstance(r.getClass(), n4);
                                int i4 = 0;
                                int si = 0;
                                int di = 0;
                                while (i4 < l && si < l) {
                                    int c = op.change(i4);
                                    if (c == 0) {
                                        Array.set(narray, di++, LazyDatasetBase.processObject(op, list.get(si++)));
                                    } else if (c > 0) {
                                        di += c;
                                    } else if (c < 0) {
                                        si -= c;
                                    }
                                    ++i4;
                                }
                                list.clear();
                                i4 = 0;
                                while (i4 < n4) {
                                    list.add(Array.get(narray, i4));
                                    ++i4;
                                }
                            }
                        } else if (o instanceof Map) {
                            Map map = (Map)o;
                            for (Object k : map.keySet()) {
                                map.put(k, LazyDatasetBase.processObject(op, map.get(k)));
                            }
                        }
                    }
                    catch (Exception e) {
                        logger.error("Problem occurred when processing metadata of class {}: {}", (Object)mc.getCanonicalName(), (Object)e);
                        throw new RuntimeException(e);
                    }
                }
            }
            ++n2;
        }
    }

    private static Object processObject(MetadatasetAnnotationOperation op, Object o) throws Exception {
        block8: {
            block9: {
                block7: {
                    if (o == null) {
                        return o;
                    }
                    if (o instanceof ILazyDataset) {
                        try {
                            return op.run((ILazyDataset)o);
                        }
                        catch (Exception e) {
                            logger.error("Problem processing " + o, (Throwable)e);
                            throw e;
                        }
                    }
                    if (!o.getClass().isArray()) break block7;
                    int l = Array.getLength(o);
                    int i = 0;
                    while (i < l) {
                        Array.set(o, i, LazyDatasetBase.processObject(op, Array.get(o, i)));
                        ++i;
                    }
                    break block8;
                }
                if (!(o instanceof List)) break block9;
                List list = (List)o;
                int i = 0;
                int imax = list.size();
                while (i < imax) {
                    list.set(i, LazyDatasetBase.processObject(op, list.get(i)));
                    ++i;
                }
                break block8;
            }
            if (!(o instanceof Map)) break block8;
            Map map = (Map)o;
            for (Object k : map.keySet()) {
                map.put(k, LazyDatasetBase.processObject(op, map.get(k)));
            }
        }
        return o;
    }

    protected ILazyDataset createFromSerializable(Serializable blob, boolean keepLazy) {
        ILazyDataset d = null;
        if (blob instanceof ILazyDataset) {
            d = (ILazyDataset)blob;
            if (d instanceof IDataset) {
                Dataset ed = DatasetUtils.convertToDataset((IDataset)d);
                int is = ed.getElementsPerItem();
                if (is != 1 && is != this.getElementsPerItem()) {
                    throw new IllegalArgumentException("Dataset has incompatible number of elements with this dataset");
                }
                d = ed.cast(is == 1 ? DoubleDataset.class : CompoundDoubleDataset.class);
            } else if (!keepLazy) {
                int is = this.getElementsPerItem();
                try {
                    d = DatasetUtils.cast(is == 1 ? DoubleDataset.class : CompoundDoubleDataset.class, d.getSlice(new Slice[0]));
                }
                catch (DatasetException e) {
                    logger.error("Could not get data from lazy dataset", (Throwable)e);
                    return null;
                }
            }
        } else {
            int is = this.getElementsPerItem();
            if (is == 1) {
                d = DatasetFactory.createFromObject(DoubleDataset.class, (Object)blob);
            } else {
                try {
                    d = DatasetFactory.createFromObject(is, CompoundDoubleDataset.class, (Object)blob, new int[0]);
                }
                catch (IllegalArgumentException e) {
                    d = DatasetFactory.createFromObject(DoubleDataset.class, (Object)blob);
                }
            }
            if (d.getSize() == this.getSize() && !Arrays.equals(d.getShape(), this.shape)) {
                d.setShape((int[])this.shape.clone());
            }
        }
        List<int[]> s = BroadcastUtils.broadcastShapesToMax(this.shape, new int[][]{d.getShape()});
        d.setShape(s.get(0));
        return d;
    }

    @Override
    public void setErrors(Serializable errors) {
        if (this.shape == null) {
            throw new IllegalArgumentException("Cannot set errors for null dataset");
        }
        if (errors == null) {
            this.clearMetadata(ErrorMetadata.class);
            return;
        }
        if (errors == this) {
            logger.warn("Ignoring setting error to itself as this will lead to infinite recursion");
            return;
        }
        ILazyDataset errorData = this.createFromSerializable(errors, true);
        ErrorMetadata emd = this.getErrorMetadata();
        if (emd == null) {
            try {
                emd = MetadataFactory.createMetadata(ErrorMetadata.class, new Object[0]);
                this.setMetadata(emd);
            }
            catch (MetadataException me) {
                logger.error("Could not create metadata", (Throwable)me);
            }
        }
        emd.setError(errorData);
    }

    protected ErrorMetadata getErrorMetadata() {
        try {
            List<ErrorMetadata> el = this.getMetadata(ErrorMetadata.class);
            if (el != null && !el.isEmpty()) {
                return el.get(0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    public ILazyDataset getErrors() {
        ErrorMetadata emd = this.getErrorMetadata();
        return emd == null ? null : emd.getError();
    }

    @Override
    public boolean hasErrors() {
        return this.getErrors() != null;
    }

    public static int[] checkPermutatedAxes(int[] shape, int ... axes) {
        int i;
        int rank;
        int n = rank = shape == null ? 0 : shape.length;
        if (axes == null || axes.length == 0) {
            axes = new int[rank];
            i = 0;
            while (i < rank) {
                axes[i] = rank - 1 - i;
                ++i;
            }
        } else {
            axes = (int[])axes.clone();
        }
        if (axes.length != rank) {
            logger.error("axis permutation has length {} that does not match dataset's rank {}", (Object)axes.length, (Object)rank);
            throw new IllegalArgumentException("axis permutation does not match shape of dataset");
        }
        i = 0;
        while (i < rank) {
            axes[i] = ShapeUtils.checkAxis(rank, axes[i]);
            ++i;
        }
        int[] perm = (int[])axes.clone();
        Arrays.sort(perm);
        int i2 = 0;
        while (i2 < rank) {
            if (perm[i2] != i2) {
                logger.error("axis permutation is not valid: it does not contain complete set of axes");
                throw new IllegalArgumentException("axis permutation does not contain complete set of axes");
            }
            ++i2;
        }
        if (Arrays.equals(axes, perm)) {
            return null;
        }
        return axes;
    }

    class MdsDirty
    implements MetadatasetAnnotationOperation {
        MdsDirty() {
        }

        @Override
        public Object processField(Field f, Object o) {
            Class<?> t = f.getType();
            if ((t.equals(Boolean.TYPE) || t.equals(Boolean.class)) && o.equals(false)) {
                o = true;
            }
            return o;
        }

        @Override
        public Class<? extends Annotation> getAnnClass() {
            return Dirtiable.class;
        }

        @Override
        public int change(int axis) {
            return 0;
        }

        @Override
        public int getNewRank() {
            return -1;
        }

        @Override
        public ILazyDataset run(ILazyDataset lz) {
            return lz;
        }
    }

    class MdsReshape
    implements MetadatasetAnnotationOperation {
        private boolean matchRank;
        private int[] oldShape;
        private int[] newShape;
        boolean onesOnly;
        int[] differences;

        public MdsReshape(int[] oldShape, int[] newShape) {
            this.oldShape = oldShape;
            this.newShape = newShape;
            this.differences = null;
        }

        @Override
        public Object processField(Field field, Object o) {
            Reshapeable a = field.getAnnotation(Reshapeable.class);
            if (a != null) {
                this.matchRank = a.matchRank();
            }
            return o;
        }

        @Override
        public Class<? extends Annotation> getAnnClass() {
            return Reshapeable.class;
        }

        @Override
        public int change(int axis) {
            if (this.matchRank) {
                if (this.differences == null) {
                    this.init();
                }
                if (this.onesOnly) {
                    return this.differences == null ? 0 : this.differences[axis];
                }
                throw new UnsupportedOperationException("TODO support other shape operations");
            }
            return 0;
        }

        @Override
        public int getNewRank() {
            return this.matchRank ? this.newShape.length : -1;
        }

        /*
         * Unable to fully structure code
         */
        private void init() {
            block12: {
                block11: {
                    or = this.oldShape.length - 1;
                    nr = this.newShape.length - 1;
                    if (or < 0 || nr < 0) {
                        this.onesOnly = true;
                        this.differences = new int[1];
                        this.differences[0] = or < 0 ? nr + 1 : or + 1;
                        return;
                    }
                    this.onesOnly = ShapeUtils.differsByOnes(this.oldShape, this.newShape);
                    ob = 0;
                    nb = 0;
                    if (!this.onesOnly) break block11;
                    this.differences = ShapeUtils.calcShapePadding(this.oldShape, this.newShape);
                    break block12;
                }
                this.differences = new int[or + 2];
                if (!this.matchRank) ** GOTO lbl47
                LazyDatasetBase.access$2().error("Combining dimensions is currently not supported");
                throw new IllegalArgumentException("Combining dimensions is currently not supported");
lbl-1000:
                // 1 sources

                {
                    ol = this.oldShape[ob];
                    while (ol == 1 && ol <= or) {
                        ol = this.oldShape[++ob];
                    }
                    oe = ob + 1;
                    nl = this.newShape[nb];
                    while (nl == 1 && nl <= nr) {
                        nl = this.newShape[++nb];
                    }
                    ne = nb + 1;
                    if (ol < nl) {
                        this.differences[ob] = 1;
                        while (oe != or + 1) {
                            this.differences[oe] = 1;
                            if ((ol *= this.oldShape[oe++]) < nl) continue;
                        }
                        this.differences[oe - 1] = oe - ob;
                        if (nl != ol) {
                            LazyDatasetBase.access$2().error("Single dimension is incompatible with subshape");
                            throw new IllegalArgumentException("Single dimension is incompatible with subshape");
                        }
                    } else if (ol > nl) {
                        while (ne != nr + 1 && (nl *= this.newShape[ne++]) < ol) {
                        }
                        if (nl != ol) {
                            LazyDatasetBase.access$2().error("Subshape is incompatible with single dimension");
                            throw new IllegalArgumentException("Subshape is incompatible with single dimension");
                        }
                    }
                    ob = oe;
                    nb = ne;
lbl47:
                    // 2 sources

                    ** while (ob <= or && nb <= nr)
                }
            }
        }

        @Override
        public ILazyDataset run(ILazyDataset lz) {
            ILazyDataset nlz;
            int[] nshape;
            int[] lshape;
            if (this.differences == null) {
                this.init();
            }
            if (Arrays.equals(this.newShape, lshape = lz.getShape())) {
                return lz;
            }
            int or = lshape.length;
            int nr = this.newShape.length;
            if (this.onesOnly) {
                nshape = ShapeUtils.padShape(this.differences, nr, lshape);
            } else {
                nshape = new int[nr];
                boolean[] broadcast = new boolean[or];
                int ob = 0;
                while (ob < or) {
                    broadcast[ob] = this.oldShape[ob] != 1 && lshape[ob] == 1;
                    ++ob;
                }
                int osize = lz.getSize();
                int ob2 = 0;
                int nsize = 1;
                int i = 0;
                while (i < nr) {
                    if (ob2 < or && broadcast[ob2]) {
                        if (this.differences[ob2] != 0) {
                            logger.error("Metadata contains a broadcast axis which cannot be reshaped");
                            throw new IllegalArgumentException("Metadata contains a broadcast axis which cannot be reshaped");
                        }
                        nshape[i] = 1;
                    } else {
                        nshape[i] = nsize < osize ? this.newShape[i] : 1;
                    }
                    nsize *= nshape[i];
                    ++ob2;
                    ++i;
                }
            }
            if (lz instanceof Dataset) {
                nlz = ((Dataset)lz).reshape(nshape);
            } else {
                nlz = lz.getSliceView(new Slice[0]);
                nlz.setShape(nshape);
            }
            return nlz;
        }
    }

    class MdsSlice
    implements MetadatasetAnnotationOperation {
        private boolean asView;
        private SliceND slice;
        private int[] oShape;
        private long oSize;

        public MdsSlice(boolean asView, SliceND slice) {
            this.asView = asView;
            this.slice = slice;
            this.oShape = slice.getSourceShape();
            this.oSize = ShapeUtils.calcLongSize(this.oShape);
        }

        @Override
        public Object processField(Field field, Object o) {
            return o;
        }

        @Override
        public Class<? extends Annotation> getAnnClass() {
            return Sliceable.class;
        }

        @Override
        public int change(int axis) {
            return 0;
        }

        @Override
        public int getNewRank() {
            return -1;
        }

        @Override
        public ILazyDataset run(ILazyDataset lz) {
            int s;
            int i;
            SliceND nslice;
            int rank = lz.getRank();
            if (this.slice.getStart().length != rank) {
                throw new IllegalArgumentException("Slice rank does not match dataset!");
            }
            int[] shape = lz.getShape();
            if (!ShapeUtils.areShapesBroadcastCompatible(this.oShape, shape)) {
                nslice = new SliceND(shape);
                i = 0;
                while (i < rank) {
                    s = shape[i];
                    int os = this.oShape[i];
                    if (s >= os) {
                        nslice.setSlice(i, 0, os, 1);
                    } else if (s == 1) {
                        nslice.setSlice(i, 0, 1, 1);
                    } else {
                        throw new IllegalArgumentException("Sliceable dataset has non-unit dimension less than host!");
                    }
                    ++i;
                }
                lz = lz.getSliceView(nslice);
                shape = nslice.getShape();
            }
            if ((long)lz.getSize() == this.oSize && Arrays.equals(shape, this.oShape)) {
                nslice = this.slice;
            } else {
                nslice = this.slice.clone();
                i = 0;
                while (i < rank) {
                    s = shape[i];
                    if (s < this.oShape[i]) {
                        if (s == 1) {
                            nslice.setSlice(i, 0, 1, 1);
                        } else {
                            throw new IllegalArgumentException("Sliceable dataset has non-unit dimension less than host!");
                        }
                    }
                    ++i;
                }
                nslice.updateSourceShape(shape);
            }
            if (this.asView || lz instanceof IDataset) {
                return lz.getSliceView(nslice);
            }
            try {
                return lz.getSlice(nslice);
            }
            catch (DatasetException e) {
                logger.error("Could not slice dataset in metadata", (Throwable)e);
                return null;
            }
        }
    }

    class MdsTranspose
    implements MetadatasetAnnotationOperation {
        int[] map;

        public MdsTranspose(int[] axesMap) {
            this.map = axesMap;
        }

        @Override
        public Object processField(Field f, Object o) {
            block6: {
                List list;
                int l;
                block5: {
                    if (!o.getClass().isArray()) break block5;
                    int l2 = Array.getLength(o);
                    if (l2 != this.map.length) break block6;
                    Object narray = Array.newInstance(o.getClass().getComponentType(), l2);
                    int i = 0;
                    while (i < l2) {
                        Array.set(narray, i, Array.get(o, this.map[i]));
                        ++i;
                    }
                    i = 0;
                    while (i < l2) {
                        Array.set(o, i, Array.get(narray, i));
                        ++i;
                    }
                    break block6;
                }
                if (o instanceof List && (l = (list = (List)o).size()) == this.map.length) {
                    Object narray = Array.newInstance(o.getClass().getComponentType(), l);
                    int i = 0;
                    while (i < l) {
                        Array.set(narray, i, list.get(this.map[i]));
                        ++i;
                    }
                    list.clear();
                    i = 0;
                    while (i < l) {
                        list.add(Array.get(narray, i));
                        ++i;
                    }
                }
            }
            return o;
        }

        @Override
        public Class<? extends Annotation> getAnnClass() {
            return Transposable.class;
        }

        @Override
        public int change(int axis) {
            return 0;
        }

        @Override
        public int getNewRank() {
            return -1;
        }

        @Override
        public ILazyDataset run(ILazyDataset lz) {
            return lz.getTransposedView(this.map);
        }
    }

    static interface MetadatasetAnnotationOperation {
        public Object processField(Field var1, Object var2);

        public Class<? extends Annotation> getAnnClass();

        public int change(int var1);

        public int getNewRank();

        public ILazyDataset run(ILazyDataset var1);
    }
}

