/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.jaxrs21.ee.sse.sseeventsink;

import ee.jakarta.tck.ws.rs.common.impl.SinglevaluedMap;
import ee.jakarta.tck.ws.rs.common.impl.StringDataSource;
import ee.jakarta.tck.ws.rs.common.impl.StringSource;
import ee.jakarta.tck.ws.rs.common.impl.StringStreamingOutput;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.sse.Sse;
import jakarta.ws.rs.sse.SseEventSink;
import jakarta.xml.bind.JAXBElement;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import javax.xml.namespace.QName;

@Path(value="mbw")
public class MBWCheckResource {
    static final String MESSAGE = "some_ServiceUnavailableEndpoint_message";

    @GET
    @Path(value="boolean")
    @Produces(value={"text/event-stream"})
    public void sendBoolean(@Context SseEventSink sink, @Context Sse sse) {
        try (SseEventSink s = sink;){
            s.send(sse.newEventBuilder().data((Object)true).mediaType(MediaType.TEXT_PLAIN_TYPE).build());
        }
    }

    @GET
    @Path(value="bytearray")
    @Produces(value={"text/event-stream"})
    public void sendByteArray(@Context SseEventSink sink, @Context Sse sse) {
        try (SseEventSink s = sink;){
            s.send(sse.newEventBuilder().data((Object)MESSAGE.getBytes()).mediaType(MediaType.WILDCARD_TYPE).build());
        }
    }

    @GET
    @Path(value="char")
    @Produces(value={"text/event-stream"})
    public void sendChar(@Context SseEventSink sink, @Context Sse sse) {
        try (SseEventSink s = sink;){
            s.send(sse.newEventBuilder().data((Object)Character.valueOf(MESSAGE.charAt(0))).mediaType(MediaType.TEXT_PLAIN_TYPE).build());
        }
    }

    @GET
    @Path(value="datasource")
    @Produces(value={"text/event-stream"})
    public void sendDatasource(@Context SseEventSink sink, @Context Sse sse) {
        try (SseEventSink s = sink;){
            s.send(sse.newEventBuilder().data((Object)new StringDataSource(MESSAGE, MediaType.TEXT_PLAIN_TYPE)).mediaType(MediaType.WILDCARD_TYPE).build());
        }
    }

    @GET
    @Path(value="double")
    @Produces(value={"text/event-stream"})
    public void sendDouble(@Context SseEventSink sink, @Context Sse sse) {
        try (SseEventSink s = sink;){
            s.send(sse.newEventBuilder().data((Object)Double.MAX_VALUE).mediaType(MediaType.TEXT_PLAIN_TYPE).build());
        }
    }

    @GET
    @Path(value="file")
    @Produces(value={"text/event-stream"})
    public void sendFile(@Context SseEventSink sink, @Context Sse sse) {
        try (SseEventSink s = sink;){
            try {
                File f = File.createTempFile("tck", "tempfile");
                Files.write(f.toPath(), MESSAGE.getBytes(), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
                f.deleteOnExit();
                s.send(sse.newEventBuilder().data((Object)f).mediaType(MediaType.WILDCARD_TYPE).build());
            }
            catch (IOException e) {
                s.send(sse.newEvent(e.getMessage()));
                throw new RuntimeException(e);
            }
        }
    }

    @GET
    @Path(value="inputstream")
    @Produces(value={"text/event-stream"})
    public void sendInputStream(@Context SseEventSink sink, @Context Sse sse) {
        try (SseEventSink s = sink;){
            s.send(sse.newEventBuilder().data((Object)new ByteArrayInputStream(MESSAGE.getBytes())).mediaType(MediaType.WILDCARD_TYPE).build());
        }
    }

    @GET
    @Path(value="int")
    @Produces(value={"text/event-stream"})
    public void sendInt(@Context SseEventSink sink, @Context Sse sse) {
        try (SseEventSink s = sink;){
            s.send(sse.newEventBuilder().data((Object)Integer.MIN_VALUE).mediaType(MediaType.TEXT_PLAIN_TYPE).build());
        }
    }

    @GET
    @Path(value="jaxbelement")
    @Produces(value={"text/event-stream"})
    public void sendJAXBElement(@Context SseEventSink sink, @Context Sse sse) {
        try (SseEventSink s = sink;){
            JAXBElement element = new JAXBElement(new QName("name"), String.class, (Object)MESSAGE);
            s.send(sse.newEventBuilder().data((Object)element).mediaType(MediaType.APPLICATION_XML_TYPE).build());
        }
    }

    @GET
    @Path(value="multivaluedmap")
    @Produces(value={"text/event-stream"})
    public void sendMultivaluedMap(@Context SseEventSink sink, @Context Sse sse) {
        try (SseEventSink s = sink;){
            SinglevaluedMap<String, String> map = new SinglevaluedMap<String, String>();
            map.add("name", MESSAGE);
            s.send(sse.newEventBuilder().data(map).mediaType(MediaType.APPLICATION_FORM_URLENCODED_TYPE).build());
        }
    }

    @GET
    @Path(value="reader")
    @Produces(value={"text/event-stream"})
    public void sendReader(@Context SseEventSink sink, @Context Sse sse) {
        try (SseEventSink s = sink;){
            s.send(sse.newEventBuilder().data((Object)new InputStreamReader(new ByteArrayInputStream(MESSAGE.getBytes()))).mediaType(MediaType.WILDCARD_TYPE).build());
        }
    }

    @GET
    @Path(value="streamingoutput")
    @Produces(value={"text/event-stream"})
    public void sendStreamingOutput(@Context SseEventSink sink, @Context Sse sse) {
        try (SseEventSink s = sink;){
            StringStreamingOutput output = new StringStreamingOutput(MESSAGE);
            s.send(sse.newEventBuilder().data((Object)output).mediaType(MediaType.WILDCARD_TYPE).build());
        }
    }

    @GET
    @Path(value="string")
    @Produces(value={"text/event-stream"})
    public void sendString(@Context SseEventSink sink, @Context Sse sse) {
        try (SseEventSink s = sink;){
            s.send(sse.newEventBuilder().data((Object)MESSAGE).mediaType(MediaType.WILDCARD_TYPE).build());
        }
    }

    @GET
    @Path(value="transformsource")
    @Produces(value={"text/event-stream"})
    public void sendTransformSource(@Context SseEventSink sink, @Context Sse sse) {
        try (SseEventSink s = sink;){
            s.send(sse.newEventBuilder().data((Object)new StringSource(MESSAGE)).mediaType(MediaType.TEXT_XML_TYPE).build());
        }
    }
}

