/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest;

import com.sun.tdk.signaturetest.util.I18NResourceBundle;

public class Result {
    static final I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(Result.class);
    public static final String NO_EXIT = "SigTest.NO_EXIT";
    private int type = 3;
    private String reason;
    private static final int PASSED = 0;
    private static final int FAILED = 1;
    private static final int ERROR = 2;
    private static final int NOT_RUN = 3;
    private static final String[] texts = new String[]{i18n.getString("Result.code.passed"), i18n.getString("Result.code.failed"), i18n.getString("Result.code.error"), i18n.getString("Result.code.notrun")};
    private static final int[] exitCodes = new int[]{95, 97, 98, 99};

    public String toString() {
        Object[] invargs = new String[]{texts[this.type], this.reason == null ? "" : this.reason};
        return i18n.getString("Result.message.status", invargs);
    }

    protected boolean passed() {
        this.type = 0;
        this.reason = null;
        return true;
    }

    public boolean passed(String s) {
        this.type = 0;
        this.reason = s;
        return true;
    }

    public boolean failed(String s) {
        this.type = 1;
        this.reason = s;
        return false;
    }

    public boolean error(String s) {
        this.type = 2;
        this.reason = s;
        return false;
    }

    public boolean notrun(String s) {
        this.type = 3;
        this.reason = s;
        return true;
    }

    public boolean notrun() {
        this.type = 3;
        this.reason = "";
        return true;
    }

    public boolean isPassed() {
        return this.type == 0;
    }

    public String getReason() {
        return this.reason;
    }

    protected boolean exit() {
        if (System.err != null) {
            System.err.println(this.toString());
            System.err.flush();
        }
        if (Boolean.valueOf(System.getProperty(NO_EXIT)).booleanValue()) {
            return this.isPassed();
        }
        System.exit(exitCodes[this.type]);
        return false;
    }
}

