/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.jsonp.api.mergetests;

import ee.jakarta.tck.jsonp.api.common.SimpleValues;
import ee.jakarta.tck.jsonp.api.common.TestResult;
import ee.jakarta.tck.jsonp.api.mergetests.MergeCommon;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import java.util.logging.Logger;

public class MergeReplaceValue
extends MergeCommon {
    private static final Logger LOGGER = Logger.getLogger(MergeReplaceValue.class.getName());

    MergeReplaceValue() {
    }

    TestResult test() {
        TestResult result = new TestResult("RFC 7396: Replace existing values");
        LOGGER.info("Testing RFC 7396: Replace existing values");
        this.testStringOnsimpleObject(result);
        this.testIntOnsimpleObject(result);
        this.testBoolOnsimpleObject(result);
        this.testObjectOnsimpleObject(result);
        return result;
    }

    private void testStringOnsimpleObject(TestResult result) {
        LOGGER.info(" - for String on simple JSON object");
        JsonObject in = SimpleValues.createSimpleObject();
        JsonObject patch = SimpleValues.createSimpleObjectMoveStr();
        JsonObject check = SimpleValues.createSimpleObjectMoveStr();
        this.simpleMerge(result, (JsonValue)in, (JsonValue)patch, (JsonValue)check);
        this.simpleDiff(result, (JsonValue)in, (JsonValue)check, (JsonValue)patch);
    }

    private void testIntOnsimpleObject(TestResult result) {
        LOGGER.info(" - for int on simple JSON object");
        JsonObject in = SimpleValues.createSimpleObject();
        JsonObject patch = SimpleValues.createSimpleObjectMoveInt();
        JsonObject check = SimpleValues.createSimpleObjectMoveInt();
        this.simpleMerge(result, (JsonValue)in, (JsonValue)patch, (JsonValue)check);
        this.simpleDiff(result, (JsonValue)in, (JsonValue)check, (JsonValue)patch);
    }

    private void testBoolOnsimpleObject(TestResult result) {
        LOGGER.info(" - for boolean on simple JSON object");
        JsonObject in = SimpleValues.createSimpleObject();
        JsonObject patch = SimpleValues.createSimpleObjectMoveBool();
        JsonObject check = SimpleValues.createSimpleObjectMoveBool();
        this.simpleMerge(result, (JsonValue)in, (JsonValue)patch, (JsonValue)check);
        this.simpleDiff(result, (JsonValue)in, (JsonValue)check, (JsonValue)patch);
    }

    private void testObjectOnsimpleObject(TestResult result) {
        LOGGER.info(" - for JsonObject on simple JSON object");
        JsonObject in = SimpleValues.createSimpleObject();
        JsonObject patch = SimpleValues.createSimpleObjectMoveObject();
        JsonObject check = SimpleValues.createSimpleObjectMoveObject();
        this.simpleMerge(result, (JsonValue)in, (JsonValue)patch, (JsonValue)check);
        this.simpleDiff(result, (JsonValue)in, (JsonValue)check, (JsonValue)patch);
    }
}

