/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.test.server;

import java.sql.Connection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import javax.sql.DataSource;
import org.eclipse.emf.cdo.server.CDOServerUtil;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.IStore;
import org.eclipse.emf.cdo.server.db.CDODBUtil;
import org.eclipse.emf.cdo.server.db.IDBStore;
import org.eclipse.emf.cdo.server.db.mapping.IMappingStrategy;
import org.eclipse.emf.cdo.server.net4j.CDONet4jServerUtil;
import org.eclipse.net4j.acceptor.IAcceptor;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBAdapter;
import org.eclipse.net4j.db.IDBConnectionProvider;
import org.eclipse.net4j.db.h2.H2Adapter;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.h2.jdbcx.JdbcDataSource;

public final class IntentCDORepository {
    private static IRepository repository;
    private static IAcceptor acceptor;
    private static final String SERVER_LOCATION = "localhost";
    private static final String SERVER_PORT_NUMBER = "1027";

    private IntentCDORepository() {
    }

    public static void start(boolean cleanStore, String repositoryName) {
        if (acceptor == null) {
            JdbcDataSource dataSource = new JdbcDataSource();
            dataSource.setURL("jdbc:h2:_database/" + repositoryName);
            IMappingStrategy mappingStrategy = CDODBUtil.createHorizontalMappingStrategy((boolean)true);
            LinkedHashMap<String, String> mappingProperties = new LinkedHashMap<String, String>();
            mappingProperties.put("objectTypeCacheSize", "1000");
            mappingProperties.put("qualifiedNames", Boolean.TRUE.toString());
            mappingStrategy.setProperties(mappingProperties);
            H2Adapter dbAdapter = new H2Adapter();
            IDBConnectionProvider dbConnectionProvider = DBUtil.createConnectionProvider((DataSource)dataSource);
            if (cleanStore) {
                DBUtil.dropAllTables((Connection)dbConnectionProvider.getConnection(), (String)repositoryName);
            }
            IDBStore store = CDODBUtil.createStore((IMappingStrategy)mappingStrategy, (IDBAdapter)dbAdapter, (IDBConnectionProvider)dbConnectionProvider);
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("overrideUUID", repositoryName);
            props.put("supportingAudits", "false");
            props.put("supportingBranches", "false");
            props.put("supportingEcore", "true");
            repository = CDOServerUtil.createRepository((String)repositoryName, (IStore)store, props);
            CDOServerUtil.addRepository((IManagedContainer)IPluginContainer.INSTANCE, (IRepository)repository);
            CDONet4jServerUtil.prepareContainer((IManagedContainer)IPluginContainer.INSTANCE);
            acceptor = (IAcceptor)IPluginContainer.INSTANCE.getElement("org.eclipse.net4j.acceptors", "tcp", "localhost:1027");
        }
    }

    public static void stop() {
        if (acceptor != null) {
            LifecycleUtil.deactivate((Object)acceptor);
            LifecycleUtil.deactivate((Object)repository);
            acceptor = null;
            repository = null;
        }
    }

    public static String getServerLocation() {
        return "localhost:1027";
    }
}

