/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.ide.editor.ui;

import com.google.inject.Injector;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.commands.common.EventManager;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.glsp.graph.GModelElement;
import org.eclipse.glsp.graph.GModelIndex;
import org.eclipse.glsp.ide.editor.GLSPServerManager;
import org.eclipse.glsp.ide.editor.actions.GLSPActionProvider;
import org.eclipse.glsp.ide.editor.actions.InvokeCopyAction;
import org.eclipse.glsp.ide.editor.actions.InvokeCutAction;
import org.eclipse.glsp.ide.editor.actions.InvokeDeleteAction;
import org.eclipse.glsp.ide.editor.actions.InvokePasteAction;
import org.eclipse.glsp.ide.editor.di.IdeActionDispatcher;
import org.eclipse.glsp.ide.editor.internal.utils.UrlUtils;
import org.eclipse.glsp.ide.editor.ui.BrowserContextMenuInstaller;
import org.eclipse.glsp.ide.editor.ui.BrowserFocusControlInstaller;
import org.eclipse.glsp.ide.editor.ui.BrowserKeyBindingForwarderInstaller;
import org.eclipse.glsp.ide.editor.ui.FocusAwareBrowser;
import org.eclipse.glsp.ide.editor.ui.GLSPDiagramEditorStatusBar;
import org.eclipse.glsp.ide.editor.ui.GLSPIdeEditorPlugin;
import org.eclipse.glsp.ide.editor.utils.GLSPDiagramEditorMarkerUtil;
import org.eclipse.glsp.ide.editor.utils.IdeClientOptions;
import org.eclipse.glsp.ide.editor.utils.UIUtil;
import org.eclipse.glsp.server.actions.ActionDispatcher;
import org.eclipse.glsp.server.actions.SelectAction;
import org.eclipse.glsp.server.actions.SelectAllAction;
import org.eclipse.glsp.server.actions.StatusAction;
import org.eclipse.glsp.server.disposable.DisposableCollection;
import org.eclipse.glsp.server.features.contextactions.RequestContextActions;
import org.eclipse.glsp.server.features.navigation.NavigateToTargetAction;
import org.eclipse.glsp.server.features.undoredo.RedoAction;
import org.eclipse.glsp.server.features.undoredo.UndoAction;
import org.eclipse.glsp.server.model.GModelState;
import org.eclipse.glsp.server.session.ClientSessionManager;
import org.eclipse.glsp.server.types.EditorContext;
import org.eclipse.glsp.server.types.GLSPServerException;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.keys.IBindingService;

public class GLSPDiagramComposite
implements IGotoMarker,
ISelectionProvider {
    public static final String GLSP_CLIENT_ID = "GLSP_CLIENT_ID";
    public static final String APPLICATION_ID = UUID.randomUUID().toString();
    protected static final Logger LOGGER = LogManager.getLogger(GLSPDiagramComposite.class);
    protected static final String GLSP_CONTEXT_MENU_ID = "context-menu";
    protected static final AtomicInteger COUNT = new AtomicInteger(0);
    protected Composite root;
    protected Browser browser;
    protected GLSPDiagramEditorStatusBar statusBar;
    protected String widgetId;
    protected String clientId;
    protected String browserUrl;
    protected final CompletableFuture<Injector> injector = new CompletableFuture();
    protected boolean dirty;
    protected final List<Consumer<Boolean>> dirtyListener = new ArrayList<Consumer<Boolean>>();
    protected final SelectionManager selectionListener = new SelectionManager();
    protected StructuredSelection currentSelection = StructuredSelection.EMPTY;
    protected final DisposableCollection toDispose = new DisposableCollection();
    protected final Map<String, IAction> globalActions = new HashMap<String, IAction>(Map.of(ActionFactory.UNDO.getId(), GLSPDiagramComposite.actionFor(this::undo), ActionFactory.REDO.getId(), GLSPDiagramComposite.actionFor(this::redo), ActionFactory.CUT.getId(), GLSPDiagramComposite.actionFor(this::cut), ActionFactory.COPY.getId(), GLSPDiagramComposite.actionFor(this::copy), ActionFactory.PASTE.getId(), GLSPDiagramComposite.actionFor(this::paste), ActionFactory.DELETE.getId(), GLSPDiagramComposite.actionFor(this::delete), ActionFactory.SELECT_ALL.getId(), GLSPDiagramComposite.actionFor(this::selectAll)));
    protected IEclipseContext context;
    protected String input;
    protected final String editorId;

    public GLSPDiagramComposite(String editorId) {
        this.editorId = editorId;
    }

    public GLSPServerManager getServerManager() {
        Optional<GLSPServerManager> serverManager = GLSPIdeEditorPlugin.getDefault().getGLSPEditorRegistry().getGLSPServerManager(this);
        if (!serverManager.isPresent()) {
            throw new GLSPServerException("Could not retrieve GLSPServerManager. GLSP editor is not properly configured: " + this.getEditorId());
        }
        return serverManager.get();
    }

    protected Optional<GLSPActionProvider> getActionProvider() {
        return Optional.empty();
    }

    public Map<String, IAction> getGlobalActions() {
        return this.globalActions;
    }

    public String getClientId() {
        if (this.clientId == null) {
            this.clientId = this.generateClientId();
        }
        return this.clientId;
    }

    protected void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getWidgetId() {
        return this.widgetId;
    }

    protected void setWidgetId(String widgetId) {
        this.widgetId = widgetId;
    }

    protected void undo() {
        this.dispatch((org.eclipse.glsp.server.actions.Action)new UndoAction());
    }

    protected void redo() {
        this.dispatch((org.eclipse.glsp.server.actions.Action)new RedoAction());
    }

    protected void copy() {
        this.dispatch(new InvokeCopyAction());
    }

    protected void cut() {
        this.dispatch(new InvokeCutAction());
    }

    protected void paste() {
        this.dispatch(new InvokePasteAction());
    }

    protected void delete() {
        this.dispatch(new InvokeDeleteAction());
    }

    protected void selectAll() {
        this.dispatch((org.eclipse.glsp.server.actions.Action)new SelectAllAction(true));
    }

    public void showServerStatus(StatusAction action) {
        this.statusBar.showServerStatus(action);
    }

    public void handleRequestContext(RequestContextActions action) {
        if (!GLSP_CONTEXT_MENU_ID.equals(action.getContextId())) {
            return;
        }
        this.context.set(EditorContext.class, (Object)action.getEditorContext());
    }

    public void gotoMarker(IMarker marker) {
        this.getModelStateOnceInitialized().thenAccept(modelState -> GLSPDiagramEditorMarkerUtil.asNavigationTarget(marker, Optional.of(modelState)).map(NavigateToTargetAction::new).ifPresent(this::dispatch));
    }

    public void setInjector(Injector injector) {
        this.injector.complete(injector);
        this.context.set(ActionDispatcher.class, (Object)((ActionDispatcher)injector.getInstance(ActionDispatcher.class)));
    }

    public Injector getInjector() {
        return this.injector.getNow(null);
    }

    protected <T> CompletableFuture<T> getInstance(Class<T> type) {
        return this.injector.thenApply(injector -> injector.getInstance(type));
    }

    protected CompletableFuture<ActionDispatcher> getActionDispatcher() {
        return this.getInstance(ActionDispatcher.class);
    }

    protected CompletableFuture<GModelState> getModelState() {
        return this.getInstance(GModelState.class);
    }

    protected CompletableFuture<GModelState> getModelStateOnceInitialized() {
        return this.onceModelInitialized().thenCompose(initialized -> this.getModelState());
    }

    protected CompletableFuture<Void> dispatch(org.eclipse.glsp.server.actions.Action action) {
        LOGGER.debug("Dispatch action for client id '" + this.clientId + "':" + String.valueOf(action));
        return this.getActionDispatcher().thenCompose(actionDispatcher -> actionDispatcher.dispatch(action));
    }

    protected CompletableFuture<Void> onceModelInitialized() {
        return this.getActionDispatcher().thenCompose(this::onceModelInitialized);
    }

    protected CompletableFuture<Void> onceModelInitialized(ActionDispatcher actionDispatcher) {
        if (actionDispatcher instanceof IdeActionDispatcher) {
            return ((IdeActionDispatcher)actionDispatcher).onceModelInitialized();
        }
        return CompletableFuture.completedFuture(null);
    }

    public void init(IEclipseContext context, String input) {
        this.context = context;
        this.input = input;
        this.setWidgetId(this.generateWidgetId());
        this.configureContext(context);
        this.getModelStateOnceInitialized().thenAccept(this::syncMarkers);
    }

    protected String generateClientId() {
        return this.getServerManager().getGlspId() + "_Editor_" + COUNT.incrementAndGet();
    }

    protected String generateWidgetId() {
        return this.getClientId();
    }

    public void createPartControl(Composite parent) {
        this.root = new Composite(parent, 16);
        this.root.setLayout((Layout)new GridLayout(1, true));
        this.root.setBackground(parent.getBackground());
        this.browser = this.createBrowser(this.root);
        this.setupBrowser(this.browser);
        this.statusBar = this.createStatusBar(this.root);
    }

    protected void configureContext(IEclipseContext context) {
        GLSPServerManager serverManager = this.getServerManager();
        context.set(GLSPServerManager.class, (Object)serverManager);
        context.set(GLSP_CLIENT_ID, (Object)this.clientId);
        context.set(GLSPDiagramComposite.class, (Object)this);
        this.getActionProvider().ifPresent(provider -> context.set(GLSPActionProvider.class, provider));
        context.declareModifiable(EditorContext.class);
    }

    protected void syncMarkers(GModelState modelState) {
        IdeClientOptions.getSourceUriAsIFile(modelState.getClientOptions()).map(workspaceFile -> GLSPDiagramEditorMarkerUtil.syncMarkers((IResource)workspaceFile, modelState.getClientId(), this.getActionDispatcher().getNow(null))).ifPresent(arg_0 -> ((DisposableCollection)this.toDispose).add(arg_0));
    }

    protected Browser createBrowser(Composite parent) {
        FocusAwareBrowser browser = new FocusAwareBrowser(parent, 262160);
        browser.setLayoutData(new GridData(4, 4, true, true));
        this.toDispose.add(() -> ((Browser)browser).dispose());
        return browser;
    }

    protected void setupBrowser(Browser browser) {
        Browser.clearSessions();
        browser.refresh();
        browser.addMouseTrackListener(MouseTrackListener.mouseEnterAdapter(this::mouseEnteredBrowser));
        browser.addProgressListener(ProgressListener.completedAdapter(event -> this.installBrowserFunctions()));
        this.browserUrl = this.createBrowserUrl();
        browser.setUrl(this.browserUrl);
        browser.refresh();
    }

    public String getBrowserUrl() {
        return this.browserUrl;
    }

    protected void mouseEnteredBrowser(MouseEvent event) {
        if (this.getWidgetId() != null) {
            String dispatchMouseUp = "var element = document.getElementById(\"" + this.getWidgetId() + "\");if(element) {    const event = new MouseEvent('mouseup', {});   element.children[0].dispatchEvent(event);}";
            this.browser.execute(dispatchMouseUp);
        }
    }

    protected void installBrowserFunctions() {
        new BrowserKeyBindingForwarderInstaller((IBindingService)this.context.get(IBindingService.class)).install(this.browser);
        new BrowserFocusControlInstaller().install(this.browser);
        new BrowserContextMenuInstaller().install(this.browser);
    }

    protected String getBaseUrl() {
        return "diagram.html";
    }

    protected String createBrowserUrl() {
        String path = this.input;
        GLSPServerManager manager = this.getServerManager();
        ServerConnector connector = Stream.of(manager.getServer().getConnectors()).findFirst().map(ServerConnector.class::cast).orElse(null);
        if (connector != null) {
            HashMap<String, String> queryParams = new HashMap<String, String>();
            queryParams.put("client", this.clientId);
            queryParams.put("path", path);
            queryParams.put("port", "" + manager.getLocalPort());
            queryParams.put("widget", this.getWidgetId());
            queryParams.put("application", APPLICATION_ID);
            return this.createBrowserUrl(connector.getHost(), manager.getLocalPort(), this.getBaseUrl(), queryParams);
        }
        return null;
    }

    protected String createBrowserUrl(String host, int port, String baseUrl, Map<String, String> queryParams) {
        return UrlUtils.createUrl(host, port, baseUrl, queryParams);
    }

    protected String encodeParameter(String parameter) throws UnsupportedEncodingException {
        return URLEncoder.encode(parameter, "UTF-8");
    }

    protected GLSPDiagramEditorStatusBar createStatusBar(Composite parent) {
        GLSPDiagramEditorStatusBar statusBar = new GLSPDiagramEditorStatusBar(parent);
        statusBar.setLayout((Layout)new RowLayout());
        return statusBar;
    }

    public void setFocus() {
        this.browser.setFocus();
    }

    public void notifyAboutToBeDisposed() {
        this.getClientSessionManager().thenAccept(sessionManager -> {
            boolean bl = sessionManager.disposeClientSession(this.getClientId());
        });
    }

    protected CompletableFuture<ClientSessionManager> getClientSessionManager() {
        return this.getInstance(ClientSessionManager.class);
    }

    public void dispose() {
        this.statusBar.dispose();
        this.toDispose.dispose();
    }

    protected static IAction actionFor(final Runnable runnable) {
        return new Action(){

            public void run() {
                runnable.run();
            }
        };
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListener.addSelectionChangedListener(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListener.removeSelectionChangedListener(listener);
    }

    public ISelection getSelection() {
        return this.currentSelection;
    }

    public void setSelection(ISelection selection) {
        if (!(selection instanceof StructuredSelection)) {
            return;
        }
        this.getModelStateOnceInitialized().thenAccept(modelState -> {
            StructuredSelection structuredSelection = (StructuredSelection)selection;
            List toSelect = this.toGModelElementStream(structuredSelection).map(GModelElement::getId).collect(Collectors.toList());
            Set toDeselect = modelState.getIndex().allIds();
            toDeselect.removeAll(toSelect);
            this.dispatch((org.eclipse.glsp.server.actions.Action)new SelectAction(toSelect, new ArrayList(toDeselect)));
        });
    }

    public void updateSelection(SelectAction selectAction) {
        this.getModelStateOnceInitialized().thenAccept(modelState -> {
            List selectedIds = selectAction.getSelectedElementsIDs();
            Collection deselectedIds = selectAction.isDeselectAll() ? modelState.getIndex().allIds() : selectAction.getDeselectedElementsIDs();
            List<GModelElement> selectedGModelElements = this.toGModelElements(selectedIds, (GModelState)modelState);
            List<GModelElement> deselectedGModelElements = this.toGModelElements(deselectedIds, (GModelState)modelState);
            List<GModelElement> selection = this.toGModelElementStream(this.currentSelection).collect(Collectors.toList());
            selection.removeAll(deselectedGModelElements);
            this.addUnique(selectedGModelElements, selection);
            this.currentSelection = new StructuredSelection(selection);
            this.selectionListener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, (ISelection)this.currentSelection));
        });
    }

    protected void addUnique(List<GModelElement> fromList, List<GModelElement> toList) {
        for (GModelElement newSelectedElement : fromList) {
            if (toList.contains(newSelectedElement)) continue;
            toList.add(newSelectedElement);
        }
    }

    protected Stream<GModelElement> toGModelElementStream(StructuredSelection selection) {
        return selection.toList().stream().filter(GModelElement.class::isInstance).map(GModelElement.class::cast);
    }

    protected List<GModelElement> toGModelElements(Collection<String> ids, GModelState modelState) {
        return ids.stream().map(arg_0 -> ((GModelIndex)modelState.getIndex()).get(arg_0)).flatMap(Optional::stream).collect(Collectors.toList());
    }

    public String getEditorId() {
        return this.editorId;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
        this.dirtyListener.forEach(listener -> listener.accept(dirty));
    }

    public void addDirtyStateListener(Consumer<Boolean> listener) {
        this.dirtyListener.add(listener);
    }

    public Browser getBrowser() {
        return this.browser;
    }

    public Shell getShell() {
        if (this.browser != null) {
            return this.browser.getShell();
        }
        return null;
    }

    protected static class SelectionManager
    extends EventManager {
        protected SelectionManager() {
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            this.addListenerObject(listener);
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            this.removeListenerObject(listener);
        }

        public void selectionChanged(SelectionChangedEvent event) {
            Object[] objectArray = this.getListeners();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener = objectArray[n2];
                ISelectionChangedListener selectionChangedListeners = (ISelectionChangedListener)listener;
                UIUtil.asyncExec(() -> selectionChangedListeners.selectionChanged(event));
                ++n2;
            }
        }
    }
}

