/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.ide.editor.ui;

import com.google.inject.Injector;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.glsp.ide.editor.GLSPServerManager;
import org.eclipse.glsp.ide.editor.actions.GLSPActionProvider;
import org.eclipse.glsp.ide.editor.actions.InvokeCopyAction;
import org.eclipse.glsp.ide.editor.actions.InvokeCutAction;
import org.eclipse.glsp.ide.editor.actions.InvokeDeleteAction;
import org.eclipse.glsp.ide.editor.actions.InvokePasteAction;
import org.eclipse.glsp.ide.editor.di.IdeActionDispatcher;
import org.eclipse.glsp.ide.editor.internal.utils.UrlUtils;
import org.eclipse.glsp.ide.editor.ui.ChromiumKeyBindingFunction;
import org.eclipse.glsp.ide.editor.ui.ChromiumSelectionFunction;
import org.eclipse.glsp.ide.editor.ui.FocusAwareBrowser;
import org.eclipse.glsp.ide.editor.ui.GLSPIdeEditorPlugin;
import org.eclipse.glsp.ide.editor.ui.GSLPDiagramEditorStatusBar;
import org.eclipse.glsp.ide.editor.utils.GLSPDiagramEditorMarkerUtil;
import org.eclipse.glsp.ide.editor.utils.IdeClientOptions;
import org.eclipse.glsp.ide.editor.utils.UIUtil;
import org.eclipse.glsp.server.actions.ActionDispatcher;
import org.eclipse.glsp.server.actions.SaveModelAction;
import org.eclipse.glsp.server.actions.SelectAllAction;
import org.eclipse.glsp.server.actions.ServerStatusAction;
import org.eclipse.glsp.server.disposable.DisposableCollection;
import org.eclipse.glsp.server.features.contextactions.RequestContextActions;
import org.eclipse.glsp.server.features.navigation.NavigateToTargetAction;
import org.eclipse.glsp.server.features.undoredo.RedoAction;
import org.eclipse.glsp.server.features.undoredo.UndoAction;
import org.eclipse.glsp.server.model.GModelState;
import org.eclipse.glsp.server.types.EditorContext;
import org.eclipse.glsp.server.types.GLSPServerException;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.EditorPart;

public class GLSPDiagramEditor
extends EditorPart
implements IGotoMarker {
    public static final String GLSP_CLIENT_ID = "GLSP_CLIENT_ID";
    public static final String APPLICATION_ID = UUID.randomUUID().toString();
    protected static final Logger LOGGER = Logger.getLogger(GLSPDiagramEditor.class);
    protected static final String GLSP_CONTEXT_MENU_ID = "context-menu";
    protected static final AtomicInteger COUNT = new AtomicInteger(0);
    protected Composite root;
    protected Browser browser;
    protected GSLPDiagramEditorStatusBar statusBar;
    protected String widgetId;
    protected String clientId;
    protected String browserUrl;
    protected final CompletableFuture<Injector> injector = new CompletableFuture();
    protected boolean dirty;
    protected final DisposableCollection toDispose = new DisposableCollection();
    protected final Map<String, IAction> globalActions = new HashMap<String, IAction>(Map.of(ActionFactory.UNDO.getId(), GLSPDiagramEditor.actionFor(this::undo), ActionFactory.REDO.getId(), GLSPDiagramEditor.actionFor(this::redo), ActionFactory.CUT.getId(), GLSPDiagramEditor.actionFor(this::cut), ActionFactory.COPY.getId(), GLSPDiagramEditor.actionFor(this::copy), ActionFactory.PASTE.getId(), GLSPDiagramEditor.actionFor(this::paste), ActionFactory.DELETE.getId(), GLSPDiagramEditor.actionFor(this::delete), ActionFactory.SELECT_ALL.getId(), GLSPDiagramEditor.actionFor(this::selectAll)));

    public GLSPServerManager getServerManager() {
        Optional<GLSPServerManager> serverManager = GLSPIdeEditorPlugin.getDefault().getGLSPEditorRegistry().getGLSPServerManager(this);
        if (!serverManager.isPresent()) {
            throw new GLSPServerException("Could not retrieve GLSPServerManager. GLSP editor is not properly configured: " + this.getEditorSite().getId());
        }
        return serverManager.get();
    }

    protected Optional<GLSPActionProvider> getActionProvider() {
        return Optional.empty();
    }

    public String getEditorId() {
        return this.getConfigurationElement().getAttribute("id");
    }

    public Map<String, IAction> getGlobalActions() {
        return this.globalActions;
    }

    public String getClientId() {
        if (this.clientId == null) {
            this.clientId = this.generateClientId();
        }
        return this.clientId;
    }

    protected void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getWidgetId() {
        return this.widgetId;
    }

    protected void setWidgetId(String widgetId) {
        this.widgetId = widgetId;
    }

    public void doSave(IProgressMonitor monitor) {
        this.dispatch((org.eclipse.glsp.server.actions.Action)new SaveModelAction());
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        if (this.dirty != dirty) {
            this.dirty = dirty;
            UIUtil.asyncExec(() -> this.firePropertyChange(257));
        }
    }

    protected void undo() {
        this.dispatch((org.eclipse.glsp.server.actions.Action)new UndoAction());
    }

    protected void redo() {
        this.dispatch((org.eclipse.glsp.server.actions.Action)new RedoAction());
    }

    protected void copy() {
        this.dispatch(new InvokeCopyAction());
    }

    protected void cut() {
        this.dispatch(new InvokeCutAction());
    }

    protected void paste() {
        this.dispatch(new InvokePasteAction());
    }

    protected void delete() {
        this.dispatch(new InvokeDeleteAction());
    }

    protected void selectAll() {
        this.dispatch((org.eclipse.glsp.server.actions.Action)new SelectAllAction(true));
    }

    public void showServerStatus(ServerStatusAction action) {
        this.statusBar.showServerStatus(action);
    }

    public void handleRequestContext(RequestContextActions action) {
        if (!GLSP_CONTEXT_MENU_ID.equals(action.getContextId())) {
            return;
        }
        ((IEclipseContext)this.getSite().getService(IEclipseContext.class)).set(EditorContext.class, (Object)action.getEditorContext());
    }

    public void gotoMarker(IMarker marker) {
        this.getModelStateOnceInitialized().thenAccept(modelState -> GLSPDiagramEditorMarkerUtil.asNavigationTarget(marker, Optional.of(modelState)).map(NavigateToTargetAction::new).ifPresent(this::dispatch));
    }

    public void setInjector(Injector injector) {
        this.injector.complete(injector);
        IEclipseContext context = (IEclipseContext)this.getSite().getService(IEclipseContext.class);
        context.set(ActionDispatcher.class, (Object)((ActionDispatcher)injector.getInstance(ActionDispatcher.class)));
    }

    public Injector getInjector() {
        return this.injector.getNow(null);
    }

    protected <T> CompletableFuture<T> getInstance(Class<T> type) {
        return this.injector.thenApply(injector -> injector.getInstance(type));
    }

    protected CompletableFuture<ActionDispatcher> getActionDispatcher() {
        return this.getInstance(ActionDispatcher.class);
    }

    protected CompletableFuture<GModelState> getModelState() {
        return this.getInstance(GModelState.class);
    }

    protected CompletableFuture<GModelState> getModelStateOnceInitialized() {
        return this.onceModelInitialized().thenCompose(initialized -> this.getModelState());
    }

    protected CompletableFuture<Void> dispatch(org.eclipse.glsp.server.actions.Action action) {
        return this.getActionDispatcher().thenCompose(actionDispatcher -> actionDispatcher.dispatch(action));
    }

    protected CompletableFuture<Void> onceModelInitialized() {
        return this.getActionDispatcher().thenCompose(this::onceModelInitialized);
    }

    protected CompletableFuture<Void> onceModelInitialized(ActionDispatcher actionDispatcher) {
        if (actionDispatcher instanceof IdeActionDispatcher) {
            return ((IdeActionDispatcher)actionDispatcher).onceModelInitialized();
        }
        return CompletableFuture.completedFuture(null);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.validateEditorInput(input);
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.setClientId(this.generateClientId());
        this.setWidgetId(this.generateWidgetId());
        IEclipseContext context = (IEclipseContext)site.getService(IEclipseContext.class);
        this.configureContext(context);
        this.getModelStateOnceInitialized().thenAccept(this::syncMarkers);
    }

    protected void validateEditorInput(IEditorInput editorInput) throws PartInitException {
        if (!(editorInput instanceof IFileEditorInput)) {
            throw new PartInitException("Invalid editor input: Must be IFileEditorInput");
        }
    }

    protected String getFilePath() {
        IEditorInput editorInput = this.getEditorInput();
        if (editorInput instanceof IFileEditorInput) {
            return ((IFileEditorInput)editorInput).getFile().getLocationURI().getPath();
        }
        return "";
    }

    protected String generateClientId() {
        return String.valueOf(this.getServerManager().getGlspId()) + "_Editor_" + COUNT.incrementAndGet();
    }

    protected String generateWidgetId() {
        return this.getClientId();
    }

    public void createPartControl(Composite parent) {
        this.root = new Composite(parent, 16);
        this.root.setLayout((Layout)new GridLayout(1, true));
        this.setPartName(this.generatePartName());
        this.browser = this.createBrowser(this.root);
        this.setupBrowser(this.browser);
        this.statusBar = this.createStatusBar(this.root);
    }

    protected String generatePartName() {
        return FilenameUtils.getName((String)this.getFilePath());
    }

    protected void configureContext(IEclipseContext context) {
        GLSPServerManager serverManager = this.getServerManager();
        context.set(GLSPServerManager.class, (Object)serverManager);
        context.set(GLSP_CLIENT_ID, (Object)this.clientId);
        this.getActionProvider().ifPresent(provider -> context.set(GLSPActionProvider.class, provider));
        context.declareModifiable(EditorContext.class);
    }

    protected void syncMarkers(GModelState modelState) {
        IdeClientOptions.getSourceUriAsIFile(modelState.getClientOptions()).map(workspaceFile -> GLSPDiagramEditorMarkerUtil.syncMarkers((IResource)workspaceFile, modelState.getClientId(), this.getActionDispatcher().getNow(null))).ifPresent(arg_0 -> ((DisposableCollection)this.toDispose).add(arg_0));
    }

    protected Browser createBrowser(Composite parent) {
        FocusAwareBrowser browser = new FocusAwareBrowser(parent, 131088);
        browser.setLayoutData(new GridData(4, 4, true, true));
        this.toDispose.add(() -> ((Browser)browser).dispose());
        return browser;
    }

    protected void setupBrowser(Browser browser) {
        Browser.clearSessions();
        browser.refresh();
        browser.addMouseTrackListener(MouseTrackListener.mouseEnterAdapter(this::mouseEnteredBrowser));
        browser.setMenu(this.createBrowserMenu());
        browser.addProgressListener(ProgressListener.completedAdapter(event -> this.installBrowserFunctions()));
        this.browserUrl = this.createBrowserUrl();
        browser.setUrl(this.browserUrl);
        browser.refresh();
    }

    public String getBrowserUrl() {
        return this.browserUrl;
    }

    protected void mouseEnteredBrowser(MouseEvent event) {
        if (this.getWidgetId() != null) {
            String dispatchMouseUp = "var element = document.getElementById(\"" + this.getWidgetId() + "\");" + "if(element) { " + "   const event = new MouseEvent('mouseup', {});" + "   element.children[0].dispatchEvent(event);" + "}";
            this.browser.execute(dispatchMouseUp);
        }
    }

    protected Menu createBrowserMenu() {
        MenuManager menuManager = new MenuManager();
        Menu menu = menuManager.createContextMenu((Control)this.browser);
        this.getSite().registerContextMenu(menuManager, this.getSite().getSelectionProvider());
        return menu;
    }

    protected void installBrowserFunctions() {
        ChromiumKeyBindingFunction.install(this, this.browser);
        ChromiumSelectionFunction.install(this, this.browser);
    }

    protected String getBaseUrl() {
        return "diagram.html";
    }

    protected String createBrowserUrl() {
        String path = this.getFilePath();
        GLSPServerManager manager = this.getServerManager();
        ServerConnector connector = Stream.of(manager.getServer().getConnectors()).findFirst().map(ServerConnector.class::cast).orElse(null);
        if (connector != null) {
            HashMap<String, String> queryParams = new HashMap<String, String>();
            queryParams.put("client", this.clientId);
            queryParams.put("path", path);
            queryParams.put("port", "" + manager.getLocalPort());
            queryParams.put("widget", this.getWidgetId());
            queryParams.put("application", APPLICATION_ID);
            return this.createBrowserUrl(connector.getHost(), manager.getLocalPort(), this.getBaseUrl(), queryParams);
        }
        return null;
    }

    protected String createBrowserUrl(String host, int port, String baseUrl, Map<String, String> queryParams) {
        return UrlUtils.createUrl(host, port, baseUrl, queryParams);
    }

    protected String encodeParameter(String parameter) throws UnsupportedEncodingException {
        return URLEncoder.encode(parameter, "UTF-8");
    }

    protected GSLPDiagramEditorStatusBar createStatusBar(Composite parent) {
        GSLPDiagramEditorStatusBar statusBar = new GSLPDiagramEditorStatusBar(parent);
        statusBar.setLayout((Layout)new RowLayout());
        return statusBar;
    }

    public void setFocus() {
        this.browser.setFocus();
    }

    public void dispose() {
        super.dispose();
        this.toDispose.dispose();
    }

    protected static IAction actionFor(final Runnable runnable) {
        return new Action(){

            public void run() {
                runnable.run();
            }
        };
    }
}

