/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.ide.editor;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.glsp.ide.editor.GLSPServerManager;
import org.eclipse.glsp.ide.editor.ui.GLSPDiagramEditor;
import org.eclipse.glsp.ide.editor.ui.GLSPIdeEditorPlugin;
import org.eclipse.glsp.ide.editor.utils.UIUtil;
import org.eclipse.glsp.server.types.GLSPServerException;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPartReference;

public class GLSPEditorRegistry {
    private static String EDITOR_INTEGRATION_EXTENSION_POINT = "org.eclipse.glsp.ide.editor";
    private static String SERVER_MANAGER_CLASS_ATTRIBUTE = "serverManagerClass";
    private static String GLSP_EDITOR_ID_ATTRIBUTE = "editorId";
    private final Map<String, GLSPServerManager> editorIdToServerManager = new HashMap<String, GLSPServerManager>();
    private final Map<String, GLSPDiagramEditor> clientIdtoDiagramEditor = new HashMap<String, GLSPDiagramEditor>();

    public GLSPEditorRegistry() {
        UIUtil.getActiveWorkbenchWindow().ifPresent(window -> window.getPartService().addPartListener((IPartListener2)new GLSPDiagramEditorPartListener()));
        this.obtainProvidersFromRegistry();
    }

    protected void obtainProvidersFromRegistry() {
        IConfigurationElement[] config;
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(EDITOR_INTEGRATION_EXTENSION_POINT);
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                Object classObject = element.createExecutableExtension(SERVER_MANAGER_CLASS_ATTRIBUTE);
                String editorId = element.getAttribute(GLSP_EDITOR_ID_ATTRIBUTE);
                if (classObject instanceof GLSPServerManager) {
                    GLSPServerManager serverManager = (GLSPServerManager)classObject;
                    serverManager.start();
                    this.editorIdToServerManager.put(editorId, serverManager);
                }
            }
            catch (Exception exception) {
                GLSPIdeEditorPlugin.error("Exception while obtaining registered converters", exception);
            }
            ++n2;
        }
    }

    public Optional<GLSPServerManager> getGLSPServerManager(GLSPDiagramEditor diagramEditor) {
        return this.getGLSPServerManager(diagramEditor.getEditorId());
    }

    public Optional<GLSPServerManager> getGLSPServerManager(String editorId) {
        return Optional.of(this.editorIdToServerManager.get(editorId));
    }

    public Optional<GLSPDiagramEditor> getGLSPEditor(String clientId) {
        return Optional.ofNullable(this.clientIdtoDiagramEditor.get(clientId));
    }

    public GLSPDiagramEditor getGLSPEditorOrThrow(String clientId) {
        return (GLSPDiagramEditor)((Object)GLSPServerException.getOrThrow(this.getGLSPEditor(clientId), (String)("Could not retrieve GLSP Editor. GLSP editor is not properly configured for clientId: " + clientId)));
    }

    class GLSPDiagramEditorPartListener
    implements IPartListener2 {
        GLSPDiagramEditorPartListener() {
        }

        public void partClosed(IWorkbenchPartReference part) {
            if (part.getPart(false) instanceof GLSPDiagramEditor) {
                GLSPDiagramEditor editor = (GLSPDiagramEditor)part.getPart(false);
                GLSPEditorRegistry.this.clientIdtoDiagramEditor.remove(editor.getClientId());
            }
        }

        public void partOpened(IWorkbenchPartReference part) {
            if (part.getPart(false) instanceof GLSPDiagramEditor) {
                GLSPDiagramEditor editor = (GLSPDiagramEditor)part.getPart(false);
                GLSPEditorRegistry.this.clientIdtoDiagramEditor.put(editor.getClientId(), editor);
            }
        }
    }
}

