/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.tags.handlers;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.eclipse.gendoc.documents.IDocumentService;
import org.eclipse.gendoc.m2t.IM2TProcessor;
import org.eclipse.gendoc.m2t.IScriptLanguageExtensionService;
import org.eclipse.gendoc.services.GendocServices;
import org.eclipse.gendoc.services.IGendocDiagnostician;
import org.eclipse.gendoc.services.ILogger;
import org.eclipse.gendoc.services.exception.ElementNotFoundException;
import org.eclipse.gendoc.services.exception.GenDocException;
import org.eclipse.gendoc.services.exception.ModelNotFoundException;
import org.eclipse.gendoc.tags.ITag;
import org.eclipse.gendoc.tags.handlers.AbstractPrePostTagHandler;
import org.eclipse.gendoc.tags.handlers.IConfigurationService;
import org.eclipse.gendoc.tags.handlers.IContextService;
import org.eclipse.gendoc.tags.handlers.impl.RegisteredTags;

public abstract class AbstractScriptTagHandler
extends AbstractPrePostTagHandler {
    @Override
    protected String runScripts(ITag tag, String value) throws GenDocException {
        IDocumentService documentService = (IDocumentService)GendocServices.getDefault().getService(IDocumentService.class);
        IGendocDiagnostician gendocDiagnostician = (IGendocDiagnostician)GendocServices.getDefault().getService(IGendocDiagnostician.class);
        ILogger logger = (ILogger)GendocServices.getDefault().getService(ILogger.class);
        IConfigurationService configurationService = (IConfigurationService)GendocServices.getDefault().getService(IConfigurationService.class);
        IM2TProcessor processor = this.getProcessor(configurationService.getLanguage());
        StringBuilder resultBuffer = new StringBuilder();
        IContextService context = (IContextService)GendocServices.getDefault().getService(IContextService.class);
        String cleanedTagValue = documentService.cleanContent(tag.getValue(), processor.getScriptPatterns());
        logger.log("Script before :" + cleanedTagValue, 16);
        try {
            resultBuffer.append(this.runProcessorScript(processor, context, cleanedTagValue, tag));
        }
        catch (GenDocException e) {
            String tagIdFound = (String)tag.getAttributes().get(RegisteredTags.ID);
            String message = "The execution of a script failed: " + e.getUIMessage();
            if (tagIdFound != null) {
                message = "The execution of script with id '" + tagIdFound + "' failed : " + e.getUIMessage();
            }
            gendocDiagnostician.addDiagnostic(4, message, (Object)tag);
            e.printStackTrace();
            StringWriter wr = new StringWriter();
            e.printStackTrace(new PrintWriter((Writer)wr, true));
            return " --- ERROR DURING GENERATION OF THIS PART \n Error message: " + this.removeSpecialCharacters(e.getUIMessage()) + " --- " + wr.toString() + "---" + tag.getRawText() + " --- END ERROR --- ";
        }
        logger.log("Script result :" + resultBuffer.toString(), 16);
        return resultBuffer.toString();
    }

    protected String runProcessorScript(IM2TProcessor processor, IContextService context, String cleanedTagValue, ITag tag) throws GenDocException, ModelNotFoundException, ElementNotFoundException {
        return processor.runScript(cleanedTagValue, context.getElement());
    }

    protected IM2TProcessor getProcessor(String language) throws GenDocException {
        IScriptLanguageExtensionService scriptLanguageExtensionService = (IScriptLanguageExtensionService)GendocServices.getDefault().getService(IScriptLanguageExtensionService.class);
        IM2TProcessor processor = scriptLanguageExtensionService.getProcessor(language);
        return processor;
    }

    private String removeSpecialCharacters(String string) {
        return string.replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("&", "&amp;").replaceAll("'", "&apos;").replaceAll("\"", "&quot;");
    }
}

