/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.jmx.framework;

import java.io.IOException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularType;
import org.osgi.jmx.Item;
import org.osgi.jmx.JmxConstants;

public interface BundleStateMBean {
    public static final String OBJECTNAME = "osgi.core:type=bundleState,version=1.7";
    public static final String KEY = "Key";
    public static final Item KEY_ITEM = new Item("Key", "The bundle header key", SimpleType.STRING, new String[0]);
    public static final String VALUE = "Value";
    public static final Item VALUE_ITEM = new Item("Value", "The bundle header value", SimpleType.STRING, new String[0]);
    public static final CompositeType HEADER_TYPE = Item.compositeType("HEADER", "This type encapsulates OSGi bundle header key/value pairs", KEY_ITEM, VALUE_ITEM);
    public static final TabularType HEADERS_TYPE = Item.tabularType("HEADERS", "The table of bundle headers", HEADER_TYPE, "Key");
    public static final String LOCATION = "Location";
    public static final Item LOCATION_ITEM = new Item("Location", "The location of the bundle", SimpleType.STRING, new String[0]);
    public static final String IDENTIFIER = "Identifier";
    public static final Item IDENTIFIER_ITEM = new Item("Identifier", "The id of the bundle", SimpleType.LONG, new String[0]);
    public static final String SYMBOLIC_NAME = "SymbolicName";
    public static final Item SYMBOLIC_NAME_ITEM = new Item("SymbolicName", "The symbolic name of the bundle", SimpleType.STRING, new String[0]);
    public static final String VERSION = "Version";
    public static final Item VERSION_ITEM = new Item("Version", "The version of the bundle", SimpleType.STRING, new String[0]);
    public static final String START_LEVEL = "StartLevel";
    public static final Item START_LEVEL_ITEM = new Item("StartLevel", "The start level of the bundle", SimpleType.INTEGER, new String[0]);
    public static final String STATE = "State";
    public static final String INSTALLED = "INSTALLED";
    public static final String RESOLVED = "RESOLVED";
    public static final String STARTING = "STARTING";
    public static final String ACTIVE = "ACTIVE";
    public static final String STOPPING = "STOPPING";
    public static final String UNINSTALLED = "UNINSTALLED";
    public static final String UNKNOWN = "UNKNOWN";
    public static final Item STATE_ITEM = new Item("State", "The state of the bundle", SimpleType.STRING, "INSTALLED", "RESOLVED", "STARTING", "ACTIVE", "STOPPING", "UNINSTALLED", "UNKNOWN");
    public static final String LAST_MODIFIED = "LastModified";
    public static final Item LAST_MODIFIED_ITEM = new Item("LastModified", "The last modification time of the bundle", SimpleType.LONG, new String[0]);
    public static final String ACTIVATION_POLICY_USED = "ActivationPolicyUsed";
    public static final Item ACTIVATION_POLICY_USED_ITEM = new Item("ActivationPolicyUsed", "Whether the bundle activation policy must be used", SimpleType.BOOLEAN, new String[0]);
    public static final String PERSISTENTLY_STARTED = "PersistentlyStarted";
    public static final Item PERSISTENTLY_STARTED_ITEM = new Item("PersistentlyStarted", "Whether the bundle is persistently started", SimpleType.BOOLEAN, new String[0]);
    public static final String REMOVAL_PENDING = "RemovalPending";
    public static final Item REMOVAL_PENDING_ITEM = new Item("RemovalPending", "Whether the bundle is pending removal", SimpleType.BOOLEAN, new String[0]);
    public static final String REQUIRED = "Required";
    public static final Item REQUIRED_ITEM = new Item("Required", "Whether the bundle is required", SimpleType.BOOLEAN, new String[0]);
    public static final String FRAGMENT = "Fragment";
    public static final Item FRAGMENT_ITEM = new Item("Fragment", "Whether the bundle is a fragment", SimpleType.BOOLEAN, new String[0]);
    public static final String REGISTERED_SERVICES = "RegisteredServices";
    public static final Item REGISTERED_SERVICES_ITEM = new Item("RegisteredServices", "The registered services of the bundle", JmxConstants.LONG_ARRAY_TYPE, new String[0]);
    public static final String SERVICES_IN_USE = "ServicesInUse";
    public static final Item SERVICES_IN_USE_ITEM = new Item("ServicesInUse", "The services in use by the bundle", JmxConstants.LONG_ARRAY_TYPE, new String[0]);
    public static final String HEADERS = "Headers";
    public static final Item HEADERS_ITEM = new Item("Headers", "The headers of the bundle", HEADERS_TYPE, new String[0]);
    public static final String EXPORTED_PACKAGES = "ExportedPackages";
    public static final Item EXPORTED_PACKAGES_ITEM = new Item("ExportedPackages", "The exported packages of the bundle", JmxConstants.STRING_ARRAY_TYPE, new String[0]);
    public static final String IMPORTED_PACKAGES = "ImportedPackages";
    public static final Item IMPORTED_PACKAGES_ITEM = new Item("ImportedPackages", "The imported packages of the bundle", JmxConstants.STRING_ARRAY_TYPE, new String[0]);
    public static final String FRAGMENTS = "Fragments";
    public static final Item FRAGMENTS_ITEM = new Item("Fragments", "The fragments of which the bundle is host", JmxConstants.LONG_ARRAY_TYPE, new String[0]);
    public static final String HOSTS = "Hosts";
    public static final Item HOSTS_ITEM = new Item("Hosts", "The fragments of which the bundle is host", JmxConstants.LONG_ARRAY_TYPE, new String[0]);
    public static final String REQUIRED_BUNDLES = "RequiredBundles";
    public static final Item REQUIRED_BUNDLES_ITEM = new Item("RequiredBundles", "The required bundles the bundle", JmxConstants.LONG_ARRAY_TYPE, new String[0]);
    public static final String REQUIRING_BUNDLES = "RequiringBundles";
    public static final Item REQUIRING_BUNDLES_ITEM = new Item("RequiringBundles", "The bundles requiring the bundle", JmxConstants.LONG_ARRAY_TYPE, new String[0]);
    public static final String EVENT = "BundleEvent";
    public static final Item EVENT_ITEM = new Item("BundleEvent", "The type of the event: {INSTALLED=1, STARTED=2, STOPPED=4, UPDATED=8, UNINSTALLED=16}", SimpleType.INTEGER, new String[0]);
    public static final CompositeType BUNDLE_EVENT_TYPE = Item.compositeType("BUNDLE_EVENT", "This type encapsulates OSGi bundle events", IDENTIFIER_ITEM, LOCATION_ITEM, SYMBOLIC_NAME_ITEM, EVENT_ITEM);
    public static final CompositeType BUNDLE_TYPE = Item.compositeType("BUNDLE", "This type encapsulates OSGi bundles", EXPORTED_PACKAGES_ITEM, FRAGMENT_ITEM, FRAGMENTS_ITEM, HEADERS_ITEM, HOSTS_ITEM, IDENTIFIER_ITEM, IMPORTED_PACKAGES_ITEM, LAST_MODIFIED_ITEM, LOCATION_ITEM, ACTIVATION_POLICY_USED_ITEM, PERSISTENTLY_STARTED_ITEM, REGISTERED_SERVICES_ITEM, REMOVAL_PENDING_ITEM, REQUIRED_ITEM, REQUIRED_BUNDLES_ITEM, REQUIRING_BUNDLES_ITEM, START_LEVEL_ITEM, STATE_ITEM, SERVICES_IN_USE_ITEM, SYMBOLIC_NAME_ITEM, VERSION_ITEM);
    public static final TabularType BUNDLES_TYPE = Item.tabularType("BUNDLES", "A list of bundles", BUNDLE_TYPE, "Identifier");

    public CompositeData getBundle(long var1) throws IOException;

    public long[] getBundleIds() throws IOException;

    public long[] getRequiredBundles(long var1) throws IOException;

    public TabularData listBundles() throws IOException;

    public TabularData listBundles(String ... var1) throws IOException;

    public String[] getExportedPackages(long var1) throws IOException;

    public long[] getFragments(long var1) throws IOException;

    public TabularData getHeaders(long var1) throws IOException;

    public TabularData getHeaders(long var1, String var3) throws IOException;

    public String getHeader(long var1, String var3) throws IOException;

    public String getHeader(long var1, String var3, String var4) throws IOException;

    public long[] getHosts(long var1) throws IOException;

    public String[] getImportedPackages(long var1) throws IOException;

    public long getLastModified(long var1) throws IOException;

    public long[] getRegisteredServices(long var1) throws IOException;

    public long[] getRequiringBundles(long var1) throws IOException;

    public long[] getServicesInUse(long var1) throws IOException;

    public int getStartLevel(long var1) throws IOException;

    public String getState(long var1) throws IOException;

    public String getSymbolicName(long var1) throws IOException;

    public boolean isActivationPolicyUsed(long var1) throws IOException;

    public boolean isPersistentlyStarted(long var1) throws IOException;

    public boolean isFragment(long var1) throws IOException;

    public boolean isRemovalPending(long var1) throws IOException;

    public boolean isRequired(long var1) throws IOException;

    public String getLocation(long var1) throws IOException;

    public String getVersion(long var1) throws IOException;
}

