/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.management.framework;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.management.Notification;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import org.eclipse.gemini.management.Monitor;
import org.eclipse.gemini.management.framework.internal.OSGiBundle;
import org.eclipse.gemini.management.framework.internal.OSGiBundleEvent;
import org.eclipse.gemini.management.internal.BundleUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.jmx.framework.BundleStateMBean;

public final class BundleState
extends Monitor
implements BundleStateMBean {
    private BundleListener bundleListener;
    private BundleContext bundleContext;

    public BundleState(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    @Override
    public CompositeData getBundle(long bundleId) throws IOException {
        return new OSGiBundle(this.retrieveBundle(bundleId)).asCompositeData();
    }

    @Override
    public long[] getBundleIds() throws IOException {
        Bundle[] bundles = this.bundleContext.getBundles();
        long[] ids = new long[bundles.length];
        int i = 0;
        while (i < bundles.length) {
            ids[i] = bundles[i].getBundleId();
            ++i;
        }
        return ids;
    }

    @Override
    public TabularData listBundles() throws IOException {
        try {
            TabularDataSupport table = new TabularDataSupport(BundleStateMBean.BUNDLES_TYPE);
            Bundle[] bundleArray = this.bundleContext.getBundles();
            int n = bundleArray.length;
            int n2 = 0;
            while (n2 < n) {
                Bundle bundle = bundleArray[n2];
                table.put(new OSGiBundle(bundle).asCompositeData());
                ++n2;
            }
            return table;
        }
        catch (Throwable e) {
            throw new IOException(e);
        }
    }

    @Override
    public TabularData listBundles(String ... bundleTypeItems) throws IOException {
        try {
            ArrayList<OSGiBundle> bundles = new ArrayList<OSGiBundle>();
            Bundle[] bundleArray = this.bundleContext.getBundles();
            int n = bundleArray.length;
            int n2 = 0;
            while (n2 < n) {
                Bundle bundle = bundleArray[n2];
                bundles.add(new OSGiBundle(bundle));
                ++n2;
            }
            TabularData table = OSGiBundle.tableFrom(bundles, bundleTypeItems);
            return table;
        }
        catch (Throwable e) {
            throw new IOException(e);
        }
    }

    @Override
    public String[] getExportedPackages(long bundleId) throws IOException {
        return BundleUtil.getBundleExportedPackages(this.retrieveBundle(bundleId));
    }

    @Override
    public long[] getFragments(long bundleId) throws IOException {
        BundleWiring wiring = (BundleWiring)this.retrieveBundle(bundleId).adapt(BundleWiring.class);
        List requiredWires = wiring.getProvidedWires("osgi.wiring.host");
        return this.bundleWiresToRequirerIds(requiredWires);
    }

    @Override
    public TabularData getHeaders(long bundleId) throws IOException {
        return OSGiBundle.headerTable(this.retrieveBundle(bundleId).getHeaders());
    }

    @Override
    public TabularData getHeaders(long bundleId, String locale) throws IOException {
        return OSGiBundle.headerTable(this.retrieveBundle(bundleId).getHeaders(locale));
    }

    @Override
    public String getHeader(long bundleId, String key) throws IOException {
        return (String)this.retrieveBundle(bundleId).getHeaders().get(key);
    }

    @Override
    public String getHeader(long bundleId, String key, String locale) throws IOException {
        return (String)this.retrieveBundle(bundleId).getHeaders(locale).get(key);
    }

    @Override
    public long[] getHosts(long fragment) throws IOException {
        BundleWiring wiring = (BundleWiring)this.retrieveBundle(fragment).adapt(BundleWiring.class);
        List providedWires = wiring.getRequiredWires("osgi.wiring.host");
        return this.bundleWiresToProviderIds(providedWires);
    }

    @Override
    public String[] getImportedPackages(long bundleId) throws IOException {
        return BundleUtil.getBundleImportedPackages(this.retrieveBundle(bundleId));
    }

    @Override
    public long getLastModified(long bundleId) throws IOException {
        return this.retrieveBundle(bundleId).getLastModified();
    }

    @Override
    public long[] getRegisteredServices(long bundleId) throws IOException {
        return this.serviceIds(this.retrieveBundle(bundleId).getRegisteredServices());
    }

    @Override
    public long[] getRequiringBundles(long bundleId) throws IOException {
        BundleWiring wiring = (BundleWiring)this.retrieveBundle(bundleId).adapt(BundleWiring.class);
        List providedWires = wiring.getProvidedWires("osgi.wiring.bundle");
        return this.bundleWiresToRequirerIds(providedWires);
    }

    @Override
    public long[] getServicesInUse(long bundleIdentifier) throws IOException {
        return this.serviceIds(this.retrieveBundle(bundleIdentifier).getServicesInUse());
    }

    @Override
    public int getStartLevel(long bundleId) throws IOException {
        return BundleUtil.getBundleStartLevel(this.retrieveBundle(bundleId));
    }

    @Override
    public String getState(long bundleId) throws IOException {
        return BundleUtil.getBundleState(this.retrieveBundle(bundleId));
    }

    @Override
    public String getSymbolicName(long bundleId) throws IOException {
        return this.retrieveBundle(bundleId).getSymbolicName();
    }

    @Override
    public String getLocation(long bundleId) throws IOException {
        return this.retrieveBundle(bundleId).getLocation();
    }

    @Override
    public long[] getRequiredBundles(long bundleIdentifier) throws IOException {
        BundleWiring wiring = (BundleWiring)this.retrieveBundle(bundleIdentifier).adapt(BundleWiring.class);
        List requiredWires = wiring.getRequiredWires("osgi.wiring.bundle");
        return this.bundleWiresToProviderIds(requiredWires);
    }

    @Override
    public String getVersion(long bundleId) throws IOException {
        return this.retrieveBundle(bundleId).getVersion().toString();
    }

    @Override
    public boolean isActivationPolicyUsed(long bundleId) throws IOException {
        return BundleUtil.isBundleActivationPolicyUsed(this.retrieveBundle(bundleId));
    }

    @Override
    public boolean isPersistentlyStarted(long bundleId) throws IOException {
        return BundleUtil.isBundlePersistentlyStarted(this.retrieveBundle(bundleId));
    }

    @Override
    public boolean isFragment(long bundleId) throws IOException {
        return BundleUtil.isBundleFragment(this.retrieveBundle(bundleId));
    }

    @Override
    public boolean isRemovalPending(long bundleId) throws IOException {
        return BundleUtil.isRemovalPending(this.retrieveBundle(bundleId));
    }

    @Override
    public boolean isRequired(long bundleId) throws IOException {
        return BundleUtil.isRequired(this.retrieveBundle(bundleId));
    }

    private Bundle retrieveBundle(long bundleId) throws IOException {
        Bundle b = this.bundleContext.getBundle(bundleId);
        if (b == null) {
            throw new IOException("Bundle with id: " + bundleId + " does not exist");
        }
        return b;
    }

    private long[] bundleWiresToRequirerIds(List<BundleWire> wires) {
        long[] consumerWirings = new long[wires.size()];
        int i = 0;
        for (BundleWire bundleWire : wires) {
            consumerWirings[i] = bundleWire.getRequirerWiring().getBundle().getBundleId();
            ++i;
        }
        return consumerWirings;
    }

    private long[] bundleWiresToProviderIds(List<BundleWire> wires) {
        long[] consumerWirings = new long[wires.size()];
        int i = 0;
        for (BundleWire bundleWire : wires) {
            consumerWirings[i] = bundleWire.getProviderWiring().getBundle().getBundleId();
            ++i;
        }
        return consumerWirings;
    }

    private long[] serviceIds(ServiceReference<?>[] refs) {
        if (refs == null) {
            return new long[0];
        }
        long[] ids = new long[refs.length];
        int i = 0;
        while (i < refs.length) {
            ids[i] = (Long)refs[i].getProperty("service.id");
            ++i;
        }
        return ids;
    }

    @Override
    protected void addListener() {
        this.bundleListener = this.getBundleListener();
        this.bundleContext.addBundleListener(this.bundleListener);
    }

    private BundleListener getBundleListener() {
        return new BundleListener(){

            public void bundleChanged(BundleEvent bundleEvent) {
                ObjectName objectName = BundleState.this.objectName;
                BundleState bundleState = BundleState.this;
                long l = bundleState.sequenceNumber;
                bundleState.sequenceNumber = l + 1L;
                Notification notification = new Notification("BundleEvent", objectName, l);
                notification.setUserData(new OSGiBundleEvent(bundleEvent).asCompositeData());
                BundleState.this.sendNotification(notification);
            }
        };
    }

    @Override
    protected void removeListener() {
        if (this.bundleListener != null) {
            this.bundleContext.removeBundleListener(this.bundleListener);
        }
    }
}

