/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.java.gen;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.etmap.util.ETMapUtil;
import org.eclipse.etrice.core.etphys.eTPhys.NodeRef;
import org.eclipse.etrice.core.genmodel.etricegen.AbstractInstance;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.genmodel.etricegen.StructureInstance;
import org.eclipse.etrice.core.genmodel.etricegen.SubSystemInstance;
import org.eclipse.etrice.core.genmodel.etricegen.SystemInstance;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.SubSystemClass;
import org.eclipse.etrice.generator.base.io.IGeneratorFileIO;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.etrice.generator.java.gen.JavaExtensions;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;

@Singleton
public class NodeRunnerGen {
    @Inject
    @Extension
    private RoomExtensions roomExt;
    @Inject
    @Extension
    private JavaExtensions _javaExtensions;
    @Inject
    private IGeneratorFileIO fileIO;

    public void doGenerate(Root root) {
        Collection collection = ETMapUtil.getNodeRefs();
        for (NodeRef nr : collection) {
            List list = ETMapUtil.getSubSystemInstancePaths((NodeRef)nr);
            for (String instpath : list) {
                StructureInstance structureInstance = root.getInstance(instpath);
                SubSystemInstance ssi = (SubSystemInstance)structureInstance;
                if (ssi == null) continue;
                String string = this._javaExtensions.getJavaClassName(nr, ssi);
                String file = String.valueOf(string) + "Runner.java";
                String filepath = this.roomExt.getPath((RoomClass)ssi.getSubSystemClass());
                this.fileIO.generateFile("generating SubSystemRunner implementation", String.valueOf(filepath) + file, this.generate(root, ssi));
            }
        }
    }

    public CharSequence generate(Root root, SubSystemInstance ssc) {
        StringConcatenation stringConcatenation = null;
        SubSystemClass cc = ssc.getSubSystemClass();
        NodeRef nr = ETMapUtil.getNodeRef((AbstractInstance)ssc);
        String clsname = this._javaExtensions.getJavaClassName(nr, ssc);
        StringConcatenation stringConcatenation2 = new StringConcatenation();
        stringConcatenation2.append("/**");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("* @author generated by eTrice");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("*");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("* this class contains the main function running component ");
        String string = ssc.getName();
        stringConcatenation2.append(string, " ");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("* it instantiates ");
        String string2 = ssc.getName();
        stringConcatenation2.append(string2, " ");
        stringConcatenation2.append(" and starts and ends the lifecycle");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("*/");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("package ");
        String string3 = this.roomExt.getPackage((RoomClass)cc);
        stringConcatenation2.append(string3);
        stringConcatenation2.append(";");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("import org.eclipse.etrice.runtime.java.modelbase.RTSystem;");
        stringConcatenation2.newLine();
        stringConcatenation2.append("import org.eclipse.etrice.runtime.java.modelbase.SubSystemRunnerBase;");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("public class ");
        stringConcatenation2.append(String.valueOf(clsname) + "Runner");
        stringConcatenation2.append(" extends SubSystemRunnerBase {");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("/**");
        stringConcatenation2.newLine();
        stringConcatenation2.append("     ");
        stringConcatenation2.append("* main function");
        stringConcatenation2.newLine();
        stringConcatenation2.append("     ");
        stringConcatenation2.append("* creates the main component and starts and stops the lifecycle");
        stringConcatenation2.newLine();
        stringConcatenation2.append("     ");
        stringConcatenation2.append("*/");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("public static void main(String[] args) {");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("// instantiate the main component");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("RTSystem sys = ");
        Object object = ssc.eContainer();
        if (object instanceof SystemInstance) {
            stringConcatenation2.append("new RTSystem(\"");
            EObject eObject = ssc.eContainer();
            String string4 = ((SystemInstance)eObject).getName();
            stringConcatenation2.append(string4, "\t\t");
            stringConcatenation2.append("\")");
        } else {
            stringConcatenation2.append("null");
        }
        stringConcatenation2.append(";");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append(clsname, "\t\t");
        stringConcatenation2.append(" main_component = new ");
        stringConcatenation2.append(clsname, "\t\t");
        stringConcatenation2.append("(sys, \"");
        object = ssc.getName();
        stringConcatenation2.append((String)object, "\t\t");
        stringConcatenation2.append("\");");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("run(main_component, args);");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.append("};");
        stringConcatenation2.newLine();
        stringConcatenation = stringConcatenation2;
        return stringConcatenation;
    }
}

