/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.options;

import java.util.Locale;
import org.eclipse.escet.cif.simulator.options.AutoTimeDuration;
import org.eclipse.escet.common.app.framework.options.Option;
import org.eclipse.escet.common.app.framework.options.OptionGroup;
import org.eclipse.escet.common.app.framework.options.Options;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.InvalidOptionException;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class AutoTimeDurationOption
extends Option<AutoTimeDuration> {
    public AutoTimeDurationOption() {
        super("Automatic mode time transition duration", "The automatic mode time transition duration specifies how the automatic input mode chooses the duration of a time transition that is to be taken. Specify \"max\" (default), to always choose the maximum allowed duration. Specify \"random:UPPER:NNN\" to randomly select durations using a uniform distribution with upper bound UPPER, and initial random generator seed NNN. UPPER most be a positive integer or real value, NNN must be in the interval [0..2^30]. The initial seed may be omitted to use a random seed.", null, "auto-time", "AUTOTIME", true);
    }

    public static AutoTimeDuration getAutoTimeDuration() {
        return (AutoTimeDuration)Options.get(AutoTimeDurationOption.class);
    }

    public AutoTimeDuration getDefault() {
        return new AutoTimeDuration(false, null, null);
    }

    public AutoTimeDuration parseValue(String optName, String value) {
        double upper;
        if (value.toLowerCase(Locale.US).equals("max")) {
            return new AutoTimeDuration(false, null, null);
        }
        AutoTimeDurationOption.checkValue((boolean)value.startsWith("random:"), (String)"Unknown automatic mode time transition duration.");
        String v = value.substring("random:".length());
        int idx = v.indexOf(58);
        String upperTxt = idx == -1 ? v : v.substring(0, idx);
        try {
            upper = Double.parseDouble(upperTxt);
        }
        catch (NumberFormatException e) {
            String msg = Strings.fmt((String)"Invalid uniform distribution upper bound value \"%s\".", (Object[])new Object[]{upperTxt});
            throw new InvalidOptionException(msg);
        }
        if (Double.isNaN(upper)) {
            String msg = "Uniform distribution upper bound value is NaN.";
            throw new InvalidOptionException(msg);
        }
        if (Double.isInfinite(upper)) {
            String msg = "Uniform distribution upper bound value is infinite.";
            throw new InvalidOptionException(msg);
        }
        if (upper <= 0.0) {
            String msg = Strings.fmt((String)"Uniform distribution upper bound value %s is not a positive value.", (Object[])new Object[]{upper});
            throw new InvalidOptionException(msg);
        }
        Integer seed = null;
        if (idx != -1) {
            String seedTxt = v.substring(idx + 1);
            try {
                seed = Integer.parseInt(seedTxt);
            }
            catch (NumberFormatException e) {
                String msg = Strings.fmt((String)"Invalid seed value \"%s\".", (Object[])new Object[]{seedTxt});
                throw new InvalidOptionException(msg);
            }
            if (seed < 0 || 0x40000000 < seed) {
                String msg = Strings.fmt((String)"Seed value %d is not in the interval [0..2^30].", (Object[])new Object[]{seed});
                throw new InvalidOptionException(msg);
            }
        }
        return new AutoTimeDuration(true, upper, seed);
    }

    public String[] getCmdLine(Object value) {
        AutoTimeDuration duration = (AutoTimeDuration)value;
        if (!duration.random()) {
            return new String[]{"--auto-time=max"};
        }
        Object arg = "--auto-time=random:";
        arg = (String)arg + Strings.str((Object)duration.upper()).toLowerCase(Locale.US);
        if (duration.seed() != null) {
            arg = (String)arg + ":" + Strings.str((Object)duration.seed());
        }
        return new String[]{arg};
    }

    public OptionGroup<AutoTimeDuration> createOptionGroup(Composite page) {
        return new AutoTimeDurationOptionGroup(page);
    }

    private class AutoTimeDurationOptionGroup
    extends OptionGroup<AutoTimeDuration>
    implements SelectionListener {
        Button maxButton;
        Button randomButton;
        Button seedButton;
        Label randomUpperLabel;
        Text randomUpperText;
        Label seedUpperLabel;
        Text seedUpperText;
        Label seedLabel;
        Spinner seedSpinner;

        public AutoTimeDurationOptionGroup(Composite page) {
            super(page, (Option)AutoTimeDurationOption.this);
        }

        protected void addComponents(Group group) {
            this.maxButton = new Button((Composite)group, 16);
            this.randomButton = new Button((Composite)group, 16);
            this.seedButton = new Button((Composite)group, 16);
            this.maxButton.setText("Maximum allowed duration");
            this.randomButton.setText("Random duration (random seed)");
            this.seedButton.setText("Random duration (specific seed)");
            this.maxButton.addSelectionListener((SelectionListener)this);
            this.randomButton.addSelectionListener((SelectionListener)this);
            this.seedButton.addSelectionListener((SelectionListener)this);
            this.randomUpperLabel = new Label((Composite)group, 0);
            this.randomUpperLabel.setText("Upper bound:");
            this.randomUpperText = new Text((Composite)group, 2052);
            this.seedUpperLabel = new Label((Composite)group, 0);
            this.seedUpperLabel.setText("Upper bound:");
            this.seedUpperText = new Text((Composite)group, 2052);
            this.seedLabel = new Label((Composite)group, 0);
            this.seedLabel.setText("Seed:");
            this.seedSpinner = new Spinner((Composite)group, 2048);
            this.seedSpinner.setMinimum(0);
            this.seedSpinner.setMaximum(0x40000000);
            this.layoutGeneric(new Object[]{this.maxButton, this.randomButton, new Control[]{this.randomUpperLabel, this.randomUpperText}, this.seedButton, new Control[]{this.seedUpperLabel, this.seedUpperText}, new Control[]{this.seedLabel, this.seedSpinner}});
        }

        public String getDescription() {
            return "The automatic mode time transition duration specifies how the automatic input mode chooses the duration of a time transition that is to be taken. When selecting a random duration, a uniform distribution is used, with a user-specified upper bound.";
        }

        public void setToValue(AutoTimeDuration value) {
            Button button = !value.random() ? this.maxButton : (value.seed() == null ? this.randomButton : this.seedButton);
            button.setSelection(true);
            Event event = new Event();
            event.widget = button;
            this.widgetSelected(new SelectionEvent(event));
            String upperTxt = value.upper() != null ? Strings.str((Object)value.upper()).toLowerCase(Locale.US) : "10";
            this.randomUpperText.setText(upperTxt);
            this.seedUpperText.setText(upperTxt);
            int seed = value.seed() == null ? 0 : value.seed();
            Assert.check((seed >= 0 ? 1 : 0) != 0);
            Assert.check((seed <= 0x40000000 ? 1 : 0) != 0);
            this.seedSpinner.setSelection(seed);
        }

        public String[] getCmdLine() {
            if (this.maxButton.getSelection()) {
                return new String[]{"--auto-time=max"};
            }
            if (this.randomButton.getSelection()) {
                return new String[]{"--auto-time=random:" + this.randomUpperText.getText()};
            }
            Assert.check((boolean)this.seedButton.getSelection());
            return new String[]{"--auto-time=random:" + this.seedUpperText.getText() + ":" + Strings.str((Object)this.seedSpinner.getSelection())};
        }

        public void widgetSelected(SelectionEvent e) {
            this.randomUpperText.setEnabled(e.widget == this.randomButton);
            this.seedUpperText.setEnabled(e.widget == this.seedButton);
            this.seedSpinner.setEnabled(e.widget == this.seedButton);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    }
}

