/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.setext.typechecker;

import java.util.Map;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.typechecker.SemanticException;
import org.eclipse.escet.setext.parser.ast.SeTextObject;
import org.eclipse.escet.setext.typechecker.Message;
import org.eclipse.escet.setext.typechecker.SeTextTypeChecker;

public class SymbolTable {
    private final Map<String, SeTextObject> table = Maps.map();
    private final SeTextTypeChecker tchecker;

    public SymbolTable(SeTextTypeChecker tchecker) {
        this.tchecker = tchecker;
    }

    public void add(String name, SeTextObject value) {
        Assert.notNull((Object)name);
        Assert.notNull((Object)value);
        if (this.table.containsKey(name)) {
            this.tchecker.addProblem(Message.SYMTABLE_DUPL_DECL, this.get((String)name).position, name);
            this.tchecker.addProblem(Message.SYMTABLE_DUPL_DECL, value.position, name);
            throw new SemanticException();
        }
        this.table.put(name, value);
    }

    public boolean contains(String name) {
        return this.table.containsKey(name);
    }

    public SeTextObject get(String name) {
        Assert.check((boolean)this.table.containsKey(name));
        return this.table.get(name);
    }
}

