/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.common;

import java.util.List;
import java.util.Set;
import org.eclipse.escet.cif.common.CifEventUtils;
import org.eclipse.escet.cif.common.CifValueUtils;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Edge;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeEvent;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.automata.impl.EdgeEventImpl;
import org.eclipse.escet.cif.metamodel.cif.automata.impl.EdgeReceiveImpl;
import org.eclipse.escet.cif.metamodel.cif.automata.impl.EdgeSendImpl;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.LocationExpression;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.java.CifConstructors;
import org.eclipse.escet.common.emf.EMFHelper;
import org.eclipse.escet.common.java.Lists;

public class CifGuardUtils {
    private CifGuardUtils() {
    }

    public static List<Expression> mergeGuards(List<Automaton> automata, List<Set<Event>> syncAlphabets, List<Set<Event>> sendAlphabets, List<Set<Event>> recvAlphabets, List<Set<Event>> moniAlphabets, List<Event> events, LocRefExprCreator creator) {
        List guards = Lists.listc((int)events.size());
        for (Event event : events) {
            List<Automaton> syncAuts = CifEventUtils.filterAutomata(automata, syncAlphabets, event);
            List<Automaton> sendAuts = CifEventUtils.filterAutomata(automata, sendAlphabets, event);
            List<Automaton> recvAuts = CifEventUtils.filterAutomata(automata, recvAlphabets, event);
            Set<Automaton> moniAuts = CifEventUtils.filterMonitorAuts(automata, moniAlphabets, event);
            Expression guard = CifGuardUtils.mergeGuards(syncAuts, sendAuts, recvAuts, moniAuts, event, creator);
            guards.add(guard);
        }
        return guards;
    }

    public static Expression mergeGuards(List<Automaton> syncAuts, List<Automaton> sendAuts, List<Automaton> recvAuts, Set<Automaton> moniAuts, Event event, LocRefExprCreator creator) {
        int count = syncAuts.size();
        if (event.getType() != null) {
            count += 2;
        }
        List syncGuards = Lists.listc((int)count);
        if (event.getType() != null) {
            List sendGuards = Lists.listc((int)sendAuts.size());
            for (Automaton aut : sendAuts) {
                sendGuards.add(CifGuardUtils.mergeGuards(aut, event, EdgeSendImpl.class, creator));
            }
            List recvGuards = Lists.listc((int)recvAuts.size());
            for (Automaton aut : recvAuts) {
                recvGuards.add(CifGuardUtils.mergeGuards(aut, event, EdgeReceiveImpl.class, creator));
            }
            syncGuards.add(CifValueUtils.createDisjunction(sendGuards));
            syncGuards.add(CifValueUtils.createDisjunction(recvGuards));
        }
        for (Automaton aut : syncAuts) {
            if (moniAuts.contains(aut)) {
                syncGuards.add(CifValueUtils.makeTrue());
                continue;
            }
            syncGuards.add(CifGuardUtils.mergeGuards(aut, event, EdgeEventImpl.class, creator));
        }
        return CifValueUtils.createConjunction(syncGuards);
    }

    public static Expression mergeGuards(Automaton aut, Event event, Class<? extends EdgeEvent> edgeClass, LocRefExprCreator creator) {
        List locsGuards = Lists.list();
        for (Location loc : aut.getLocations()) {
            List edgesGuards = Lists.list();
            for (Edge edge : loc.getEdges()) {
                boolean match = false;
                for (EdgeEvent edgeEvent : edge.getEvents()) {
                    Event e;
                    if (edgeEvent.getClass() != edgeClass || (e = CifEventUtils.getEventFromEdgeEvent(edgeEvent)) != event) continue;
                    match = true;
                    break;
                }
                if (!match) continue;
                Expression edgeGuard = CifValueUtils.createConjunction(EMFHelper.deepclone((List)edge.getGuards()));
                edgesGuards.add(edgeGuard);
            }
            Expression edgesGuard = CifValueUtils.createDisjunction(edgesGuards);
            Expression locRef = creator.create(loc);
            locsGuards.add(CifValueUtils.createConjunction(Lists.list((Object[])new Expression[]{locRef, edgesGuard})));
        }
        return CifValueUtils.createDisjunction(locsGuards);
    }

    private static class CifLocRefExprCreator
    implements LocRefExprCreator {
        private CifLocRefExprCreator() {
        }

        @Override
        public Expression create(Location loc) {
            if (loc.getName() == null) {
                return CifValueUtils.makeTrue();
            }
            LocationExpression locRef = CifConstructors.newLocationExpression();
            locRef.setLocation(loc);
            locRef.setType((CifType)CifConstructors.newBoolType());
            return locRef;
        }
    }

    public static interface LocRefExprCreator {
        public static final LocRefExprCreator DEFAULT = new CifLocRefExprCreator();

        public Expression create(Location var1);
    }
}

