/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.checkers.checks.invcheck;

import java.util.EnumSet;
import org.eclipse.escet.cif.checkers.checks.invcheck.NoKindInterface;
import org.eclipse.escet.cif.checkers.checks.invcheck.PlaceKind;
import org.eclipse.escet.cif.checkers.checks.invcheck.SubSetRelation;

public enum NoInvariantPlaceKind implements NoKindInterface<PlaceKind>
{
    ALL_PLACES(EnumSet.allOf(PlaceKind.class), null),
    LOCATIONS(EnumSet.of(PlaceKind.LOCATION), "in a location"),
    COMPONENTS(EnumSet.of(PlaceKind.COMPONENT), "in a component");

    public static final int NUMBER_OF_VALUES;
    private final EnumSet<PlaceKind> disallowedValues;
    private final String reportText;

    static {
        NUMBER_OF_VALUES = PlaceKind.values().length;
    }

    private NoInvariantPlaceKind(EnumSet<PlaceKind> disallowedValues, String reportText) {
        this.disallowedValues = disallowedValues;
        this.reportText = reportText;
    }

    @Override
    public boolean isDisallowed(PlaceKind value) {
        return this.disallowedValues.contains((Object)value);
    }

    public SubSetRelation compareSubset(NoInvariantPlaceKind right) {
        return SubSetRelation.compare(this.disallowedValues, right.disallowedValues);
    }

    @Override
    public String getReportText() {
        return this.reportText;
    }
}

