/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.tooldef.runtime.builtins;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.tooldef.runtime.ToolDefException;
import org.eclipse.escet.tooldef.runtime.ToolDefList;
import org.eclipse.escet.tooldef.runtime.ToolDefMap;
import org.eclipse.escet.tooldef.runtime.ToolDefRuntimeUtils;
import org.eclipse.escet.tooldef.runtime.ToolDefSet;

public class BuiltInOperators {
    private BuiltInOperators() {
    }

    public static boolean not(boolean arg) {
        return !arg;
    }

    public static boolean and(boolean left, boolean right) {
        throw new UnsupportedOperationException();
    }

    public static <T> Set<T> and(Set<T> left, Set<T> right) {
        ToolDefSet<T> rslt = new ToolDefSet<T>(left);
        rslt.retainAll(right);
        return rslt;
    }

    public static boolean or(boolean left, boolean right) {
        throw new UnsupportedOperationException();
    }

    public static <T> Set<T> or(Set<T> left, Set<T> right) {
        ToolDefSet<T> rslt = new ToolDefSet<T>(left);
        rslt.addAll(right);
        return rslt;
    }

    public static int plus(int arg) {
        return arg;
    }

    public static long plus(long arg) {
        return arg;
    }

    public static double plus(double arg) {
        return arg;
    }

    public static int plus(int left, int right) {
        if (right > 0 ? left > Integer.MAX_VALUE - right : left < Integer.MIN_VALUE - right) {
            String msg = Strings.fmt((String)"Integer number overflow: %s + %s.", (Object[])new Object[]{ToolDefRuntimeUtils.valueToStr(left), ToolDefRuntimeUtils.valueToStr(right)});
            throw new ToolDefException(msg);
        }
        return left + right;
    }

    public static long plus(long left, long right) {
        if (right > 0L ? left > Long.MAX_VALUE - right : left < Long.MIN_VALUE - right) {
            String msg = Strings.fmt((String)"Long number overflow: %s + %s.", (Object[])new Object[]{ToolDefRuntimeUtils.valueToStr(left), ToolDefRuntimeUtils.valueToStr(right)});
            throw new ToolDefException(msg);
        }
        return left + right;
    }

    public static double plus(double left, double right) {
        double rslt = left + right;
        if (Double.isInfinite(rslt)) {
            String msg = Strings.fmt((String)"Double number overflow: %s + %s.", (Object[])new Object[]{ToolDefRuntimeUtils.valueToStr(left), ToolDefRuntimeUtils.valueToStr(right)});
            throw new ToolDefException(msg);
        }
        return rslt == -0.0 ? 0.0 : rslt;
    }

    public static String plus(String left, String right) {
        return left + right;
    }

    public static <T> List<T> plus(List<T> left, List<T> right) {
        ToolDefList<T> rslt = new ToolDefList<T>(left.size() + right.size());
        rslt.addAll(left);
        rslt.addAll(right);
        return rslt;
    }

    public static <K, V> Map<K, V> plus(Map<K, V> left, Map<K, V> right) {
        ToolDefMap<K, V> rslt = new ToolDefMap<K, V>(left);
        rslt.putAll(right);
        return rslt;
    }

    public static int dash(int arg) {
        if (arg == Integer.MIN_VALUE) {
            String msg = Strings.fmt((String)"Integer number overflow: -%s.", (Object[])new Object[]{ToolDefRuntimeUtils.valueToStr(arg)});
            throw new ToolDefException(msg);
        }
        return -arg;
    }

    public static long dash(long arg) {
        if (arg == Long.MIN_VALUE) {
            String msg = Strings.fmt((String)"Long number overflow: -%s.", (Object[])new Object[]{ToolDefRuntimeUtils.valueToStr(arg)});
            throw new ToolDefException(msg);
        }
        return -arg;
    }

    public static double dash(double arg) {
        return arg == 0.0 ? 0.0 : -arg;
    }

    public static int dash(int left, int right) {
        if (right > 0 ? left < Integer.MIN_VALUE + right : left > Integer.MAX_VALUE + right) {
            String msg = Strings.fmt((String)"Integer number overflow: %s - %s.", (Object[])new Object[]{ToolDefRuntimeUtils.valueToStr(left), ToolDefRuntimeUtils.valueToStr(right)});
            throw new ToolDefException(msg);
        }
        return left - right;
    }

    public static long dash(long left, long right) {
        if (right > 0L ? left < Long.MIN_VALUE + right : left > Long.MAX_VALUE + right) {
            String msg = Strings.fmt((String)"Long number overflow: %s - %s.", (Object[])new Object[]{ToolDefRuntimeUtils.valueToStr(left), ToolDefRuntimeUtils.valueToStr(right)});
            throw new ToolDefException(msg);
        }
        return left - right;
    }

    public static double dash(double left, double right) {
        double rslt = left - right;
        if (Double.isInfinite(rslt)) {
            String msg = Strings.fmt((String)"Double number overflow: %s - %s.", (Object[])new Object[]{ToolDefRuntimeUtils.valueToStr(left), ToolDefRuntimeUtils.valueToStr(right)});
            throw new ToolDefException(msg);
        }
        return rslt == -0.0 ? 0.0 : rslt;
    }

    public static <T> Set<T> dash(Set<T> left, Set<T> right) {
        ToolDefSet<T> rslt = new ToolDefSet<T>(left);
        rslt.removeAll(right);
        return rslt;
    }

    public static <K, V> Map<K, V> dash(Map<K, V> left, List<K> right) {
        ToolDefMap<K, V> rslt = new ToolDefMap<K, V>(left);
        for (K k : right) {
            rslt.remove(k);
        }
        return rslt;
    }

    public static <K, V> Map<K, V> dash(Map<K, V> left, Set<K> right) {
        ToolDefMap<K, V> rslt = new ToolDefMap<K, V>(left);
        for (K k : right) {
            rslt.remove(k);
        }
        return rslt;
    }

    public static <K, V, V2> Map<K, V> dash(Map<K, V> left, Map<K, V2> right) {
        ToolDefMap<K, V> rslt = new ToolDefMap<K, V>(left);
        for (K k : right.keySet()) {
            rslt.remove(k);
        }
        return rslt;
    }

    public static int star(int left, int right) {
        if (right > 0 ? left > Integer.MAX_VALUE / right || left < Integer.MIN_VALUE / right : (right < -1 ? left > Integer.MIN_VALUE / right || left < Integer.MAX_VALUE / right : right == -1 && left == Integer.MIN_VALUE)) {
            String msg = Strings.fmt((String)"Integer number overflow: %s * %s.", (Object[])new Object[]{ToolDefRuntimeUtils.valueToStr(left), ToolDefRuntimeUtils.valueToStr(right)});
            throw new ToolDefException(msg);
        }
        return left * right;
    }

    public static long star(long left, long right) {
        if (right > 0L ? left > Long.MAX_VALUE / right || left < Long.MIN_VALUE / right : (right < -1L ? left > Long.MIN_VALUE / right || left < Long.MAX_VALUE / right : right == -1L && left == Long.MIN_VALUE)) {
            String msg = Strings.fmt((String)"Long number overflow: %s * %s.", (Object[])new Object[]{ToolDefRuntimeUtils.valueToStr(left), ToolDefRuntimeUtils.valueToStr(right)});
            throw new ToolDefException(msg);
        }
        return left * right;
    }

    public static double star(double left, double right) {
        double rslt = left * right;
        if (Double.isInfinite(rslt)) {
            String msg = Strings.fmt((String)"Double number overflow: %s * %s.", (Object[])new Object[]{ToolDefRuntimeUtils.valueToStr(left), ToolDefRuntimeUtils.valueToStr(right)});
            throw new ToolDefException(msg);
        }
        return rslt == -0.0 ? 0.0 : rslt;
    }

    public static double slash(double left, double right) {
        if (right == 0.0) {
            String msg = Strings.fmt((String)"Division by zero: %s / %s.", (Object[])new Object[]{ToolDefRuntimeUtils.valueToStr(left), ToolDefRuntimeUtils.valueToStr(right)});
            throw new ToolDefException(msg);
        }
        double rslt = left / right;
        if (Double.isInfinite(rslt)) {
            String msg = Strings.fmt((String)"Double number overflow: %s * %s.", (Object[])new Object[]{ToolDefRuntimeUtils.valueToStr(left), ToolDefRuntimeUtils.valueToStr(right)});
            throw new ToolDefException(msg);
        }
        return rslt == -0.0 ? 0.0 : rslt;
    }

    public static int div(int left, int right) {
        if (right == 0) {
            String msg = Strings.fmt((String)"Division by zero: %s div %s.", (Object[])new Object[]{ToolDefRuntimeUtils.valueToStr(left), ToolDefRuntimeUtils.valueToStr(right)});
            throw new ToolDefException(msg);
        }
        if (left == Integer.MIN_VALUE && right == -1) {
            String msg = Strings.fmt((String)"Integer number overflow: %s div %s.", (Object[])new Object[]{ToolDefRuntimeUtils.valueToStr(left), ToolDefRuntimeUtils.valueToStr(right)});
            throw new ToolDefException(msg);
        }
        return left / right;
    }

    public static long div(long left, long right) {
        if (right == 0L) {
            String msg = Strings.fmt((String)"Division by zero: %s div %s.", (Object[])new Object[]{ToolDefRuntimeUtils.valueToStr(left), ToolDefRuntimeUtils.valueToStr(right)});
            throw new ToolDefException(msg);
        }
        if (left == Long.MIN_VALUE && right == -1L) {
            String msg = Strings.fmt((String)"Long number overflow: %s div %s.", (Object[])new Object[]{ToolDefRuntimeUtils.valueToStr(left), ToolDefRuntimeUtils.valueToStr(right)});
            throw new ToolDefException(msg);
        }
        return left / right;
    }

    public static int mod(int left, int right) {
        if (right == 0) {
            String msg = Strings.fmt((String)"Division by zero: %s mod %s.", (Object[])new Object[]{ToolDefRuntimeUtils.valueToStr(left), ToolDefRuntimeUtils.valueToStr(right)});
            throw new ToolDefException(msg);
        }
        return left % right;
    }

    public static long mod(long left, long right) {
        if (right == 0L) {
            String msg = Strings.fmt((String)"Division by zero: %s mod %s.", (Object[])new Object[]{ToolDefRuntimeUtils.valueToStr(left), ToolDefRuntimeUtils.valueToStr(right)});
            throw new ToolDefException(msg);
        }
        return left % right;
    }

    public static boolean lt(int left, int right) {
        return left < right;
    }

    public static boolean lt(long left, long right) {
        return left < right;
    }

    public static boolean lt(double left, double right) {
        return left < right;
    }

    public static boolean le(int left, int right) {
        return left <= right;
    }

    public static boolean le(long left, long right) {
        return left <= right;
    }

    public static boolean le(double left, double right) {
        return left <= right;
    }

    public static boolean gt(int left, int right) {
        return left > right;
    }

    public static boolean gt(long left, long right) {
        return left > right;
    }

    public static boolean gt(double left, double right) {
        return left > right;
    }

    public static boolean ge(int left, int right) {
        return left >= right;
    }

    public static boolean ge(long left, long right) {
        return left >= right;
    }

    public static boolean ge(double left, double right) {
        return left >= right;
    }

    public static <T> boolean eq(T left, T right) {
        return ToolDefRuntimeUtils.equalValues(left, right);
    }

    public static <T> boolean ne(T left, T right) {
        return !ToolDefRuntimeUtils.equalValues(left, right);
    }
}

