/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.server.backchannel.connection.server;

import org.eclipse.emf.emfstore.server.backchannel.BackchannelInterface;
import org.eclipse.emf.emfstore.server.backchannel.connection.server.XmlRpcBackchannelConnectionHandler;
import org.eclipse.emf.emfstore.server.backchannel.connection.server.XmlRpcBackchannelInterface;
import org.eclipse.emf.emfstore.server.eventmanager.EMFStoreEventListener;
import org.eclipse.emf.emfstore.server.exceptions.EmfStoreException;
import org.eclipse.emf.emfstore.server.model.ProjectId;
import org.eclipse.emf.emfstore.server.model.SessionId;
import org.eclipse.emf.emfstore.server.model.versioning.events.server.ServerEvent;

public class XmlRpcBackchannelImpl
implements XmlRpcBackchannelInterface {
    private static final long serialVersionUID = 2220637232248810383L;

    private BackchannelInterface getBackchannel() {
        return XmlRpcBackchannelConnectionHandler.getBackChannel();
    }

    public ServerEvent getEvent(SessionId sessionId, ProjectId projectId) throws EmfStoreException {
        AsyncListener listener = new AsyncListener();
        this.getBackchannel().registerRemoteListener(sessionId, listener, projectId);
        return listener.getEvent(-1L);
    }

    public void sendEvent(SessionId sessionId, ServerEvent serverEvent, ProjectId projectId) throws EmfStoreException {
        this.getBackchannel().sendEvent(sessionId, serverEvent, projectId);
    }

    private final class AsyncListener
    implements EMFStoreEventListener {
        private static final int NOTIMEOUT = -1;
        private ServerEvent event;

        private AsyncListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean handleEvent(ServerEvent event) {
            this.event = event;
            AsyncListener asyncListener = this;
            synchronized (asyncListener) {
                this.notifyAll();
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ServerEvent getEvent(long timeout) {
            AsyncListener asyncListener = this;
            synchronized (asyncListener) {
                try {
                    if (timeout == -1L) {
                        this.wait();
                    } else {
                        this.wait(timeout);
                    }
                    ServerEvent tmp = this.event;
                    this.event = null;
                    return tmp;
                }
                catch (InterruptedException e) {
                    return null;
                }
            }
        }
    }
}

