/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.model.impl;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.UUID;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.emfstore.client.model.Configuration;
import org.eclipse.emf.emfstore.common.model.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoSplitAndSaveResourceContainmentList<T extends EObject>
implements List<T> {
    private static final String ROOT_NAME = "root";
    private static final int MAX_CAPACITY = 30;
    private static final int MAX_FILE_SIZE = 100000;
    private final EList<T> list;
    private Resource currentResource;
    private int currentResourceElementCount;
    private final ResourceSet resourceSet;
    private final String path;
    private final String extension;
    private Resource rootResource;
    private HashSet<Resource> dirtyResourceSet;

    public AutoSplitAndSaveResourceContainmentList(EObject root, EList<T> list, ResourceSet resourceSet, String path, String extension) {
        if (list == null || resourceSet == null || path == null || extension == null || root == null) {
            throw new IllegalArgumentException();
        }
        this.resourceSet = resourceSet;
        this.dirtyResourceSet = new HashSet();
        this.path = path;
        this.extension = extension;
        this.list = list;
        Resource eResource = root.eResource();
        if (eResource == null) {
            URI fileURI = URI.createFileURI((String)(String.valueOf(path) + File.separatorChar + ROOT_NAME + extension));
            this.rootResource = resourceSet.createResource(fileURI);
            this.rootResource.getContents().add((Object)root);
            this.markAsDirty(this.rootResource);
            this.saveDirtyResources();
        } else {
            this.rootResource = eResource;
        }
        this.initCurrentResource(resourceSet);
    }

    private void saveDirtyResources() {
        if (Configuration.isAutoSaveEnabled()) {
            this.save();
        }
    }

    private void initCurrentResource(ResourceSet resourceSet) {
        this.currentResource = this.createRandomResource(resourceSet, this.path);
        this.currentResourceElementCount = 0;
    }

    private Resource createRandomResource(ResourceSet resourceSet, String path) {
        URI fileURI = URI.createFileURI((String)(String.valueOf(path) + File.separatorChar + UUID.randomUUID().toString() + this.extension));
        return resourceSet.createResource(fileURI);
    }

    @Override
    public void add(int index, T element) {
        this.addToResource(element);
        this.list.add(index, element);
        this.markAsDirty(this.rootResource);
        this.saveDirtyResources();
    }

    @Override
    public boolean add(T o) {
        this.addToResource(o);
        boolean result = this.list.add(o);
        this.markAsDirty(this.rootResource);
        this.saveDirtyResources();
        return result;
    }

    private void addToResource(T o) {
        if (o.eResource() != null) {
            return;
        }
        URI uri = this.currentResource.getURI();
        File file = new File(uri.toFileString());
        if (this.currentResourceElementCount > 30 || file.length() > 100000L) {
            this.currentResource = this.createRandomResource(this.resourceSet, this.path);
            this.currentResourceElementCount = 0;
        }
        this.currentResource.getContents().add(o);
        this.markAsDirty(this.currentResource);
        ++this.currentResourceElementCount;
    }

    private void removeFromResource(EObject o) {
        Resource eResource = o.eResource();
        if (eResource == null) {
            return;
        }
        eResource.getContents().remove((Object)o);
        this.markAsDirty(eResource);
        if (eResource == this.currentResource) {
            --this.currentResourceElementCount;
        }
    }

    private void markAsDirty(Resource resource) {
        this.dirtyResourceSet.add(resource);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        for (EObject element : c) {
            this.addToResource(element);
        }
        boolean result = this.list.addAll(c);
        this.markAsDirty(this.rootResource);
        this.saveDirtyResources();
        return result;
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        for (EObject element : c) {
            this.addToResource(element);
        }
        boolean result = this.list.addAll(index, c);
        this.markAsDirty(this.rootResource);
        this.saveDirtyResources();
        return result;
    }

    @Override
    public void clear() {
        this.list.clear();
        File dir = new File(this.path);
        File[] listFiles = dir.listFiles();
        if (listFiles != null) {
            File[] fileArray = listFiles;
            int n = listFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (!file.isDirectory() && file.getName().endsWith(this.extension) && !file.getName().endsWith(ROOT_NAME + this.extension)) {
                    file.delete();
                }
                ++n2;
            }
        }
        this.initCurrentResource(this.resourceSet);
        this.markAsDirty(this.rootResource);
        this.saveDirtyResources();
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.list.containsAll(c);
    }

    @Override
    public T get(int index) {
        return (T)((EObject)this.list.get(index));
    }

    @Override
    public int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return this.list.iterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.list.lastIndexOf(o);
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.list.listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return this.list.listIterator(index);
    }

    @Override
    public T remove(int index) {
        EObject t = (EObject)this.list.remove(index);
        this.removeFromResource(t);
        this.markAsDirty(this.rootResource);
        this.saveDirtyResources();
        return (T)t;
    }

    @Override
    public boolean remove(Object o) {
        boolean remove = this.list.remove(o);
        if (o instanceof EObject) {
            this.removeFromResource((EObject)o);
        }
        this.markAsDirty(this.rootResource);
        this.saveDirtyResources();
        return remove;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean result = this.list.removeAll(c);
        for (Object o : c) {
            if (!(o instanceof EObject)) continue;
            this.removeFromResource((EObject)o);
        }
        this.markAsDirty(this.rootResource);
        this.saveDirtyResources();
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        HashSet<T> removedElements = new HashSet<T>();
        removedElements.addAll((Collection<T>)this.list);
        removedElements.removeAll(c);
        boolean result = this.list.retainAll(c);
        for (Object o : removedElements) {
            if (!(o instanceof EObject)) continue;
            this.removeFromResource((EObject)o);
        }
        this.markAsDirty(this.rootResource);
        this.saveDirtyResources();
        return result;
    }

    public void save() {
        for (Resource res : this.dirtyResourceSet) {
            try {
                res.save(ModelUtil.getResourceSaveOptions());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.dirtyResourceSet.clear();
    }

    @Override
    public T set(int index, T element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        return this.list.subList(fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <D> D[] toArray(D[] a) {
        return this.list.toArray((Object[])a);
    }
}

