/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.model.connectionmanager.xmlrpc;

import java.util.List;
import org.eclipse.emf.emfstore.client.model.ServerInfo;
import org.eclipse.emf.emfstore.client.model.connectionmanager.AbstractConnectionManager;
import org.eclipse.emf.emfstore.client.model.connectionmanager.ConnectionManager;
import org.eclipse.emf.emfstore.client.model.connectionmanager.xmlrpc.XmlRpcClientManager;
import org.eclipse.emf.emfstore.common.model.EMFStoreProperty;
import org.eclipse.emf.emfstore.common.model.Project;
import org.eclipse.emf.emfstore.server.exceptions.EmfStoreException;
import org.eclipse.emf.emfstore.server.exceptions.InvalidVersionSpecException;
import org.eclipse.emf.emfstore.server.filetransfer.FileChunk;
import org.eclipse.emf.emfstore.server.filetransfer.FileTransferInformation;
import org.eclipse.emf.emfstore.server.model.ClientVersionInfo;
import org.eclipse.emf.emfstore.server.model.ProjectHistory;
import org.eclipse.emf.emfstore.server.model.ProjectId;
import org.eclipse.emf.emfstore.server.model.ProjectInfo;
import org.eclipse.emf.emfstore.server.model.SessionId;
import org.eclipse.emf.emfstore.server.model.accesscontrol.ACOrgUnitId;
import org.eclipse.emf.emfstore.server.model.accesscontrol.ACUser;
import org.eclipse.emf.emfstore.server.model.accesscontrol.OrgUnitProperty;
import org.eclipse.emf.emfstore.server.model.versioning.ChangePackage;
import org.eclipse.emf.emfstore.server.model.versioning.HistoryInfo;
import org.eclipse.emf.emfstore.server.model.versioning.HistoryQuery;
import org.eclipse.emf.emfstore.server.model.versioning.LogMessage;
import org.eclipse.emf.emfstore.server.model.versioning.PrimaryVersionSpec;
import org.eclipse.emf.emfstore.server.model.versioning.TagVersionSpec;
import org.eclipse.emf.emfstore.server.model.versioning.VersionSpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlRpcConnectionManager
extends AbstractConnectionManager<XmlRpcClientManager>
implements ConnectionManager {
    @Override
    public SessionId logIn(String username, String password, ServerInfo serverInfo, ClientVersionInfo clientVersionInfo) throws EmfStoreException {
        XmlRpcClientManager clientManager = new XmlRpcClientManager("EmfStore");
        clientManager.initConnection(serverInfo);
        SessionId id = clientManager.callWithResult("logIn", SessionId.class, username, password, clientVersionInfo);
        this.addConnectionProxy(id, clientManager);
        return id;
    }

    @Override
    public void logout(SessionId sessionId) throws EmfStoreException {
        ((XmlRpcClientManager)this.getConnectionProxy(sessionId)).call("logout", sessionId);
        this.removeConnectionProxy(sessionId);
    }

    public void addTag(SessionId sessionId, ProjectId projectId, PrimaryVersionSpec versionSpec, TagVersionSpec tag) throws EmfStoreException {
        ((XmlRpcClientManager)this.getConnectionProxy(sessionId)).call("addTag", sessionId, projectId, versionSpec, tag);
    }

    public ProjectInfo createEmptyProject(SessionId sessionId, String name, String description, LogMessage logMessage) throws EmfStoreException {
        return ((XmlRpcClientManager)this.getConnectionProxy(sessionId)).callWithResult("createEmptyProject", ProjectInfo.class, sessionId, name, description, logMessage);
    }

    public ProjectInfo createProject(SessionId sessionId, String name, String description, LogMessage logMessage, Project project) throws EmfStoreException {
        return ((XmlRpcClientManager)this.getConnectionProxy(sessionId)).callWithResult("createProject", ProjectInfo.class, sessionId, name, description, logMessage, project);
    }

    public PrimaryVersionSpec createVersion(SessionId sessionId, ProjectId projectId, PrimaryVersionSpec baseVersionSpec, ChangePackage changePackage, LogMessage logMessage) throws EmfStoreException, InvalidVersionSpecException {
        return ((XmlRpcClientManager)this.getConnectionProxy(sessionId)).callWithResult("createVersion", PrimaryVersionSpec.class, sessionId, projectId, baseVersionSpec, changePackage, logMessage);
    }

    public void deleteProject(SessionId sessionId, ProjectId projectId, boolean deleteFiles) throws EmfStoreException {
        ((XmlRpcClientManager)this.getConnectionProxy(sessionId)).call("deleteProject", sessionId, projectId, deleteFiles);
    }

    public FileChunk downloadFileChunk(SessionId sessionId, ProjectId projectId, FileTransferInformation fileInformation) throws EmfStoreException {
        return ((XmlRpcClientManager)this.getConnectionProxy(sessionId)).callWithResult("downloadFileChunk", FileChunk.class, sessionId, projectId, fileInformation);
    }

    public ProjectHistory exportProjectHistoryFromServer(SessionId sessionId, ProjectId projectId) throws EmfStoreException {
        return ((XmlRpcClientManager)this.getConnectionProxy(sessionId)).callWithResult("exportProjectHistoryFromServer", ProjectHistory.class, sessionId, projectId);
    }

    public List<ChangePackage> getChanges(SessionId sessionId, ProjectId projectId, VersionSpec source, VersionSpec target) throws EmfStoreException {
        return ((XmlRpcClientManager)this.getConnectionProxy(sessionId)).callWithListResult("getChanges", ChangePackage.class, sessionId, projectId, source, target);
    }

    public List<HistoryInfo> getHistoryInfo(SessionId sessionId, ProjectId projectId, HistoryQuery historyQuery) throws EmfStoreException {
        return ((XmlRpcClientManager)this.getConnectionProxy(sessionId)).callWithListResult("getHistoryInfo", HistoryInfo.class, sessionId, projectId, historyQuery);
    }

    public Project getProject(SessionId sessionId, ProjectId projectId, VersionSpec versionSpec) throws EmfStoreException {
        return ((XmlRpcClientManager)this.getConnectionProxy(sessionId)).callWithResult("getProject", Project.class, sessionId, projectId, versionSpec);
    }

    public List<ProjectInfo> getProjectList(SessionId sessionId) throws EmfStoreException {
        return ((XmlRpcClientManager)this.getConnectionProxy(sessionId)).callWithListResult("getProjectList", ProjectInfo.class, sessionId);
    }

    public ProjectId importProjectHistoryToServer(SessionId sessionId, ProjectHistory projectHistory) throws EmfStoreException {
        return ((XmlRpcClientManager)this.getConnectionProxy(sessionId)).callWithResult("importProjectHistoryToServer", ProjectId.class, sessionId, projectHistory);
    }

    public void removeTag(SessionId sessionId, ProjectId projectId, PrimaryVersionSpec versionSpec, TagVersionSpec tag) throws EmfStoreException {
        ((XmlRpcClientManager)this.getConnectionProxy(sessionId)).call("removeTag", sessionId, projectId, versionSpec, tag);
    }

    public ACUser resolveUser(SessionId sessionId, ACOrgUnitId id) throws EmfStoreException {
        return ((XmlRpcClientManager)this.getConnectionProxy(sessionId)).callWithResult("resolveUser", ACUser.class, sessionId, id);
    }

    public PrimaryVersionSpec resolveVersionSpec(SessionId sessionId, ProjectId projectId, VersionSpec versionSpec) throws EmfStoreException {
        return ((XmlRpcClientManager)this.getConnectionProxy(sessionId)).callWithResult("resolveVersionSpec", PrimaryVersionSpec.class, sessionId, projectId, versionSpec);
    }

    public void transmitProperty(SessionId sessionId, OrgUnitProperty changedProperty, ACUser tmpUser, ProjectId projectId) throws EmfStoreException {
        ((XmlRpcClientManager)this.getConnectionProxy(sessionId)).call("transmitProperty", sessionId, changedProperty, tmpUser, projectId);
    }

    public FileTransferInformation uploadFileChunk(SessionId sessionId, ProjectId projectId, FileChunk fileChunk) throws EmfStoreException {
        return ((XmlRpcClientManager)this.getConnectionProxy(sessionId)).callWithResult("uploadFileChunk", FileTransferInformation.class, sessionId, projectId, fileChunk);
    }

    public List<EMFStoreProperty> setEMFProperties(SessionId sessionId, List<EMFStoreProperty> properties, ProjectId projectId) throws EmfStoreException {
        return ((XmlRpcClientManager)this.getConnectionProxy(sessionId)).callWithListResult("setEMFProperties", EMFStoreProperty.class, sessionId, properties, projectId);
    }

    public List<EMFStoreProperty> getEMFProperties(SessionId sessionId, ProjectId projectId) throws EmfStoreException {
        return ((XmlRpcClientManager)this.getConnectionProxy(sessionId)).callWithListResult("getEMFProperties", EMFStoreProperty.class, sessionId, projectId);
    }

    @Override
    public boolean isLoggedIn(SessionId id) {
        return this.hasConnectionProxy(id);
    }
}

