/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.model.changeTracking.commands;

import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.emfstore.client.model.changeTracking.commands.CommandObserver;
import org.eclipse.emf.emfstore.client.model.changeTracking.commands.EMFStoreCommandNotifier;
import org.eclipse.emf.emfstore.client.model.changeTracking.commands.EMFStoreCommandStack;

public class EMFStoreBasicCommandStack
extends BasicCommandStack
implements EMFStoreCommandStack {
    private EMFStoreCommandNotifier notifier = new EMFStoreCommandNotifier();
    private Command currentCommand;

    protected void handleError(Exception exception) {
        this.notifier.notifiyListenersAboutCommandFailed(this.currentCommand, exception);
        this.currentCommand = null;
        super.handleError(exception);
    }

    public void execute(Command command) {
        if (this.currentCommand == null) {
            this.currentCommand = command;
            this.notifier.notifiyListenersAboutStart(command);
        }
        super.execute(command);
        if (this.currentCommand == command) {
            if (this.mostRecentCommand == command) {
                this.notifier.notifiyListenersAboutCommandCompleted(command);
            }
            this.currentCommand = null;
        }
    }

    public void addCommandStackObserver(CommandObserver observer) {
        this.notifier.addCommandStackObserver(observer);
    }

    public void removeCommandStackObserver(CommandObserver observer) {
        this.notifier.removeCommandStackObserver(observer);
    }
}

