/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.model;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.emfstore.client.model.Configuration;
import org.eclipse.emf.emfstore.client.model.ModelFactory;
import org.eclipse.emf.emfstore.client.model.ModelPackage;
import org.eclipse.emf.emfstore.client.model.PostWorkspaceInitiator;
import org.eclipse.emf.emfstore.client.model.ProjectSpace;
import org.eclipse.emf.emfstore.client.model.ServerInfo;
import org.eclipse.emf.emfstore.client.model.Usersession;
import org.eclipse.emf.emfstore.client.model.Workspace;
import org.eclipse.emf.emfstore.client.model.changeTracking.commands.EMFStoreBasicCommandStack;
import org.eclipse.emf.emfstore.client.model.connectionmanager.AdminConnectionManager;
import org.eclipse.emf.emfstore.client.model.connectionmanager.ConnectionManager;
import org.eclipse.emf.emfstore.client.model.connectionmanager.KeyStoreManager;
import org.eclipse.emf.emfstore.client.model.connectionmanager.SessionManager;
import org.eclipse.emf.emfstore.client.model.connectionmanager.xmlrpc.XmlRpcAdminConnectionManager;
import org.eclipse.emf.emfstore.client.model.connectionmanager.xmlrpc.XmlRpcConnectionManager;
import org.eclipse.emf.emfstore.client.model.observers.DeleteProjectSpaceObserver;
import org.eclipse.emf.emfstore.client.model.util.EMFStoreCommand;
import org.eclipse.emf.emfstore.client.model.util.EditingDomainProvider;
import org.eclipse.emf.emfstore.client.model.util.WorkspaceUtil;
import org.eclipse.emf.emfstore.common.CommonUtil;
import org.eclipse.emf.emfstore.common.ResourceFactoryRegistry;
import org.eclipse.emf.emfstore.common.extensionpoint.ExtensionElement;
import org.eclipse.emf.emfstore.common.extensionpoint.ExtensionPoint;
import org.eclipse.emf.emfstore.common.extensionpoint.ExtensionPointException;
import org.eclipse.emf.emfstore.common.model.ModelVersion;
import org.eclipse.emf.emfstore.common.model.Project;
import org.eclipse.emf.emfstore.common.model.util.FileUtil;
import org.eclipse.emf.emfstore.common.model.util.MalformedModelVersionException;
import org.eclipse.emf.emfstore.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.common.observer.IObserver;
import org.eclipse.emf.emfstore.common.observer.ObserverBus;
import org.eclipse.emf.emfstore.migration.EMFStoreMigrationException;
import org.eclipse.emf.emfstore.migration.EMFStoreMigratorUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WorkspaceManager {
    private static WorkspaceManager instance;
    private Workspace currentWorkspace;
    private SessionManager sessionManager;
    private ObserverBus observerBus;
    private ConnectionManager connectionManager;
    private AdminConnectionManager adminConnectionManager;
    private ExtendedCrossReferenceAdapter crossReferenceAdapter;
    private ResourceSet resourceSet;

    public static synchronized WorkspaceManager getInstance() {
        if (instance == null) {
            try {
                instance = new WorkspaceManager();
                instance.initialize();
            }
            catch (RuntimeException e) {
                ModelUtil.logException((String)"Workspace Initialization failed, shutting down", (Throwable)e);
                throw e;
            }
            CommonUtil.getAllModelElementEClasses();
            instance.notifyPostWorkspaceInitiators();
        }
        return instance;
    }

    public static synchronized void destroy() {
        instance = null;
    }

    public static synchronized void init() {
        WorkspaceManager.getInstance();
    }

    private WorkspaceManager() {
    }

    private void initialize() {
        this.initializeObserverBus();
        this.connectionManager = this.initConnectionManager();
        this.adminConnectionManager = this.initAdminConnectionManager();
        this.currentWorkspace = this.initWorkSpace();
        this.sessionManager = new SessionManager();
    }

    private void initializeObserverBus() {
        this.observerBus = new ObserverBus();
        for (ExtensionElement element : new ExtensionPoint("org.eclipse.emf.emfstore.client.observers", true).getExtensionElements()) {
            try {
                this.observerBus.register((IObserver)element.getClass("ObserverClass", IObserver.class));
            }
            catch (ExtensionPointException e) {
                WorkspaceUtil.logException(e.getMessage(), (Exception)((Object)e));
            }
        }
    }

    private void notifyPostWorkspaceInitiators() {
        for (ExtensionElement element : new ExtensionPoint("org.eclipse.emf.emfstore.client.notify.postinit", true).getExtensionElements()) {
            try {
                ((PostWorkspaceInitiator)element.getClass("class", PostWorkspaceInitiator.class)).workspaceInitComplete(this.currentWorkspace);
            }
            catch (ExtensionPointException e) {
                WorkspaceUtil.logException(e.getMessage(), (Exception)((Object)e));
            }
        }
    }

    private ConnectionManager initConnectionManager() {
        KeyStoreManager.getInstance().setupKeys();
        return new XmlRpcConnectionManager();
    }

    private AdminConnectionManager initAdminConnectionManager() {
        return new XmlRpcAdminConnectionManager();
    }

    private Workspace initWorkSpace() {
        Workspace workspace;
        this.resourceSet = new ResourceSetImpl();
        this.resourceSet.setResourceFactoryRegistry((Resource.Factory.Registry)new ResourceFactoryRegistry());
        ((ResourceSetImpl)this.resourceSet).setURIResourceMap(new HashMap());
        this.resourceSet.getLoadOptions().putAll(ModelUtil.getResourceLoadOptions());
        boolean useCrossReferenceAdapter = false;
        for (ExtensionElement element : new ExtensionPoint("org.eclipse.emf.emfstore.client.inverseCrossReferenceCache").getExtensionElements()) {
            useCrossReferenceAdapter |= element.getBoolean("activated").booleanValue();
        }
        if (useCrossReferenceAdapter) {
            this.crossReferenceAdapter = new ExtendedCrossReferenceAdapter();
            this.resourceSet.eAdapters().add((Object)this.crossReferenceAdapter);
            WorkspaceManager.getObserverBus().register((IObserver)new DeleteProjectSpaceObserver(){

                public void projectSpaceDeleted(ProjectSpace projectSpace) {
                    WorkspaceManager.this.crossReferenceAdapter.unsetTarget((EObject)projectSpace);
                }
            });
        }
        Configuration.setEditingDomain(this.createEditingDomain(this.resourceSet));
        Configuration.setAutoSave(true);
        URI fileURI = URI.createFileURI((String)Configuration.getWorkspacePath());
        File workspaceFile = new File(Configuration.getWorkspacePath());
        if (!workspaceFile.exists()) {
            workspace = this.createNewWorkspace(this.resourceSet, fileURI);
        } else {
            this.migrateModel(this.resourceSet);
            Resource resource = this.resourceSet.createResource(fileURI);
            try {
                resource.load(ModelUtil.getResourceLoadOptions());
            }
            catch (IOException e) {
                WorkspaceUtil.logException("Error while loading workspace.", e);
            }
            EList directContents = resource.getContents();
            workspace = (Workspace)directContents.get(0);
        }
        workspace.setConnectionManager(this.connectionManager);
        workspace.setResourceSet(this.resourceSet);
        new EMFStoreCommand(){

            protected void doRun() {
                workspace.init();
            }
        }.run(true);
        return workspace;
    }

    private EditingDomain createEditingDomain(ResourceSet resourceSet) {
        EditingDomainProvider domainProvider = this.getDomainProvider();
        if (domainProvider != null) {
            return domainProvider.getEditingDomain(resourceSet);
        }
        AdapterFactoryEditingDomain domain = new AdapterFactoryEditingDomain((AdapterFactory)new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE), (CommandStack)new EMFStoreBasicCommandStack(), resourceSet);
        resourceSet.eAdapters().add((Object)new AdapterFactoryEditingDomain.EditingDomainProvider((EditingDomain)domain));
        return domain;
    }

    private EditingDomainProvider getDomainProvider() {
        return (EditingDomainProvider)new ExtensionPoint("org.eclipse.emf.emfstore.client.editingDomainProvider").getClass("class", EditingDomainProvider.class);
    }

    private Workspace createNewWorkspace(ResourceSet resourceSet, URI fileURI) {
        final Resource resource = resourceSet.createResource(fileURI);
        final Workspace workspace = ModelFactory.eINSTANCE.createWorkspace();
        workspace.getServerInfos().addAll(Configuration.getDefaultServerInfos());
        EList<Usersession> usersessions = workspace.getUsersessions();
        for (ServerInfo serverInfo : workspace.getServerInfos()) {
            Usersession lastUsersession = serverInfo.getLastUsersession();
            if (lastUsersession == null) continue;
            usersessions.add((Object)lastUsersession);
        }
        new EMFStoreCommand(){

            protected void doRun() {
                resource.getContents().add((Object)workspace);
            }
        }.run(true);
        try {
            resource.save(Configuration.getResourceSaveOptions());
        }
        catch (IOException e) {
            WorkspaceUtil.logException("Creating new workspace failed! Delete workspace folder: " + Configuration.getWorkspaceDirectory(), e);
        }
        try {
            int modelVersionNumber = ModelUtil.getModelVersionNumber();
            this.stampCurrentVersionNumber(modelVersionNumber);
        }
        catch (MalformedModelVersionException e1) {
            WorkspaceUtil.logException("Loading model version failed!", (Exception)((Object)e1));
        }
        return workspace;
    }

    private void stampCurrentVersionNumber(int modelReleaseNumber) {
        URI versionFileUri = URI.createFileURI((String)Configuration.getModelReleaseNumberFileName());
        Resource versionResource = new ResourceSetImpl().createResource(versionFileUri);
        ModelVersion modelVersion = org.eclipse.emf.emfstore.common.model.ModelFactory.eINSTANCE.createModelVersion();
        modelVersion.setReleaseNumber(modelReleaseNumber);
        versionResource.getContents().add((Object)modelVersion);
        try {
            versionResource.save(Configuration.getResourceSaveOptions());
        }
        catch (IOException e) {
            WorkspaceUtil.logException("Version stamping workspace failed! Delete workspace folder: " + Configuration.getWorkspaceDirectory(), e);
        }
    }

    private void migrateModel(ResourceSet resourceSet) {
        int modelVersionNumber;
        ModelVersion workspaceModelVersion = this.getWorkspaceModelVersion();
        try {
            modelVersionNumber = ModelUtil.getModelVersionNumber();
            this.stampCurrentVersionNumber(modelVersionNumber);
        }
        catch (MalformedModelVersionException e1) {
            WorkspaceUtil.logException("Loading model version failed, migration skipped!", (Exception)((Object)e1));
            return;
        }
        if (workspaceModelVersion.getReleaseNumber() == modelVersionNumber) {
            return;
        }
        if (workspaceModelVersion.getReleaseNumber() > modelVersionNumber) {
            this.backupAndRecreateWorkspace(resourceSet);
            WorkspaceUtil.logException("Model conforms to a newer version, update client! New workspace was backuped!", new IllegalStateException());
            return;
        }
        if (!EMFStoreMigratorUtil.isMigratorAvailable()) {
            WorkspaceUtil.logException("Model requires migration, but no migrators are registered!", new IllegalStateException());
            return;
        }
        this.backupWorkspace(false);
        File workspaceFile = new File(Configuration.getWorkspaceDirectory());
        File[] fileArray = workspaceFile.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.getName().startsWith(Configuration.getProjectSpaceDirectoryPrefix())) {
                String projectFilePath = String.valueOf(file.getAbsolutePath()) + File.separatorChar + Configuration.getProjectFolderName() + File.separatorChar + 0 + Configuration.getProjectFragmentFileExtension();
                URI projectURI = URI.createFileURI((String)projectFilePath);
                String operationsFilePath = null;
                File[] listFiles = file.listFiles();
                if (listFiles == null) {
                    WorkspaceUtil.logException("The migration of the project in projectspace at " + projectFilePath + " failed!", new IllegalStateException("Broken projectSpace!"));
                } else {
                    File[] fileArray2 = listFiles;
                    int n3 = listFiles.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        File subDirFile = fileArray2[n4];
                        if (subDirFile.getName().endsWith(Configuration.getOperationCompositeFileExtension())) {
                            operationsFilePath = subDirFile.getAbsolutePath();
                        }
                        ++n4;
                    }
                    if (operationsFilePath == null) {
                        WorkspaceUtil.logException("The migration of the project in projectspace at " + projectFilePath + " failed!", new IllegalStateException("Broken workspace!"));
                        this.backupAndRecreateWorkspace(resourceSet);
                    }
                    URI operationsURI = URI.createFileURI(operationsFilePath);
                    try {
                        this.migrate(projectURI, operationsURI, workspaceModelVersion.getReleaseNumber());
                    }
                    catch (EMFStoreMigrationException e) {
                        WorkspaceUtil.logException("The migration of the project in projectspace at " + projectFilePath + " failed!", (Exception)((Object)e));
                        this.backupAndRecreateWorkspace(resourceSet);
                    }
                }
            }
            ++n2;
        }
        this.stampCurrentVersionNumber(modelVersionNumber);
    }

    public void migrate(String absoluteFilename) {
        URI projectURI = URI.createFileURI((String)absoluteFilename);
        ArrayList<URI> modelURIs = new ArrayList<URI>();
        modelURIs.add(projectURI);
        ModelVersion workspaceModelVersion = this.getWorkspaceModelVersion();
        if (!EMFStoreMigratorUtil.isMigratorAvailable()) {
            ModelUtil.logWarning((String)"No Migrator available to migrate imported file");
            return;
        }
        try {
            EMFStoreMigratorUtil.getEMFStoreMigrator().migrate(modelURIs, workspaceModelVersion.getReleaseNumber() - 1, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (EMFStoreMigrationException e) {
            WorkspaceUtil.logWarning("The migration of the project in the file " + absoluteFilename + " failed!", (Exception)((Object)e));
        }
    }

    private void backupAndRecreateWorkspace(ResourceSet resourceSet) {
        this.backupWorkspace(true);
        URI fileURI = URI.createFileURI((String)Configuration.getWorkspacePath());
        this.createNewWorkspace(resourceSet, fileURI);
    }

    private void backupWorkspace(boolean move) {
        String workspaceDirectory = Configuration.getWorkspaceDirectory();
        File workspacePath = new File(workspaceDirectory);
        String newWorkspaceDirectory = String.valueOf(Configuration.getLocationProvider().getBackupDirectory()) + "emfstore_backup_" + System.currentTimeMillis();
        File workspacebackupPath = new File(newWorkspaceDirectory);
        if (move) {
            workspacePath.renameTo(workspacebackupPath);
        } else {
            try {
                FileUtil.copyDirectory((File)workspacePath, (File)workspacebackupPath);
            }
            catch (IOException e) {
                WorkspaceUtil.logException("Workspace backup failed!", e);
            }
        }
    }

    private ModelVersion getWorkspaceModelVersion() {
        File versionFile = new File(Configuration.getModelReleaseNumberFileName());
        if (!versionFile.exists()) {
            try {
                int modelVersionNumber = ModelUtil.getModelVersionNumber();
                this.stampCurrentVersionNumber(modelVersionNumber);
            }
            catch (MalformedModelVersionException e1) {
                WorkspaceUtil.logException("Loading model version failed!", (Exception)((Object)e1));
            }
        }
        URI versionFileUri = URI.createFileURI((String)Configuration.getModelReleaseNumberFileName());
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        try {
            Resource resource = resourceSet.getResource(versionFileUri, true);
            EList directContents = resource.getContents();
            ModelVersion modelVersion = (ModelVersion)directContents.get(0);
            return modelVersion;
        }
        catch (RuntimeException e) {
            ModelVersion modelVersion = org.eclipse.emf.emfstore.common.model.ModelFactory.eINSTANCE.createModelVersion();
            modelVersion.setReleaseNumber(4);
            return modelVersion;
        }
    }

    public Collection<EStructuralFeature.Setting> findInverseCrossReferences(EObject modelElement) {
        if (this.crossReferenceAdapter != null) {
            return this.crossReferenceAdapter.getInverseReferences(modelElement);
        }
        return EcoreUtil.UsageCrossReferencer.find((EObject)modelElement, (ResourceSet)this.resourceSet);
    }

    private void migrate(URI projectURI, URI changesURI, int sourceModelReleaseNumber) throws EMFStoreMigrationException {
        ArrayList<URI> modelURIs = new ArrayList<URI>();
        modelURIs.add(projectURI);
        modelURIs.add(changesURI);
        EMFStoreMigratorUtil.getEMFStoreMigrator().migrate(modelURIs, sourceModelReleaseNumber, (IProgressMonitor)new NullProgressMonitor());
    }

    public Workspace getCurrentWorkspace() {
        return this.currentWorkspace;
    }

    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public void setConnectionManager(ConnectionManager manager) {
        this.connectionManager = manager;
    }

    public AdminConnectionManager getAdminConnectionManager() {
        return this.adminConnectionManager;
    }

    public static ProjectSpace getProjectSpace(EObject modelElement) {
        if (modelElement == null) {
            throw new IllegalArgumentException("The model element is null");
        }
        if (modelElement instanceof ProjectSpace) {
            return (ProjectSpace)modelElement;
        }
        Project project = ModelUtil.getProject((EObject)modelElement);
        if (project == null) {
            throw new IllegalArgumentException("The model element " + modelElement + " has no project");
        }
        return WorkspaceManager.getProjectSpace(project);
    }

    public static ProjectSpace getProjectSpace(Project project) {
        if (project == null) {
            throw new IllegalArgumentException("The project is null");
        }
        if (ModelPackage.eINSTANCE.getProjectSpace().isInstance((Object)project.eContainer())) {
            return (ProjectSpace)project.eContainer();
        }
        throw new IllegalStateException("Project is not contained by any project space");
    }

    public static ObserverBus getObserverBus() {
        return WorkspaceManager.getInstance().observerBus;
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    static class ExtendedCrossReferenceAdapter
    extends ECrossReferenceAdapter {
        ExtendedCrossReferenceAdapter() {
        }

        protected void unsetTarget(EObject target) {
            super.unsetTarget(target);
            if (target instanceof ProjectSpace) {
                ProjectSpace projectSpace = (ProjectSpace)target;
                String pathToProject = String.valueOf(Configuration.getWorkspaceDirectory()) + Configuration.getProjectSpaceDirectoryPrefix() + projectSpace.getIdentifier();
                ArrayList<Resource> toDelete = new ArrayList<Resource>();
                for (Resource resource : this.unloadedResources) {
                    if (!resource.getURI().toFileString().startsWith(pathToProject)) continue;
                    toDelete.add(resource);
                }
                this.unloadedResources.removeAll(toDelete);
            }
        }
    }
}

