/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.editor.mecontrols.multiattributecontrol;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.databinding.edit.EMFEditObservables;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EDataTypeEList;
import org.eclipse.emf.ecp.common.commands.ECPCommand;
import org.eclipse.emf.ecp.editor.mecontrols.multiattributecontrol.MultiAttributeControl;
import org.eclipse.emf.edit.domain.EditingDomain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiAttributeController<T>
implements IChangeListener {
    private MultiAttributeControl parentItem;
    private EDataTypeEList<T> data;
    private ArrayList<T> localData;
    private IObservableValue model;

    MultiAttributeController(MultiAttributeControl parentItem, EDataTypeEList<T> data) {
        this.parentItem = parentItem;
        this.data = data;
        this.localData = new ArrayList();
        this.localData.addAll((Collection<T>)this.data);
        Object feature = parentItem.getItemPropertyDescriptor().getFeature((Object)parentItem.getModelElement());
        EAttribute attribute = (EAttribute)feature;
        this.model = EMFEditObservables.observeValue((EditingDomain)parentItem.getEditingDomain(), (EObject)parentItem.getModelElement(), (EStructuralFeature)attribute);
        this.model.addChangeListener((IChangeListener)this);
    }

    private MultiAttributeController() {
    }

    public boolean contains(T value) {
        return this.data.contains(value);
    }

    public void add(final T value) {
        this.localData.add(value);
        new ECPCommand(this.parentItem.getModelElement()){

            protected void doRun() {
                MultiAttributeController.this.data.add(value);
            }
        }.run(false);
    }

    public boolean removeElementAt(final int index) {
        if (index >= this.data.size() || index < 0) {
            return false;
        }
        this.localData.remove(index);
        new ECPCommand(this.parentItem.getModelElement()){

            protected void doRun() {
                MultiAttributeController.this.data.remove(index);
            }
        }.run(false);
        return true;
    }

    public boolean replaceElementAt(final int index, final T newValue) {
        if (index >= this.data.size() || index < 0) {
            return false;
        }
        this.localData.set(index, newValue);
        new ECPCommand(this.parentItem.getModelElement()){

            protected void doRun() {
                MultiAttributeController.this.data.set(index, newValue);
            }
        }.run(false);
        return true;
    }

    public Object[] getAllStoredElements() {
        return this.data.toArray();
    }

    public void handleChange(ChangeEvent event) {
        if (this.parentItem.getComposite().isDisposed()) {
            this.model.removeChangeListener((IChangeListener)this);
            return;
        }
        if (event.getSource() == this.model && !this.dataEqualsLocalData()) {
            this.parentItem.reInitializeWidget();
            this.localData.clear();
            this.localData.addAll((Collection<T>)this.data);
        }
    }

    private boolean dataEqualsLocalData() {
        return this.localData.equals(this.data);
    }
}

