/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.editor.mecontrols.multiattributecontrol;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecp.editor.mecontrols.AbstractMEControl;
import org.eclipse.emf.ecp.editor.mecontrols.multiattributecontrol.AttributeControl;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.Form;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MultiAttributeControl
extends AbstractMEControl {
    private static final int PRIORITY = 2;
    private int style;
    private int upperBound;
    private boolean isEditable;
    private boolean allowDuplicates;
    private ArrayList<AttributeControl> controlList = new ArrayList();
    private Composite composite;
    private GridLayout gridLayout;
    private Control emptyField;

    @Override
    public int canRender(IItemPropertyDescriptor itemPropertyDescriptor, EObject modelElement) {
        Object feature = itemPropertyDescriptor.getFeature((Object)modelElement);
        if (feature instanceof ETypedElement) {
            ETypedElement attr = (ETypedElement)feature;
            this.upperBound = attr.getUpperBound();
            if (this.upperBound == -1 || this.upperBound > 1) {
                return 2;
            }
            return -1;
        }
        return -1;
    }

    @Override
    public Control createControl(Composite parent, int style) {
        EStructuralFeature feature = (EStructuralFeature)this.getItemPropertyDescriptor().getFeature((Object)this.getModelElement());
        this.createDataStructures(feature);
        this.setStyle(style);
        this.setEditable(this.getItemPropertyDescriptor().canSetProperty((Object)this.getModelElement()));
        this.setAllowDuplicates(!feature.isUnique());
        this.setComposite(this.getToolkit().createComposite(parent, style | 0x800));
        this.configureGridLayout();
        this.getComposite().setLayout((Layout)this.gridLayout);
        if (!this.getItemPropertyDescriptor().canSetProperty((Object)this.getModelElement())) {
            this.getComposite().setEnabled(false);
        }
        this.upperBound = feature.getUpperBound();
        this.initializeWidget();
        return this.getComposite();
    }

    protected abstract void createDataStructures(EStructuralFeature var1);

    private void configureGridLayout() {
        this.gridLayout = new GridLayout(1, true);
        this.gridLayout.verticalSpacing = 0;
    }

    protected void initializeWidget() {
        Object[] objectArray = this.getAllStoredElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object i = objectArray[n2];
            this.createSingleField(i);
            ++n2;
        }
        if (!this.isFull() && this.isEditable()) {
            this.createSingleField();
        }
        this.refreshWidget();
    }

    protected void reInitializeWidget() {
        if (!this.isFull()) {
            this.emptyField.getParent().dispose();
        }
        while (!this.controlList.isEmpty()) {
            this.controlList.get(0).dispose();
            this.controlList.remove(0);
        }
        this.initializeWidget();
    }

    protected void refreshWidget() {
        Composite tmp = this.getComposite();
        while (!(tmp instanceof Form)) {
            tmp.layout();
            tmp = tmp.getParent();
        }
    }

    protected boolean isFull() {
        return this.getControlList().size() >= this.upperBound && this.upperBound != -1;
    }

    protected abstract void createSingleField(Object var1);

    protected abstract void createSingleField();

    public abstract Object[] getAllStoredElements();

    public void setControlList(ArrayList<AttributeControl> controlList) {
        this.controlList = controlList;
    }

    public ArrayList<AttributeControl> getControlList() {
        return this.controlList;
    }

    public void setStyle(int style) {
        this.style = style;
    }

    public int getStyle() {
        return this.style;
    }

    public void setAllowDuplicates(boolean allowDuplicates) {
        this.allowDuplicates = allowDuplicates;
    }

    public boolean isAllowDuplicates() {
        return this.allowDuplicates;
    }

    public void setComposite(Composite composite) {
        this.composite = composite;
    }

    public Composite getComposite() {
        return this.composite;
    }

    public void setEditable(boolean isEditable) {
        this.isEditable = isEditable;
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    public void setEmptyField(Control emptyField) {
        this.emptyField = emptyField;
    }

    public Control getEmptyField() {
        return this.emptyField;
    }
}

