/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.editor.mecontrols.melinkcontrol.associationclasscontrol;

import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.common.Activator;
import org.eclipse.emf.ecp.common.model.ECPAssociationClassElement;
import org.eclipse.emf.ecp.common.model.ECPMetaModelElementContext;
import org.eclipse.emf.ecp.common.model.ECPModelelementContext;
import org.eclipse.emf.ecp.common.model.workSpaceModel.util.AssociationClassHelper;
import org.eclipse.emf.ecp.common.utilities.ModelElementClassTooltip;
import org.eclipse.emf.ecp.common.utilities.ShortLabelProvider;
import org.eclipse.emf.ecp.editor.ControlFactory;
import org.eclipse.emf.ecp.editor.ModelElementChangeListener;
import org.eclipse.emf.ecp.editor.mecontrols.AbstractMEControl;
import org.eclipse.emf.ecp.editor.mecontrols.melinkcontrol.MEHyperLinkAdapter;
import org.eclipse.emf.ecp.editor.mecontrols.melinkcontrol.MEHyperLinkDeleteAdapter;
import org.eclipse.emf.ecp.editor.mecontrols.melinkcontrol.MELinkControl;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IDecoratorManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public class AssociationClassLink
extends MELinkControl {
    private static final int PRIORITY = 2;
    private Composite composite;
    private ILabelProvider labelProvider;
    private ImageHyperlink imgHyperlink;
    private Hyperlink hyperlink;
    private Image deleteImage;
    private ModelElementChangeListener meChangeListener;
    private ModelElementChangeListener associationChangeListener;
    private IHyperlinkListener linkToMEListener;
    private MEHyperLinkDeleteAdapter delAssociationListener;
    private EObject association;
    private EObject modelElement;
    private EObject relatedModelElement;
    private List<EStructuralFeature> eAttribute;
    private ShortLabelProvider shortLabelProvider = new ShortLabelProvider();
    private EReference eReference;
    private Composite parent;
    private ComposedAdapterFactory adapterFactory;

    public int canRender(IItemPropertyDescriptor itemPropertyDescriptor, EObject link, EObject contextModelElement) {
        ECPAssociationClassElement association;
        Object ref = itemPropertyDescriptor.getFeature((Object)contextModelElement);
        if (this.getContext() != null && this.getContext().getMetaModelElementContext().isAssociationClassElement(link) && ref instanceof EReference && ((association = this.getContext().getMetaModelElementContext().getAssociationClassElement(link)).getSourceFeature().equals(((EReference)ref).getEOpposite()) || association.getTargetFeature().equals(((EReference)ref).getEOpposite()))) {
            return 2;
        }
        return -1;
    }

    public Control createControl(Composite parent, int style, IItemPropertyDescriptor itemPropertyDescriptor, EObject link, EObject contextModelElement, FormToolkit toolkit, ECPModelelementContext context) {
        this.association = link;
        this.modelElement = contextModelElement;
        this.eReference = (EReference)itemPropertyDescriptor.getFeature((Object)this.association);
        this.eAttribute = AssociationClassHelper.getAssociationFeatures((EObject)this.association, (ECPMetaModelElementContext)context.getMetaModelElementContext());
        this.toolkit = toolkit;
        this.setContext(context);
        this.parent = parent;
        this.createComponents(parent, style);
        this.setupComponents();
        return this.composite;
    }

    private boolean setupComponents() {
        boolean changed = false;
        if (this.composite != null && !this.composite.isDisposed()) {
            EObject newRelatedModelElement = AssociationClassHelper.getRelatedModelElement((EObject)this.modelElement, (EObject)this.association, (ECPModelelementContext)this.getContext());
            if (newRelatedModelElement != null && !newRelatedModelElement.equals(this.relatedModelElement)) {
                this.relatedModelElement = newRelatedModelElement;
                if (this.linkToMEListener != null) {
                    this.imgHyperlink.removeHyperlinkListener(this.linkToMEListener);
                    this.hyperlink.removeHyperlinkListener(this.linkToMEListener);
                }
                this.linkToMEListener = new MEHyperLinkAdapter(this.relatedModelElement, this.modelElement, this.eReference.getName());
                this.imgHyperlink.addHyperlinkListener(this.linkToMEListener);
                this.hyperlink.addHyperlinkListener(this.linkToMEListener);
                if (this.meChangeListener != null) {
                    this.meChangeListener.remove();
                }
                this.meChangeListener = new AssociationChangeListener(this.relatedModelElement);
            } else if (newRelatedModelElement == null && this.relatedModelElement != null) {
                this.relatedModelElement = newRelatedModelElement;
                this.imgHyperlink.removeHyperlinkListener(this.linkToMEListener);
                this.hyperlink.removeHyperlinkListener(this.linkToMEListener);
            }
            if (this.relatedModelElement != null) {
                this.imgHyperlink.setData((Object)this.relatedModelElement.eClass());
                String text = this.shortLabelProvider.getText((Object)this.relatedModelElement);
                this.hyperlink.setText(text);
                this.hyperlink.setToolTipText(text);
            } else {
                this.imgHyperlink.setData(null);
                this.hyperlink.setToolTipText("NULL");
                this.hyperlink.setText("NULL");
            }
            this.imgHyperlink.setImage(this.labelProvider.getImage((Object)this.relatedModelElement));
            changed = true;
        }
        return changed;
    }

    private void createComponents(Composite parent, int style) {
        this.composite = this.toolkit.createComposite(parent, style);
        this.composite.setLayout((Layout)new GridLayout(5, false));
        this.delAssociationListener = new MEHyperLinkDeleteAdapter(this.modelElement, this.eReference, this.association, this.getContext());
        this.associationChangeListener = new AssociationChangeListener(this.association);
        this.adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        AdapterFactoryLabelProvider adapterFactoryLabelProvider = new AdapterFactoryLabelProvider((AdapterFactory)this.adapterFactory);
        IDecoratorManager decoratorManager = PlatformUI.getWorkbench().getDecoratorManager();
        this.labelProvider = new DecoratingLabelProvider((ILabelProvider)adapterFactoryLabelProvider, decoratorManager.getLabelDecorator());
        this.imgHyperlink = this.toolkit.createImageHyperlink(this.composite, style);
        ModelElementClassTooltip.enableFor((Control)this.imgHyperlink);
        this.hyperlink = this.toolkit.createHyperlink(this.composite, "", style);
        if (this.eAttribute.size() == 1) {
            ControlFactory controlFactory = new ControlFactory();
            ItemPropertyDescriptor itemPropertyDescriptor = new ItemPropertyDescriptor(null, "", "", this.eAttribute.get(0));
            AbstractMEControl meControl = controlFactory.createControl((IItemPropertyDescriptor)itemPropertyDescriptor, this.association, this.getContext());
            meControl.createControl(this.composite, style, (IItemPropertyDescriptor)itemPropertyDescriptor, this.association, this.getContext(), this.toolkit);
        } else if (this.eAttribute.size() > 1) {
            Hyperlink associationLink = this.toolkit.createHyperlink(this.composite, "[edit]", style);
            associationLink.addHyperlinkListener((IHyperlinkListener)new MEHyperLinkAdapter(this.association, this.modelElement, this.eReference.getName()));
        }
        this.deleteImage = this.eReference.isContainment() && this.getContext().getMetaModelElementContext().isNonDomainElement(this.association.eClass()) ? Activator.getImageDescriptor((String)"icons/delete.gif").createImage() : PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE");
        ImageHyperlink delHyperlink = this.toolkit.createImageHyperlink(this.composite, style);
        delHyperlink.setImage(this.deleteImage);
        delHyperlink.addMouseListener((MouseListener)this.delAssociationListener);
    }

    public void dispose() {
        if (this.meChangeListener != null) {
            this.meChangeListener.remove();
        }
        if (this.associationChangeListener != null) {
            this.associationChangeListener.remove();
        }
        if (this.labelProvider != null) {
            this.labelProvider.dispose();
        }
        if (this.composite != null) {
            this.composite.dispose();
        }
        if (this.adapterFactory != null) {
            this.adapterFactory.dispose();
        }
        super.dispose();
    }

    private class AssociationChangeListener
    extends ModelElementChangeListener {
        public AssociationChangeListener(EObject modelElement) {
            super(modelElement);
        }

        public void onChange(Notification notification) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (AssociationClassLink.this.setupComponents()) {
                        AssociationClassLink.this.composite.pack();
                        AssociationClassLink.this.composite.layout(true);
                        AssociationClassLink.this.parent.getParent().layout(true);
                    }
                }
            });
        }
    }
}

