/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.editor.mecontrols.melinkcontrol;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.common.model.ECPModelelementContext;
import org.eclipse.emf.ecp.editor.Activator;
import org.eclipse.emf.ecp.editor.mecontrols.melinkcontrol.MELinkControl;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MELinkControlFactory {
    private HashMap<Class<?>, ArrayList<MELinkControl>> controlRegistry = new HashMap();

    public MELinkControlFactory() {
        this.initializeMEControls();
    }

    private void initializeMEControls() {
        IConfigurationElement[] linkControls;
        IConfigurationElement[] iConfigurationElementArray = linkControls = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.emf.ecp.editor.melinkcontrols");
        int n = linkControls.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            String type = e.getAttribute("type");
            try {
                Class<?> resolvedType = Class.forName(type);
                MELinkControl control = (MELinkControl)e.createExecutableExtension("class");
                ArrayList<MELinkControl> list = this.controlRegistry.get(resolvedType);
                if (list == null) {
                    list = new ArrayList();
                }
                list.add(control);
                this.controlRegistry.put(resolvedType, list);
            }
            catch (ClassNotFoundException e1) {
                Activator.logException(e1);
            }
            catch (CoreException e2) {
                Activator.logException((Exception)((Object)e2));
            }
            ++n2;
        }
    }

    public MELinkControl createMELinkControl(IItemPropertyDescriptor itemPropertyDescriptor, EObject link, EObject contextModelElement) {
        return this.createMELinkControl(itemPropertyDescriptor, link, contextModelElement, null);
    }

    public MELinkControl createMELinkControl(IItemPropertyDescriptor itemPropertyDescriptor, EObject link, EObject contextModelElement, ECPModelelementContext context) {
        ArrayList<MELinkControl> candidates = new ArrayList<MELinkControl>();
        Set<Class<?>> keySet = this.controlRegistry.keySet();
        for (Class<?> clazz : keySet) {
            if (!clazz.isAssignableFrom(link.getClass())) continue;
            candidates.addAll((Collection<MELinkControl>)this.controlRegistry.get(clazz));
        }
        MELinkControl control = this.getBestCandidate(candidates, itemPropertyDescriptor, link, contextModelElement, context);
        if (control != null) {
            try {
                return (MELinkControl)control.getClass().newInstance();
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return new MELinkControl();
    }

    private MELinkControl getBestCandidate(ArrayList<MELinkControl> candidates, IItemPropertyDescriptor itemPropertyDescriptor, EObject link, EObject contextModelElement, ECPModelelementContext context) {
        int bestValue = 0;
        MELinkControl bestCandidate = null;
        for (MELinkControl abstractMEControl : candidates) {
            abstractMEControl.setContext(context);
            int newValue = abstractMEControl.canRender(itemPropertyDescriptor, link, contextModelElement);
            if (newValue <= bestValue) continue;
            bestCandidate = abstractMEControl;
            bestValue = newValue;
        }
        return bestCandidate;
    }
}

